/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Filters.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
public class Filters extends CoreLibrary {
  public final static int FIRKAIS_LOW = 1, FIRKAIS_HIGH = 2, FIRKAIS_BAND = 3;
  public static double sinx (double arg) {
    double num = sin (arg);
    if (fabs (arg) < 1e-20 && fabs (num) < 1e-20) return 1.0;
    return num / arg;
  }
  public static double besselIO (double x) {
    double ds = 1, d = 0, s = 1;
    for (;;) {
      d += 2;
      ds = (ds * x * x) / (d * d);
      s += ds;
      if (ds - (s * 0.2e-8) < 0) break;
    }
    return s;
  }
  public static int genFirKais (int type, double f1, double f2, double f3, double attn, float[] filt, int ntap) {
    double fcntr, fpass, ftnbw, fsamp, mtap, beta, alpha, fcut, wcut, den, strt, lo, pcos, psin, resp, factor, wind;
    int i;
    fcntr = f1;
    fpass = (type == FIRKAIS_BAND) ? f2 * 0.5 : f1;
    ftnbw = f3;
    fsamp = 2.0;
    mtap = (attn - 8) / (2.285 * 2 * PI * ftnbw / fsamp);
    if (ntap <= 0) ntap = (int) (mtap + 1.5);
    if (ntap <= 0) return 0;
    if (attn > 50.0) beta = 0.1102 * (attn - 8.7);
    else if (attn >= 21.0) beta = 0.58420 * pow (attn - 21.0, 0.4) + 0.07886 * (attn - 21.0);
    else beta = 0.0;
    alpha = 0.5 * (ntap - 1);
    fcut = (type == FIRKAIS_HIGH) ? fpass - 0.5 * ftnbw : fpass + 0.5 * ftnbw;
    fcut /= fsamp;
    wcut = 2 * PI * fcut;
    den = besselIO (beta);
    if (type != FIRKAIS_BAND) fcntr = 0;
    strt = -0.5 * (ntap - 1);
    lo = 2.0 * PI * fcntr / fsamp;
    for (i = 0; i < ntap; i ++) {
      pcos = cos ((strt + i) * lo);
      psin = sin ((strt + i) * lo);
      resp = 2.0 * fcut * sinx (wcut * (i - alpha));
      if (type == FIRKAIS_HIGH) resp = sinx (PI * (i - alpha)) - resp;
      factor = sqrt (1.0 - pow ((1.0 * i - alpha) / alpha, 2.0));
      wind = besselIO (beta * factor) / den;
      filt[i+i+0] = (float) (wind * resp * pcos);
      filt[i+i+1] = (float) (wind * resp * psin);
    }
    return ntap;
  }
  public static double sincfunc (double x) {
    double num = sin (x);
    double sinc = 1.0;
    if (fabs (num) > 1e-20 && fabs (x) > 1e-20) sinc = num / x;
    return sinc;
  }
  public static float[] genWindowFilter (int len, int wtype, int ftype, double freq1, double freq2, double fs) {
    double win, alpha, halfbw, outfc, ideal;
    int i;
    float[] filt = new float[len];
    freq1 /= fs;
    freq2 /= fs;
    alpha = 0.5 * (len - 1);
    for (i = 0; i < len; i ++) {
      win = 1.0;
      if (wtype == 1) win = 0.50 - 0.50 * cos (i * PI / alpha);
      if (wtype == 2) win = 0.54 - 0.46 * cos (i * PI / alpha);
      ideal = 2.0 * freq1 * sincfunc (TWOPI * freq1 * (i - alpha));
      if (ftype == 2) ideal = sincfunc (PI * (i - alpha)) - ideal;
      filt[i] = (float) (win * ideal);
    }
    return filt;
  }
  public static int applyCompensation (float alpha, float[] filt, int n) {
    float c0 = - alpha / 2, c1 = 1.0F + alpha, c2 = - alpha / 2;
    float f0, f1 = filt[n-1], f2 = filt[0], fx = f2;
    int i;
    for (i = 0; i < n; i ++) {
      f0 = f1;
      f1 = f2;
      f2 = (i == n - 1) ? fx : filt[i+1];
      filt[i] = f0 * c0 + f1 * c1 + f2 * c2;
    }
    return n;
  }
  public static int genLinearSlope (double attn, float[] filt, int ntap) {
    int n = ntap;
    return n;
  }
  public static class Smooth extends CoreComponent {
    int mlen, mask;
    int offa, offb;
    float scale;
    double fx;
    float[] ax;
    boolean full;
    float ival;
    public void setLength (int length) {
      int len = length;
      if (len > mask) {
        System.out.printf ("Smoother length reduced from desired len=%d to max len=%d\n", len, mask);
        len = mask;
      }
      scale = 1.0F / len;
      offa = 0;
      offb = (offa - len) & mask;
      full = false;
      fx = 0;
      ival = 0;
    }
    public void setInitial (float val) {
      ival = val;
      fx = ival / scale;
    }
    public Smooth (int ORDER) {
      mlen = 1 << ORDER;
      mask = (mlen - 1);
      ax = new float[mlen];
      setLength (mlen - 1);
      setInitial (0.0F);
    }
    public float process (float fin, boolean valid) {
      float fa, fb;
      fa = fin;
      ax[offa] = fin;
      fb = full ? ax[offb] : ival;
      full = full || (offb == mask);
      if (valid) {
        offa = (offa + 1) & mask;
        offb = (offb + 1) & mask;
        fx += f2d (fa - fb);
      }
      return d2f (fx * scale);
    }
    public final static String handleAuto = "sets,process=iix3";
    public final static String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";
  }
  public static class SmoothP2 extends CoreComponent {
    int mlen, mask;
    int offa, offb;
    int olen;
    int lx;
    int[] ax;
    boolean full;
    public void reset () {
      int len = (1 << olen);
      offa = 0;
      offb = (offa - len + 1) & mask;
      full = false;
      lx = 0;
    }
    public void setLength (int length) {
      int len = 1;
      for (olen = 0; len < length; olen ++, len *= 2);
      if (len != length) {
        System.out.printf ("Smoother length modified from desired len=%d to power2 len=%d\n", length, len);
      }
      reset ();
    }
    public SmoothP2 (int ORDER) {
      mlen = 1 << ORDER;
      mask = (mlen - 1);
      ax = new int[mlen];
      olen = ORDER;
      reset ();
    }
    public float process (float fin, boolean valid) {
      int lin, fa, fb;
      lin = F2K (fin);
      fa = lin;
      ax[offa] = lin;
      fb = full ? ax[offb] : 0;
      full = full || (offb == mask);
      if (valid) {
        offa = (offa + 1) & mask;
        offb = (offb + 1) & mask;
        lx += (fa - fb);
      }
      return K2F (lx >> olen);
    }
    public final static String handleAuto = "sets,process=iix3";
    public final static String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";
  }
  public static class SmoothP2X extends CoreComponent {
    int shift, mshft;
    float val, scale;
    public SmoothP2X (int ORDER) {
      val = 0;
      shift = ORDER;
      scale = 1.0F - 1.0F / (1 << shift);
    }
    public void reset () {
      val = 0;
    }
    public float process (float fin, boolean valid) {
      if (valid) {
        val = val * scale + divfp2 (mulfp2 (fin, 8), shift);
      }
      return divfp2 (val, 8);
    }
    public final static String handleAuto = "sets,process=iix1";
    public final static String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=1,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";
  }
  public static class CxCIC extends CoreComponent {
    int O_CIC, O_DEC;
    int count, decm;
    int coarse, fine;
    long[] pix, piy;
    int[] pox, poy, pdx, pdy;
    public void setGain (int gain) {
      int dec = decm + 1;
      int shift = (int) (5.0 * log2 ((double) dec / 4) + 9) - d2i (gain / 6.0);
      if (shift < 0) shift = 0;
      if (shift >= 32) {
        coarse = 31;
        fine = shift - 31;
      }
      else {
        coarse = shift;
        fine = 0;
      }
    }
    public void setDecimation (int dec) {
      decm = dec - 1;
      count = decm;
      setGain (0);
    }
    public CxCIC (int ocic, int odec) {
      O_CIC = ocic;
      O_DEC = odec;
      pix = new long[O_CIC+1];
      piy = new long[O_CIC+1];
      pox = new int[O_CIC+1];
      poy = new int[O_CIC+1];
      pdx = new int[O_CIC+1];
      pdy = new int[O_CIC+1];
      setDecimation (1 << odec);
    }
    public boolean process (CxFloat fi, CxFloat fo) {
      int ia, ib;
      boolean out;
      long pox0, poy0;
      for (ia = O_CIC; ia >= 0; ia --) {
        pix[ia] = (ia == 0) ? s2l (F2I (fi.x)) : pix[ia] + pix[ia-1];
        piy[ia] = (ia == 0) ? s2l (F2I (fi.y)) : piy[ia] + piy[ia-1];
      }
      out = (count == 0);
      count = (count == 0) ? decm : count - 1;
      if (out) {
        pox0 = pix[O_CIC] >> coarse;
        poy0 = piy[O_CIC] >> coarse;
        for (ib = O_CIC; ib >= 0; ib --) {
          pdx[ib] = pox[ib];
          pox[ib] = (ib == 0) ? l2i (pox0) : pox[ib-1] - pdx[ib-1];
          pdy[ib] = poy[ib];
          poy[ib] = (ib == 0) ? l2i (poy0) : poy[ib-1] - pdy[ib-1];
        }
        fo.x = K2F (pox[O_CIC] >> fine);
        fo.y = K2F (poy[O_CIC] >> fine);
      }
      return out;
    }
    public final static String handleAuto = "sets,process=iox4";
    public final static String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";
  }
  public static class CxComb extends CoreComponent {
    int off, lenm1;
    float fx, fy, scale;
    float[] ax, ay;
    boolean full;
    public void setLength (int length) {
      lenm1 = length - 1;
      scale = 1.0F / length;
    }
    public CxComb (int ORDER) {
      int len = 1 << ORDER;
      ax = new float[1<<ORDER];
      ay = new float[1<<ORDER];
      full = false;
      lenm1 = len - 1;
      scale = 1.0F / len;
      off = 0;
    }
    public boolean process (CxFloat fi, CxFloat fo) {
      float axi, ayi;
      float bxi, byi;
      axi = ! full ? 0 : ax[off];
      ayi = ! full ? 0 : ay[off];
      bxi = fi.x;
      byi = fi.y;
      ax[off] = fi.x;
      ay[off] = fi.y;
      fx = fx + bxi - axi;
      fy = fy + byi - ayi;
      fo.x = fx * scale;
      fo.y = fy * scale;
      full = full || (off == lenm1);
      off = (off < lenm1) ? off + 1 : 0;
      return full;
    }
    public final static String handleAuto = "sets,process=iox4";
    public final static String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";
  }
  public static class CxIIRStageO1 extends CoreComponent {
    float b0, b1, b2, a1, a2;
    public void open (int order, float gfact, float p1, float z1, float p2, float z2) {
      int ord = order;
      b0 = gfact;
      b1 = - ord * z1;
      b2 = - ord * z2;
      a1 = - ord * p1;
      a2 = - ord * p2;
    }
    public int process (CxFloat fi, CxFloat fo, float axM, float ayM, float naxM, float nayM) {
      float tax, tay, tbx, tby;
      tax = naxM * a1 - nayM * a2;
      tay = nayM * a1 + naxM * a2;
      tbx = axM * b1 - ayM * b2 + fi.x;
      tby = ayM * b1 + axM * b2 + fi.y;
      fo.x = tbx * b0 - tax;
      fo.y = tby * b0 - tay;
      return 1;
    }
    public final static String handleAuto = "sets,process=iOiiiix2";
    public final static String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,x=2,%2==$fo,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,o:process_ret";
  }
  public static class CxIIRStageO2 extends CoreComponent {
    float b0, b1, b2, a1, a2;
    public void open (int order, float gfact, float p1, float z1, float p2, float z2) {
      int ord = order;
      b0 = gfact;
      b1 = - ord * z1;
      b2 = (z1 * z1 + z2 * z2);
      a1 = - ord * p1;
      a2 = (p1 * p1 + p2 * p2);
    }
    public int process (CxFloat fi, CxFloat fo, float axM, float ayM, float naxM, float nayM, float ax2M, float ay2M, float nax2M, float nay2M) {
      float tax, tay, tbx, tby;
      tax = naxM * a1 + nax2M * a2;
      tay = nayM * a1 + nay2M * a2;
      tbx = axM * b1 + ax2M * b2 + fi.x;
      tby = ayM * b1 + ay2M * b2 + fi.y;
      fo.x = tbx * b0 - tax;
      fo.y = tby * b0 - tay;
      return 1;
    }
    public final static String handleAuto = "sets,process=iOiiiiiiiix3";
    public final static String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,$ax2M=%7,$ay2M=%8,$nax2M=%9,$nay2M=%10,x=3,%2==$fo,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,i:fptx:ax2M,i:fptx:ay2M,i:fptx:nax2M,i:fptx:nay2M,o:process_ret";
  }
  public static class CxIIR extends CoreComponent {
    int ORD, STR, LEN, LENM1;
    CxIIRStageO1 s1, s2, s3;
    CxFloat c1, c2;
    int iN, iM, i2M;
    float[] ax1, ax2, ax3, ax4;
    float[] ay1, ay2, ay3, ay4;
    public CxIIR (int ORDER, int STRIDE) {
      int i;
      ORD = ORDER;
      STR = STRIDE;
      LEN = STR * 2;
      LENM1 = LEN - 1;
      s1 = new CxIIRStageO1 ();
      s2 = new CxIIRStageO1 ();
      s3 = new CxIIRStageO1 ();
      c1 = new CxFloat ();
      c2 = new CxFloat ();
      ax1 = new float[LEN];
      ay1 = new float[LEN];
      ax2 = new float[LEN];
      ay2 = new float[LEN];
      ax3 = new float[LEN];
      ay3 = new float[LEN];
      ax4 = new float[LEN];
      ay4 = new float[LEN];
    }
    public void open (int order, float gain, float[] poles, float[] zeros) {
      int stages = 3;
      float gfact = powf (gain * 8, 1.0F / stages);
      if (order == 3) {
        s3.open (1, gfact, poles[4], zeros[4], 0.0F, 0.0F);
        s2.open (1, gfact, poles[2], zeros[2], poles[3], zeros[3]);
        s1.open (1, gfact, poles[0], zeros[0], poles[1], zeros[1]);
      }
      else if (order == 5) {
        s3.open (1, gfact, poles[8], zeros[8], 0.0F, 0.0F);
        s2.open (2, gfact, poles[4], zeros[4], poles[5], zeros[5]);
        s1.open (2, gfact, poles[0], zeros[0], poles[1], zeros[1]);
      }
      else {
        System.out.printf ("Unsupported IIR filter order=%d\n", order);
      }
      iN = 0;
      iM = (LEN - STR);
      i2M = 0;
    }
    public int process (CxFloat ci, CxFloat co) {
      ax1[iN] = ci.x;
      ay1[iN] = ci.y;
      s1.process (ci, c1, ax1[iM], ay1[iM], ax2[iM], ay2[iM]);
      ax2[iN] = c1.x;
      ay2[iN] = c1.y;
      s2.process (c1, c2, ax2[iM], ay2[iM], ax3[iM], ay3[iM]);
      ax3[iN] = c2.x;
      ay3[iN] = c2.y;
      s3.process (c2, co, ax3[iM], ay3[iM], ax4[iM], ay4[iM]);
      ax4[iN] = co.x;
      ay4[iN] = co.y;
      iN = (iN == LENM1) ? 0 : iN + 1;
      iM = (iM == LENM1) ? 0 : iM + 1;
      i2M = (i2M == LENM1) ? 0 : i2M + 1;
      return 1;
    }
    public final static String handleAuto = "sets,process=iox10";
    public final static String handleMethod_process = "$process_ena=T,$ci=%1,x=10,%2=$co,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:ci,o:CxFptx:co,o:process_ret";
  }
  public static class CxPhasePLL extends CoreComponent {
    int BNSHF;
    float B0, B1, adl;
    double nco, uF;
    public CxPhasePLL () {
      BNSHF = 20;
    }
    public void setup (double K, double bw, double Zeta, double Fs) {
      double wn = bw * PI / Zeta;
      double Tau1 = K / (wn * wn);
      double Tau2 = 2 * Zeta / wn;
      B0 = mulfp2 ((float) ((1.0 / (2.0 * Tau1 * Fs * Fs)) * (1 + 1.0 / tan (1.0 / (2.0 * Tau2 * Fs)))), BNSHF);
      B1 = mulfp2 ((float) ((1.0 / (2.0 * Tau1 * Fs * Fs)) * (1 - 1.0 / tan (1.0 / (2.0 * Tau2 * Fs)))), BNSHF);
      adl = 0;
      uF = 0;
    }
    public float process (CxFloat fi) {
      float ap, ad;
      ap = atan2cf (fi.y, fi.x);
      ad = wrapf (ap - d2f (nco));
      nco = frac (nco + divp2 (uF, BNSHF));
      uF += f2d (B0 * ad + B1 * adl);
      adl = ad;
      return d2f (nco);
    }
    public final static String handleAuto = "sets,process=ix4";
    public final static String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%0=$process_ret";
    public final static String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:fptx:process_ret";
  }
}
