/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FSVI.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
public class FSVI extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(BUFFER); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(BUFFER); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(BUFFER); } }

public final static int FLOW = BUFFER, BW = 32, MFFT = 16384;
public final static String flgList = "Mag,Log,Exp,Fix,MaxM,PSD";
public final static int PF_MAG = 0, PF_LOG = 1, PF_EXP = 2, PF_FIX = 3, PF_MAXM = 4, PF_PSD = 5;
public static class CORE extends Core {
  int nexp, navg;
  float scale;
  int flags;
  int frame;
  int npkp, mavg, iavg;
  int bxfer;
  float p0, p1, lscl, vadd, vmin;
  float[] exbuf;
  float[] avbuf;
  boolean doReset;
  public void setPz () {
    int n = (nexp <= 0) ? 1 : nexp;
    if (npkp > 0) n = npkp * navg;
    p0 = 1.0F / n;
    p1 = 1.0F - p0;
    mavg = navg - 1;
    doReset = true;
    putVars ("p0,p1,mavg,npkp");
  }
  public int init () {
    frame = 256;
    flags = 0;
    scale = 1.0F;
    vadd = 0.0F;
    vmin = 1.0F;
    nexp = 1;
    navg = 1;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "L:FRAME")) frame = value.toL ();
    else if (isMatch (key, "L:NEXP")) {
      nexp = value.toL ();
      setPz ();
    }
    else if (isMatch (key, "L:NAVG")) {
      navg = value.toL ();
      setPz ();
    }
    else if (isMatch (key, "L:NPKP")) {
      npkp = value.toL ();
      setPz ();
    }
    else if (isMatch (key, "F:SCALE")) {
      scale = value.toF ();
      setPz ();
    }
    else if (isMatch (key, "F:VADD")) vadd = value.toF ();
    else if (isMatch (key, "F:VMIN")) vmin = value.toF ();
    else if (isMatch (key, "L:FLAGS")) flags = value.toL ();
    else if (isMatch (key, "S:FLAGS")) flags = value.toMask (flgList);
    else if (isMatch (key, "L:RESET")) doReset = true;
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:FRAME")) value.fromL (frame);
    else if (isMatch (key, "L:NEXP")) value.fromL (nexp);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    exbuf = new float[MFFT];
    avbuf = new float[MFFT];
    bxfer = frame * 4;
    setPz ();
    lscl = 20.0F;
    iavg = 0;
    this.halo.state=1;
    return 0;
  }
  public int process (Buffer bi, Buffer bo) {
    int i;
    float a, b, c, d, e, f;
    boolean doLog, doMax, doMin, doRes;
    doRes = doReset;
    doLog = getBit(flags, PF_LOG);
    doMax = getBit(flags, PF_MAXM);
    doMin = doRes || (getBit(flags, PF_MAXM) && (npkp == 0));
    bi.rokLen (bxfer);
    bo.wokLen (bxfer);
    if (! bi.rok || ! bo.wok) {
      return 0;
    }
    i = 0;
    while (i < frame) {
      a = bi.getL (i << 2) * scale;
      b = exbuf[i];
      c = b * p1 + a * p0;
      exbuf[i] = doMin ? vmin : (doMax && a > b) ? a : (npkp < 0) ? b : c;
      d = (c < vmin) ? vmin : exbuf[i];
      e = log10f (d);
      f = doLog ? lscl * e : d;
      bo.setF (i << 2, f + vadd);
      i ++;
    }
    bi.rnxt (bxfer);
    if (iavg == 0) {
      bo.wnxt (bxfer);
    }
    iavg = (iavg >= mavg) ? 0 : iavg + 1;
    if (doRes) {
      doReset = false;
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
