/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FSVI.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME FSVI
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 2
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { FSVI_MFFT = 16384 };
static char* FSVI_flgList = "Mag,Log,Exp,Fix,MaxM,PSD";
enum { FSVI_PF_MAG = 0 };
enum { FSVI_PF_LOG = 1 };
enum { FSVI_PF_EXP = 2 };
enum { FSVI_PF_FIX = 3 };
enum { FSVI_PF_MAXM = 4 };
enum { FSVI_PF_PSD = 5 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 nexp;
  int_4 navg;
  real_4 scale;
  int_2 flags;
  int_2 frame;
  int_2 npkp;
  int_2 mavg;
  int_2 iavg;
  int_2 bxfer;
  real_4 p0;
  real_4 p1;
  real_4 lscl;
  real_4 vadd;
  real_4 vmin;
  real_4* exbuf;
  real_4* avbuf;
  int_1 doReset;
} FSVI;

#include "cores/CoreProtos.h"

/** CORE Code */

void* FSVI_alloc (char *config) {
  FSVI* plan = FSVI_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 FSVI_upload (FSVI* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,17);
  HW_loadInt  (planp,plan->nexp);
  HW_loadInt  (planp,plan->navg);
  HW_loadFlt  (planp,plan->scale);
  HW_loadInt  (planp,plan->flags);
  HW_loadInt  (planp,plan->frame);
  HW_loadInt  (planp,plan->npkp);
  HW_loadInt  (planp,plan->mavg);
  HW_loadInt  (planp,plan->iavg);
  HW_loadInt  (planp,plan->bxfer);
  HW_loadFlt  (planp,plan->p0);
  HW_loadFlt  (planp,plan->p1);
  HW_loadFlt  (planp,plan->lscl);
  HW_loadFlt  (planp,plan->vadd);
  HW_loadFlt  (planp,plan->vmin);
  HW_loadBuf  (planp,plan->exbuf,'f',0);
  HW_loadBuf  (planp,plan->avbuf,'f',0);
  HW_loadInt  (planp,plan->doReset);
  HW_push (planp,HW_OPEN);
  return 17;
}

void FSVI_setPz (FSVI* plan) {
  int_4 n = (plan->nexp <= 0) ? 1 : plan->nexp;
  if (plan->npkp > 0) n = plan->npkp * plan->navg;
  plan->p0 = 1.0F / n;
  plan->p1 = 1.0F - plan->p0;
  plan->mavg = plan->navg - 1;
  plan->doReset = 1;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,9);HW_loadFlt(plan,plan->p0); HW_loadAddr(plan,10);HW_loadFlt(plan,plan->p1); HW_loadAddr(plan,6);HW_loadInt2(plan,plan->mavg); HW_loadAddr(plan,5);HW_loadInt2(plan,plan->npkp);  HW_push(plan,HW_UPD); }
}

int_4 FSVI_init (FSVI* plan) {
  plan->frame = 256;
  plan->flags = 0;
  plan->scale = 1.0F;
  plan->vadd = 0.0F;
  plan->vmin = 1.0F;
  plan->nexp = 1;
  plan->navg = 1;
  return 0;
}

int_4 FSVI_set (FSVI* plan, String* key, Value* value) {
  if (isMatch (key, "L:FRAME")) plan->frame = Value_toL (value);
  else if (isMatch (key, "L:NEXP")) {
    plan->nexp = Value_toL (value);
    FSVI_setPz (plan);
  }
  else if (isMatch (key, "L:NAVG")) {
    plan->navg = Value_toL (value);
    FSVI_setPz (plan);
  }
  else if (isMatch (key, "L:NPKP")) {
    plan->npkp = Value_toL (value);
    FSVI_setPz (plan);
  }
  else if (isMatch (key, "F:SCALE")) {
    plan->scale = Value_toF (value);
    FSVI_setPz (plan);
  }
  else if (isMatch (key, "F:VADD")) plan->vadd = Value_toF (value);
  else if (isMatch (key, "F:VMIN")) plan->vmin = Value_toF (value);
  else if (isMatch (key, "L:FLAGS")) plan->flags = Value_toL (value);
  else if (isMatch (key, "S:FLAGS")) plan->flags = Value_toMask (value, FSVI_flgList);
  else if (isMatch (key, "L:RESET")) plan->doReset = 1;
  else return Core_set (plan, key, value);
  return 0;
}

int_4 FSVI_get (FSVI* plan, String* key, Value* value) {
  if (isMatch (key, "L:FRAME")) Value_fromL (value, plan->frame);
  else if (isMatch (key, "L:NEXP")) Value_fromL (value, plan->nexp);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 FSVI_open (FSVI* plan) {
  plan->exbuf = zallocBuf(sizeof(real_4)*(FSVI_MFFT));
  plan->avbuf = zallocBuf(sizeof(real_4)*(FSVI_MFFT));
  plan->bxfer = plan->frame * 4;
  FSVI_setPz (plan);
  plan->lscl = 20.0F;
  plan->iavg = 0;
  FSVI_upload (plan);
  return 0;
}

int_4 FSVI_process (FSVI* plan, Buffer* bi, Buffer* bo) {
  int_2 i;
  real_4 a, b, c, d, e, f;
  int_1 doLog, doMax, doMin, doRes;
  doRes = plan->doReset;
  doLog = getBit(plan->flags, FSVI_PF_LOG);
  doMax = getBit(plan->flags, FSVI_PF_MAXM);
  doMin = doRes || (getBit(plan->flags, FSVI_PF_MAXM) && (plan->npkp == 0));
  Buffer_rokLen (bi, plan->bxfer);
  Buffer_wokLen (bo, plan->bxfer);
  if (! bi->rok || ! bo->wok) {
    return 0;
  }
  i = 0;
  while (i < plan->frame) {
    a = Buffer_getL (bi, i << 2) * plan->scale;
    b = plan->exbuf[i];
    c = b * plan->p1 + a * plan->p0;
    plan->exbuf[i] = doMin ? plan->vmin : (doMax && a > b) ? a : (plan->npkp < 0) ? b : c;
    d = (c < plan->vmin) ? plan->vmin : plan->exbuf[i];
    e = log10f (d);
    f = doLog ? plan->lscl * e : d;
    Buffer_setF (bo, i << 2, f + plan->vadd);
    i ++;
  }
  Buffer_rnxt (bi, plan->bxfer);
  if (plan->iavg == 0) {
    Buffer_wnxt (bo, plan->bxfer);
  }
  plan->iavg = (plan->iavg >= plan->mavg) ? 0 : plan->iavg + 1;
  if (doRes) {
    plan->doReset = 0;
  }
  return 0;
}

int_4 FSVI_close (FSVI* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 FSVI_poll (FSVI* plan) { return 0; }

int_4 FSVI_free (FSVI* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

FSVI* FSVI_subCore (HALO* halo, int_4 scid) {
  FSVI* plan = FSVI_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  FSVI_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
