/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FEC.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"

/** Define Signatures */
#define CORE_NAME FEC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { FEC_MO = 9 };
enum { FEC_OLUT = 12 };
enum { FEC_NLUT = 1 << FEC_OLUT };
enum { FEC_LRSPM = 0x2000023 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 alg;
  int_4 len;
  int_4 scr;
  int_4 bpw;
  int_4 upp;
  int_u2 polyA;
  int_u2 polyB;
  int_u2 shft;
  int_u2 mask;
  int_u2 mfr;
  int_u2 ifr;
  int_u1 punc;
  int_u1 ipunc;
  int_u1 mpunc;
  int_u4 errs;
  int_u2* elut;
  int_u1 ilen;
  int_u1 olen;
  int_u1 flgs;
  int_u1 scrc;
  int_u4 scrv;
  int_u1 gmask;
  int_u4 lrsc;
  int_u4 lrsp;
  int_u1 uv;
} FEC;

#include "cores/CoreProtos.h"

/** CORE Code */

void* FEC_alloc (char *config) {
  FEC* plan = FEC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 FEC_upload (FEC* plan) {
  void *planp=(void*)plan;
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,20);
  HW_loadInt  (planp,plan->polyA);
  HW_loadInt  (planp,plan->polyB);
  HW_loadInt  (planp,plan->shft);
  HW_loadInt  (planp,plan->mask);
  HW_loadInt  (planp,plan->mfr);
  HW_loadInt  (planp,plan->ifr);
  HW_loadInt  (planp,plan->punc);
  HW_loadInt  (planp,plan->ipunc);
  HW_loadInt  (planp,plan->mpunc);
  HW_loadInt  (planp,plan->errs);
  HW_loadBuf  (planp,plan->elut,'s',1);
  HW_loadInt  (planp,plan->ilen);
  HW_loadInt  (planp,plan->olen);
  HW_loadInt  (planp,plan->flgs);
  HW_loadInt  (planp,plan->scrc);
  HW_loadInt  (planp,plan->scrv);
  HW_loadInt  (planp,plan->gmask);
  HW_loadInt  (planp,plan->lrsc);
  HW_loadInt  (planp,plan->lrsp);
  HW_loadInt  (planp,plan->uv);
  HW_push (planp,HW_OPEN);
  return 20;
}

void FEC_setLength (FEC* plan, int_4 length) {
  plan->len = length;
}

void FEC_optimize (FEC* plan) {
  if (getBit(plan->flgs, 0)) plan->elut = zallocBuf(sizeof(int_u2)*(8));
}

int_4 FEC_init (FEC* plan) {
  plan->len = 0;
  plan->mfr = 0;
  plan->alg = Modefs_FEC_NONE;
  plan->upp = 0;
  plan->scr = -1;
  plan->bpw = -1;
  plan->lrsp = 0;
  plan->lrsc = 0;
  return 0;
}

int_4 FEC_set (FEC* plan, String* key, Value* value) {
  if (isMatch (key, "S:ALG")) plan->alg = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "S:FEC")) plan->alg = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "S:SCR")) plan->scr = Value_toItem (value, Modefs_scrList);
  else if (isMatch (key, "L:LEN")) plan->len = Value_toL (value);
  else if (isMatch (key, "L:BPW")) plan->bpw = Value_toL (value);
  else if (isMatch (key, "L:LRSP")) plan->lrsp = Value_toL (value);
  else if (isMatch (key, "L:LRSI")) plan->lrsc = Value_toL (value);
  else if (isMatch (key, "L:VFLG"));
  else if (isMatch (key, "L:ERRS")) plan->errs = Value_toL (value);
  else if (isMatch (key, "L:UPP")) plan->upp = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 FEC_get (FEC* plan, String* key, Value* value) {
  if (isMatch (key, "L:ALG")) Value_fromL (value, plan->alg);
  else if (isMatch (key, "L:LEN")) Value_fromL (value, plan->len);
  else if (isMatch (key, "L:SCR")) Value_fromL (value, plan->scr);
  else if (isMatch (key, "L:ERRS")) Value_fromL (value, plan->errs);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 FEC_open (FEC* plan) {
  int_4 iom;
  plan->elut = zallocBuf(sizeof(int_u2)*(FEC_NLUT));
  iom = Modems_getFECLUT (plan->alg, plan->upp, plan->elut, null);
  plan->ilen = (iom >> 0) & 0xFF;
  plan->olen = (iom >> 8) & 0xFF;
  plan->mask = (iom >> 16) & 0xFFF;
  plan->mpunc = (iom >> 28) & 0xF;
  plan->gmask = (1 << plan->ilen) - 1;
  plan->ifr = 0;
  plan->shft = 0;
  plan->ipunc = plan->mpunc;
  plan->scrv = 0;
  plan->flgs = 0;
  if (plan->scr < 0) plan->scr = (plan->alg == Modefs_FEC_NONE) ? Modefs_SCR_LRS : Modefs_SCR_NONE;
  if (plan->scr > Modefs_SCR_LRS) {
    plan->flgs |= 0x4;
    if (plan->alg == Modefs_FEC_NONE) plan->ilen = plan->olen = 1;
  }
  if (plan->alg == Modefs_FEC_NONE && plan->scr <= Modefs_SCR_LRS) {
    plan->flgs |= 0x1;
    plan->ilen = plan->olen = 32;
  }
  if (plan->len > 0) {
    plan->flgs |= 0x2;
    plan->mfr = plan->len - 1;
  }
  if (plan->bpw == 0) plan->flgs |= 0x8;
  if (plan->alg >= Modefs_FEC_TCM) plan->flgs |= 0x10;
  if (plan->lrsp == 0 || plan->lrsp == - 1) plan->lrsp = FEC_LRSPM;
  FEC_optimize (plan);
  if(plan->halo.vbpr&1)printf ("FEC alg=%d scr=%x len=%d ilen=%d olen=%d flgs=%x punc=%d\n", plan->alg, plan->scr, plan->len, plan->ilen, plan->olen, plan->flgs, plan->mpunc + 1);
  FEC_upload (plan);
  return 0;
}

int_4 FEC_process (FEC* plan, Stream* si, Stream* so) {
  int_u2 olut;
  int_u2 ilut;
  int_u2 imask;
  int_u4 bi;
  int_u1 bix;
  int_u1 otcm3;
  int_u1 biy, otcm2;
  int_u1 qtcm, scrv0;
  int_1 bypass, framed, reframe, scramb, gen, tcm;
  bypass = getBit(plan->flgs, 0);
  framed = getBit(plan->flgs, 1);
  scramb = getBit(plan->flgs, 2);
  gen = getBit(plan->flgs, 3);
  tcm = getBit(plan->flgs, 4);
  while ((gen || si->rok) && so->wok) {
    if (! gen) {
      bi = Stream_rdBits (si, plan->ilen);
    }
    else {
      bi = plan->lrsc & plan->gmask;
      plan->lrsc = iLRSP (plan->lrsc, plan->lrsp);
    }
    if (bypass) {
      Stream_wrBits (so, plan->olen, bi);
    }
    else {
      reframe = framed && (plan->ifr == 0);
      plan->ifr = (plan->ifr == plan->mfr) ? 0 : plan->ifr + 1;
      imask = reframe ? 0 : plan->mask;
      scrv0 = getBits(bi, 0, 0) ^ (reframe ? 0 : getBits(plan->scrv, 3, 3) ^ getBits(plan->scrv, 20, 20) ^ ((plan->scrc == 31) ? 1 : 0));
      plan->scrc = reframe ? 0 : (getBit(plan->scrv, 1) != getBit(plan->scrv, 9)) ? 0 : plan->scrc + 1;
      plan->scrv = (scrv0 << 1) | (reframe ? 0 : (plan->scrv << 1));
      bix = tcm ? bi >> 1 : scramb ? scrv0 : bi;
      biy = bi & 1;
      plan->shft = ((plan->shft << 1) & imask) | bix;
      plan->ipunc = (plan->ipunc >= plan->mpunc) ? 0 : plan->ipunc + 1;
      ilut = (plan->ipunc << FEC_MO) | plan->shft;
      olut = plan->elut[ilut];
      if (tcm) {
        plan->uv = plan->uv ^ (biy << getBits(olut, 1, 1));
        otcm2 = getBits(olut, 1, 0);
        qtcm = getBits(olut, 1, 1);
        otcm3 = otcm2 | (getBit(plan->uv, qtcm) ? 4 : 0);
        Stream_wrBits (so, 3, otcm3);
      }
      else {
        Stream_wrBits (so, plan->olen - getBits(olut, 8, 8), getBits(olut, 7, 0));
      }
    }
  }
  return 0;
}

int_4 FEC_close (FEC* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 FEC_poll (FEC* plan) { return 0; }

int_4 FEC_free (FEC* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

FEC* FEC_subCore (HALO* halo, int_4 scid) {
  FEC* plan = FEC_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  FEC_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
