/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DUC2.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Filters;
import nxm.ice.lib.*;
public class DUC2 extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, ONP = 1, NP = 2, SIBW = 32, SOBW = NP * 32, OTAP = 4, NTAP = 16, SHF = 8;
public static class CORE extends Core {
  public double fbwf;
  public double fbwn;
  int ntap, nrpt;
  int quad, dquad;
  float[] fta, ftb, ftc;
  CxTapBuf vd;
  Value vo;
  public int init () {
    fbwf = 1.0;
    fbwn = 1.0;
    ntap = -1;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else if (isMatch (key, "L:FCNY")) dquad = value.toL () % 4;
    else if (isMatch (key, "D:FBWF")) fbwf = value.toD ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "D:XDIO")) value.fromD (0.5);
    else return super.get (key, value);
    return 0;
  }
  public void genFilt () {
    int i, j, k, nt = nrpt * ntap;
    double fw = fbwn * fbwf;
    float scl = nrpt * mulfp2 (1.0F, SHF);
    float[] ctap = new float[nt*2];
    Filters.genFirKais (1, fw / nrpt, 0.0, 0.05 / nrpt, 90.0, ctap, nt);
    for (i = j = 0; j < ntap; j ++, i += 4) {
      fta[j] = ctap[i+0] * scl;
      ftb[j] = ctap[i+2] * scl;
    }
    for (i = 0; i < nt; i ++) {
      ftc[i] = ctap[i+i] * scl;
    }
  }
  public int open () {
    int i;
    if (ntap <= 0) ntap = NTAP;
    if (ntap > NTAP) {
      System.out.printf ("Warn ntap=%d limited to ntap=%d for this compile\n", ntap, NTAP);
      ntap = NTAP;
    }
    vd = new CxTapBuf (OTAP, 1, NTAP, -1);
    vd.setLength (ntap);
    fta = new float[NTAP];
    ftb = new float[NTAP];
    ftc = new float[NTAP*2];
    vo = new Value ("CI", NP);
    nrpt = NP;
    genFilt ();
    quad = 0;
    if((this.halo.vbpr&1)!=0)System.out.printf ("DUC2 fbwn=%f fbwf=%f ntap=%d NP=%d\n", fbwn, fbwf, ntap, NP);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    CxFloat cm=CxFloat.stk(), foa=CxFloat.stk(), fob=CxFloat.stk(), foaq=CxFloat.stk(), fobq=CxFloat.stk();
    int i, j;
    while (si.rok && so.wok) {
      si.rdCIF (cm);
      vd.load (cm);
      foa.x = 0;
      foa.y = 0;
      fob.x = 0;
      fob.y = 0;
      for (j = 0; j < ntap; j ++) {
        CxFloat fdx=CxFloat.stk(), fdxa=CxFloat.stk(), fdxb=CxFloat.stk();
        float ftxa, ftxb;
        vd.get (j, fdx);
        fdxa = fdx;
        fdxb = fdx;
        ftxa = fta[j];
        ftxb = ftb[j];
        foa.x += ftxa * fdxa.x;
        fob.x += ftxb * fdxb.x;
        foa.y += ftxa * fdxa.y;
        fob.y += ftxb * fdxb.y;
      }
      qrotcc (foa, quad, foaq);
      qrotcc (fob, quad + dquad, fobq);
      quad = (quad + dquad + dquad) & 0x3;
      vo.setCFIS2 (- SHF, foaq, fobq);
      so.wr (vo);
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
