/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DUC.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Filters;
import nxm.ice.lib.*;
public class DUC extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int NP = 1, BW = 32, FLOW = STREAM, OTAP = 5, RTAP = 32, PTAP = 16, OFILT = 7, NFILT = 1 << OFILT, FPS = (NFILT / 8) - 1, MAXMON = 0xFFFFF, MAXCR = 250000000, IKR = 8, OKR = 4;
public final static String flgList = "Bypass,CTXF,Debug";
public final static int PF_BYPASS = 0, PF_CTXF = 1, PF_DEBUG = 2;
public static class CORE extends Core {
  public double fS;
  public double fSi;
  public double tOff;
  public double fbwf;
  public double fbwn;
  public double fC;
  public int ups, bups;
  public boolean mute;
  public boolean isFPGA;
  double ps, dps;
  double p, dp;
  float fscl;
  float lfps;
  int ntap, nrpt, mrpt;
  CxTapBuf vd;
  RomF2Di rft;
  int imon, mmon;
  int ovsr;
  int cper, cperi;
  int cups;
  int ifS;
  int flags;
  int upds;
  public int findMoN (double dphase) {
    int i;
    double phase, err;
    if (dphase < 0.0001) return 0;
    for (i = 2; i < 0x80000; i ++) {
      phase = dphase * i;
      err = fabs (phase - round (phase));
      if (err < 1.0e-12) return i;
    }
    return 0;
  }
  public void setDPS () {
    double err, odps = dps, freq = dps * fS / ovsr;
    if((this.halo.vbpr&2)!=0)System.out.printf ("DUC fs=%f mon=%d\n", fS, findMoN (odps));
    mmon = 0;
    dps = dptx2d (d2dptx (dps));
    fSi = dps * fS / ovsr;
    if (fSi != freq) {
      mmon = findMoN (odps);
      if (mmon > 1) {
        err = frac (dps * mmon);
        if (err > 0.5) {
          dps = dptx2d (d2dptx (dps) + 0x4);
          err = frac (dps * mmon);
          fSi = dps * fS / ovsr;
        }
        if (err > 1.0e-3 && fSi != freq) System.out.printf ("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", fS, freq, fSi, mmon, err);
        fSi = odps * fS / ovsr;
      }
      else {
        System.out.printf ("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f\n", fS, freq, fSi);
      }
    }
    mmon = (mmon == 0) ? 0 : mmon - 1;
    putVars ("dps,mmon");
  }
  public void setRate (double sr) {
    if (sr > 2 * MAXCR) {
      System.out.printf ("Desired sample rate = %f limited to max supported rate of %d\n", sr, MAXCR * 2);
      sr = MAXCR * 2;
    }
    ups = (sr > MAXCR) ? 2 : 1;
    fS = sr / ups;
  }
  public void setRateIn (double sr) {
    fSi = sr;
  }
  public void setCUPS (int c) {
    cups = (c >= 0) ? c : mute ? 0 : bups + 2;
    putVars ("cups");
  }
  public void setMute (int m) {
    mute = (m != 0);
    setCUPS (-1);
  }
  public void setFcny (double f) {
    bups = 0;
    dp = f;
    if (ups == 2) {
      if (f <- 0.125) {
        bups = -1;
        dp = (f + 0.25) * ups;
      }
      else if (f < 0.125) {
        bups = 0;
        dp = (f - 0.00) * ups;
      }
      else {
        bups = 1;
        dp = (f - 0.25) * ups;
      }
    }
    if (f <- 0.5 || f > 0.5) bups = 0;
    if (isFPGA) dp = dptx2d (d2dptx (dp));
    cups = mute ? 0 : bups + 2;
    fC = (dp / ups + (bups * 0.25)) * fS * ups;
    putVars ("dp,cups");
  }
  public void setFreq (double f) {
    setFcny (f / (fS * ups));
  }
  public void setGain (double gain) {
    fscl = d2f (pow (2.0, gain / 6.0) * fbwf / FPS);
    putVars ("fscl");
  }
  public void setCTXF (boolean x) {
    flags=setBit(flags, PF_CTXF, x);
  }
  public void setFilterWidth (double f) {
    fbwn = f;
  }
  public void setFeedRate (double f) {
    fSi = f;
  }
  public void genFilt () {
    int i, j, k, nt = nrpt * ntap;
    double fw = fbwn * fbwf;
    float scl = d2f (nrpt * FPS / fw);
    float[] ctap = new float[nt*2];
    Filters.genFirKais (1, fw / nrpt, 0.0, 0.05 / nrpt, 90.0, ctap, nt);
    for (i = j = 0; j < ntap; j ++) for (k = 0; k < nrpt; k ++, i += 2) rft.set (k, j, ctap[i] * scl);
  }
  public int init () {
    ups = 1;
    fbwf = 1.0;
    fbwn = 1.0;
    fS = -1.0;
    dp = 0;
    dps = 0.25;
    tOff = 0;
    fscl = -1;
    ntap = -1;
    ovsr = NP;
    fSi = -1;
    isFPGA = (this.halo.impl >= CORE_TYPE_FPGA);
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "D:FS")) setRate (value.toD ());
    else if (isMatch (key, "D:FSO")) setRate (value.toD ());
    else if (isMatch (key, "D:FREQ")) setFreq (value.toD ());
    else if (isMatch (key, "D:COFF")) setFreq (value.toD ());
    else if (isMatch (key, "D:FCNY")) setFcny (value.toD ());
    else if (isMatch (key, "D:FSI")) setRateIn (value.toD ());
    else if (isMatch (key, "D:FSYM")) setRateIn (value.toD ());
    else if (isMatch (key, "D:BAUD")) setRateIn (value.toD ());
    else if (isMatch (key, "D:FBWF")) fbwf = value.toD ();
    else if (isMatch (key, "D:TOFF")) tOff = value.toD ();
    else if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else if (isMatch (key, "D:GAIN")) setGain (value.toD ());
    else if (isMatch (key, "L:GAIN")) setGain (value.toD ());
    else if (isMatch (key, "L:CUPS")) setCUPS (value.toL ());
    else if (isMatch (key, "L:MUTE")) setMute (value.toL ());
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "D:FS")) value.fromD (fS);
    else if (isMatch (key, "D:FSO")) value.fromD (fS);
    else if (isMatch (key, "D:FSI")) value.fromD (fSi);
    else if (isMatch (key, "D:FSYM")) value.fromD (fSi);
    else if (isMatch (key, "D:FREQ")) value.fromD (dp * fS);
    else if (isMatch (key, "D:XDO")) value.fromD (1 / fS);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int i, mtap;
    if (fSi < 0) fSi = 1e6;
    if (fS < 0) fS = fSi;
    dps = fSi * ovsr / fS;
    setDPS ();
    cper = imax (1, imin (2, d2i (MAXCR / fS)));
    if (ntap <= 0) ntap = imin (RTAP, PTAP * cper);
    if (ntap > RTAP) {
      System.out.printf ("Warn ntap=%d limited to ntap=%d for this compile\n", ntap, RTAP);
      ntap = RTAP;
    }
    cper = (ntap + PTAP - 1) / PTAP;
    if (fS > MAXCR * NP / cper) System.out.printf ("Number taps=%d at fS=%f too large for FPGA load NP=%d PTAP=%d RTAP=%d\n", ntap, fS, NP, PTAP, RTAP);
    mtap = PTAP * cper;
    if (NP > 1 && ntap == mtap) {
      ntap --;
      System.out.printf ("Trim taps from %d to %d for parallel algorithm\n", mtap, ntap);
    }
    cperi = cper;
    if (fscl < 0) setGain (-3.0);
    nrpt = NFILT;
    mrpt = nrpt - 1;
    vd = new CxTapBuf (OTAP, 1, PTAP, 0);
    vd.setLength (ntap);
    rft = new RomF2Di (OFILT, OTAP, PTAP);
    genFilt ();
    lfps = 1;
    ps = 0;
    p = 0;
    imon = 1;
    ifS = d2i (fS);
    flags=setBit(flags, PF_BYPASS, (dps == 1.0));
    if((this.halo.vbpr&1)!=0)System.out.printf ("DUC fSi=%f fS=%f fbwn=%f fbwf=%f fscl=%f mmon=%d ntap=%d cper=%d ups=%d flags=%x NP=%d\n", fSi, fS, fbwn, fbwf, fscl, mmon, ntap, cper, ups, flags, NP);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    CxFloat sc=CxFloat.stk(), fo=CxFloat.stk(), cm=CxFloat.stk(), cn=CxFloat.stk(), cmr=CxFloat.stk(), cmrs=CxFloat.stk();
    float fps, dfps, fp, ifps;
    double dtmp;
    int idat;
    int ia, chn;
    boolean load, mon, cmon, xmon, byp, chx, ctxf;
    byp = getBit(flags, 0) && ! getBit(flags, 1);
    ctxf = getBit(flags, 1);
    cmon = (mmon == MAXMON);
    mon = (mmon > 0);
    so.setC (cups);
    if (byp) {
      while (si.rok && so.wok) {
        idat = si.rdL ();
        so.wrL (idat);
      }
    }
    else {
      while (si.rok && so.wok && (! ctxf || si.getC () <= 1)) {
        fps = fracf (d2f (ps));
        ps = (mon && imon == 0) ? 0 : frac (ps + dps);
        imon = (imon >= mmon) ? 0 : imon + 1;
        mmon = (mmon != MAXMON) ? mmon : (imon >= MAXMON) ? 0 : (imon > 2 && d2dptx (ps) < 8) ? imon - 2 : mmon;
        load = (fps <= lfps);
        lfps = fps;
        if (load) {
          si.rdCIF (cm);
          vd.load (cm);
        }
        ifps = lfps;
        fo.x = 0;
        fo.y = 0;
        for (ia = 0; ia < ntap; ia ++) {
          float ft, ftx;
          CxFloat fdi=CxFloat.stk(), fdix=CxFloat.stk();
          ftx = rft.getrN (ifps, ia);
          ft = ftx;
          vd.get (ia, fdix);
          fdi = fdix;
          fo.x += ft * fdi.x;
          fo.y += ft * fdi.y;
        }
        cn = fo;
        fp = d2f (p);
        p = frac (p + dp);
        sincoscf (fp, sc);
        mulcc (cn, sc, cmr);
        mulcf (cmr, fscl, cmrs);
        so.wrCFI (cmrs);
      }
      while (si.rok && ctxf && si.getC () > 1) {
        chn = si.getC ();
        idat = si.rdL ();
        System.out.printf ("Got chn=%d dat=%d at %d\n", chn, idat, 0);
        if (chn == 3 || chn == 4 || chn == 10) {
          dtmp = divii (idat, ifS);
          if (chn == 3) {
            dp = dtmp;
            if((this.halo.vbpr&1)!=0)System.out.printf ("DUC  Ctx chn=%d IF=%d dp=%x\n", chn, idat, d2x (dtmp));
          }
          if (chn == 4) {
            dp = dtmp;
            if((this.halo.vbpr&1)!=0)System.out.printf ("DUC  Ctx chn=%d RF=%d dp=%x\n", chn, idat, d2x (dtmp));
          }
          if (chn == 10) {
            dps = dptx2d (d2dptx (dtmp) + 1);
            mmon = MAXMON;
            imon = 0;
            if((this.halo.vbpr&1)!=0)System.out.printf ("DUC  Ctx chn=%d SR=%d dp=%x\n", chn, idat, d2x (dtmp));
          }
        }
        if (chn == 8) {
          if((this.halo.vbpr&1)!=0)System.out.printf ("DUC  Ctx chn=%d GAIN=%d fscl=%x\n", chn, idat, f2x (fscl));
        }
        upds=setBits(upds, 15, 0, getBits(upds, 15, 0) + 1);
        if (chn > 2) {
          upds=setBits(upds, 31, 16, chn);
        }
        this.upds = upds;
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
  public int poll () {
    getVars ("upds");
    if((this.halo.vbpr&2)!=0)System.out.printf ("DUC upds=%08x\n", upds);
    return 1;
  }
}
}
