/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE-PIC Controller Defines

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`define ICE_PM 1

`define V6M 1
`define VIRTEX6 1
`define JVM 1
`define DMA_NR 4
`define SDRAM2 1

`define HYPIN hypin5
`define HYPOUT hypout5

// default core engines
`define ENGINE1 noopengine 
`define ENGINE2 noopengine

// default multicore 1 & 2 engines
`define ENGINE3 mcengine
`define ENGINE4 mcengine
`define MC_ENGINE  tfddengine
`define MC_ENGINES 16
`define MC_COMSTAT 1

// specific processor engine configurations

`ifdef PE_NOOP
  `define ENGINE1 noopengine 
  `define ENGINE2 noopengine
  `define MC_ENGINE3  noopengine
  `define MC_ENGINE3S 4
  `define MC_ENGINE4  noopengine
  `define MC_ENGINE4S 2
  `define SYS_CLKF 225

`elsif PE_AIS
  `define ENGINE1 aisengine
  `define ENGINE2 aisengine
  `define MC_ENGINE noopengine
  `define MC_ENGINES 4
  `define SYS_CLKF 166

`elsif PE_WAVE
  `define ENGINE1 waveengine
  `define ENGINE2 waveengine
  `define MC_ENGINE noopengine
  `define MC_ENGINES 4
  `define SYS_CLKF 166

`elsif PE_BOT
  `define BOT_ORDER 10
  `define ENGINE1 r2cengine
  `define ENGINE2 r2cengine
  `define ENGINE3 botengine
  `define ENGINE4 botengine
  `define SYS_CLKF 166
  `define DMA_NR 16

`elsif PE_BOU
  `define BOT_ORDER 8
  `define BOT_RAW 1
  `define ENGINE1 r2cengine
  `define ENGINE2 noopengine
  `define ENGINE3 botengine
  `define ENGINE4 noopengine
  `define SYS_CLKF 166

`elsif PE_FFT
  `define ENGINE1 fftengine
  `define ENGINE2 fftengine
  `define ENGINE3 noopengine
  `define ENGINE4 noopengine
  `define SYS_CLKF 166
  `define MC_ENGINES 4
  `define FFT_ORDER 12

`elsif PE_FFTX
  `define ENGINE1 fftengine
  `define ENGINE2 noopengine
  `define ENGINE3 noopengine
  `define ENGINE4 noopengine
  `define SYS_CLKF 133
  `define MC_ENGINES 4
  `define FFT_ORDER 15
  `define FFT_NOPPF 1

`elsif PE_TF
  `define MC_ENGINES 4
  `define TFDD_ORDER 3
  `define TFDD_DMOD
  `define ENGINE1 firengine
  `define ENGINE2 firengine

`elsif PE_TR
  `define MC_ENGINES 4
  `define TFDD_ORDER 3
  `define TFDD_RTAPS 10
  `define TFDD_MDW 8
  `define R2C_TUNER 1
  `define ENGINE1 r2cengine
  `define ENGINE2 r2cengine
  `define SYS_CLKF 190
  `define PE_GROUP_ALL 1

`elsif PE_TS
  `define MC_ENGINES 8
  `define TFDD_ORDER 2
  `define TFDD_RTAPS 10
  `define TFDD_MDW 8
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define SYS_CLKF 190
  `define PE_GROUP_ALL 1

`elsif PE_TQ
  `define MC_ENGINES 8
  `define TFDD_RTAPS 0 
  `define TFDD_MDW 4
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define SYS_CLKF 200

`elsif PE_DMOD
  `define ENGINE1 dmodengine
  `define ENGINE2 dmodengine
  `define TFDD_XTAPS 1
  `define SYS_CLKF 166

`elsif PE_DEF
  `define MC_ENGINES 16
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define TFDD_XTAPS 1
//  `define SYS_CLKF 166
  `define SYS_CLKF 190
  `define PE_GROUP_ALL 1

`elsif PE_GSD
  `define ENGINE1 noopengine
  `define ENGINE2 gsdengine
  `define MC_ENGINES 18
  `define NOTESTMUX 1
  `define TFDD_RTAPS 0
  `define TFDD_MDW 8
  `define SYS_CLKF 166
  `define JVM_NR 8

`elsif PE_GSDX
  `define ENGINE1 nullengine
  `define ENGINE2 gsmxengine
  `define MC_ENGINES 16
  `define NOTESTMUX 1
  `define TFDD_RTAPS 0
  `define TFDD_MDW 8
  `define SYS_CLKF 150
  `define JVM_NR 8

`elsif PE_GSDY
  `define ENGINE1 nullengine
  `define ENGINE2 gsmxengine
  `define ENGINE3 botengine
  `define ENGINE4 botengine
  `define BOT_ORDER 8
  `define SYS_CLKF 166
  `define JVM_NR 8

`elsif PE_TEST
  `define ENGINE1 Test_core
  `define ENGINE2 Test_core
  `define ENGINE3 noopengine
  `define ENGINE4 noopengine

`elsif PE_NULL
  `define ENGINE1 nullengine
  `define ENGINE2 nullengine

`else 
  `include "mdefs_user.h"
`endif

`include "../lib/mdefs_comp.h"


