/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  User Core Template

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module userengine (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
		   ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, test);

  parameter PORT=1;	// engine index
  parameter IBW=64;	// I/O bus width - 32b in processor modules, 64b in main boards (PIC5)
  parameter SBW=32;	// System bus width - always 32

  localparam DBW=32;	// Data bus width (internal core use)

  input sclk;		// system clock (typically 100-150MHz)
  input srst;		// system reset
  input scs;		// system select (qualifies swr and srd for this core)
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;          // acknowledge

  input ioclk;          // I/O data bus clock
  output istat;         // istat - ready to accept 64 by burst
  input iena;           // input enable (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;     // input channel selection
  input [IBW-1:0] ibus; // input data bus
  output ostat;         // ostat - ready to provide 64 byte burst
  input oena;           // output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;    // output channel selection
  output [IBW-1:0] obus;// output data bus

  output [7:0] test;	// 8 test signals for scope probes
  
  wire L=0, H=1;
  assign sack=H;
  assign osel=0;	// single channel default

  // system status ram with parameterized ID 
  statusblk #("USER",8) ss (sclk, scs,saddr, swr,swrbus, srd,srdbus);

  // system register address resolution - with pipeline
  wire [7:0] sb; swrbank #(0,8) swb (sclk,scs,swr,saddr,sb);
  wire swrsys  = sb[0]; // system register (required)
  wire swrdec  = sb[1]; // decimation register (optional)
  wire swrgain = sb[2]; // gain register (optional)
  wire swrfreq = sb[3]; // freq register (optional
  wire swrflag = sb[7]; // flag register (optional)

  // the next 8 registers in bank 0 are reserved for system filter loading

  // first user bank - if needed
  wire [15:0] usb; swrbank #(1,16) uswb (sclk,scs,swr,saddr,usb);

  // system registers - written to by pic_cport() host control software
  reg [31:0] system,dec,gain;	
  always @(posedge sclk) begin
    if (swrsys)  system <= swrbus;
    if (swrdec)  dec    <= swrbus;
    if (swrgain) gain   <= swrbus;
  end
  wire enable     = system[0];		// core enable
  wire dir        = system[1];		// direction ? output:input
  wire reduce     = system[2];		// reduction ? enable:disable
  wire [3:0] ifmt = system[11:8];	// input format  bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real
  wire [3:0] ofmt = system[15:12];	// output format bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real

  wire reset = srst || !enable;		// core reset (at boot or disabled)
  wire vena,wena,vstat,wstat;
  wire [DBW-1:0] vbus,wbus;

  reg ival; always @(posedge ioclk) ival <= iena; // handle iena early

  // the RAHEAD flags cause the read data vbus to be valid in the same cycle as vena
  fifoNxM #(IBW,DBW, 0,3, 0,`RAHEAD) fi (ioclk,reset, istat,ival,ibus, sclk,reset, vstat,vena,vbus);

  // example function - replace with call to user verilog or vhdl here
  userfunc inst (sclk,reset,reduce, swrdec,swrbus, vstat,vena,vbus, wstat,wena,wbus);

  // this outputs the data in raw format
  fifoNxM #(IBW,DBW) fo (sclk,reset, wstat,wena,wbus, ioclk,reset, ostat,oena,obus);

  assign test = {oena,ostat,iena,istat,system[3:0]};	// example test probe

endmodule


// this function should be more generic without ICE dataflow 
module userfunc (clk,reset,reduce, swrdec,swrbus, vstat,vena,vbus, wstat,wena,wbus);
  input clk,reset,reduce;
  input swrdec;
  input [31:0] swrbus;
  input vstat,wstat;
  output vena,wena;
  input [31:0] vbus;
  output [31:0] wbus;

  // example register setting - internal
  reg [9:0] dec;
  always @(posedge clk) begin
    if (swrdec) dec <= swrbus[9:0];
  end

  // example noop with decimation
  reg vena;
  reg [9:0] count;
  wire zero = (count==0);
  always @(posedge clk) begin
         if (reset) count <= 0;
    else if (zero)  count <= dec[9:0]; // dec-1
    else if (vena)  count <= count-1;
    vena <= vstat && wstat;
  end
  assign wena = vena && (zero || !reduce);
  assign wbus = vbus;

endmodule
