#
# 
#
# STEP#1: define the output directory area.
#
set part [lindex $argv 0]
set desn [lindex $argv 1]
set card [lindex $argv 2]
set io   [lindex $argv 3]
set pe   [lindex $argv 4]
set hsv  [lindex $argv 5]
set obf  [lindex $argv 6]
puts "vFlow part=$part design=$desn card=$card io=$io pe=$pe hsv=$hsv obf=$obf"
create_project -in_memory -part $part
#
# STEP#2: setup design sources and constraints (read the top.prj file)
# 
set f [open top.prj]
set fns ","
while {[gets $f line] > -1} {
  if { [string first # $line] > -1} continue
  set fn [string range $line 14 end-1]
  if { [string length $fn] == 0} continue
  set bn $fn 
  set sl [string last / $fn]
  if { $sl > 0 } { 
   set bn [string range $fn $sl+1 end]
  }
  # Vivado gets confused if it reads the same file twice
  if { [string first ,$bn, $fns] > -1} continue
  if { [string first * $bn] < 0} { 
   set fns $fns$bn,
  }
  puts "vFlow read file=$fn base=$bn"
  # Note: first and last functions do not mean starts and ends
        if { [string last .vhd $fn] > -1}  { read_vhdl [ glob $fn ] 
  } elseif { [string last .v   $fn] > -1}  { read_verilog [ glob $fn ]
  } elseif { [string last .sv  $fn] > -1}  { read_verilog -sv [ glob $fn ]
  } elseif { [string last .edif $fn] > -1} { read_edif [ glob $fn ]
  } elseif { [string last .dcp $fn] > -1}  { read_checkpoint [ glob $fn ]
  } elseif { [string last .xci $fn] > -1}  { read_ip [ glob $fn ]
  } elseif { [string last .xdc $fn] > -1}  { read_xdc [ glob $fn ]
  } elseif { [string last .tcl $fn] > -1}  { source [ glob $fn ] 
  } else                                   { add_files [ glob $fn ] 
  }
}
close $f
read_xdc top.xdc
##if { [file exists pre_synth.tcl] } { source pre_synth.tcl }
#
# STEP#3: run synthesis, write design checkpoint, report timing, and utilization estimates
#
#synth_design -top top -part $part -include_dirs ../lib -verilog_define VIVADO=true 
synth_design -top top -part $part -include_dirs ../lib -verilog_define VIVADO=true -keep_equivalent_registers
write_checkpoint -force post_synth.dcp
report_timing_summary -file post_synth_timing_summary.rpt
report_utilization -file post_synth_util.rpt
#
# STEP#4: run logic optimization, placement and physical logic optimization, write design checkpoint, report utilization and timing estimates
#
opt_design
#opt_design -retarget -propconst -sweep -bram_power_opt -remap -bufg_opt -shift_register_opt -dsp_register_opt
write_checkpoint -force -noxdef post_opt.dcp
report_drc -file post_opt_drc.rpt
#
# STEP#4+: run placer
#
place_design
write_checkpoint -force post_place.dcp
report_clock_utilization -file clock_util.rpt
report_utilization -file post_place_util.rpt
report_timing_summary -file post_place_timing_summary.rpt
report_io -file post_place_io.rpt
#
# STEP#5: run the router, write the post-route design checkpoint, report routing status, timing, power, and DRC, and finally save the Verilog netlist.
#
route_design 
write_checkpoint -force post_route.dcp
report_route_status -file post_route_status.rpt
report_timing_summary -file post_route_timing_summary.rpt
report_power -file post_route_power.rpt
report_drc -file post_imp_drc.rpt
write_verilog -force cpu_impl_netlist.v -mode timesim -sdf_anno true
#
write_xdc -force top.xdc.out
write_debug_probes -force top.ltx
# phys_opt_design
# write_checkpoint -force post_route.dcp
# report_timing_summary -file -check_timing_verbose post_route_timing_summary.rpt
#
# STEP#6: generate a bitstream (Valid Config Rates U+ = 2.7,5.3,8.0,10.6,21.3,31.9,36.4,51.0,56.7,63.8,72.9,85.0,102.0,127.5)
# STEP#6: generate a bitstream (Valid Config Rates K8 = 3,6,9,12,22,33,40,50,69,90)
# STEP#6: generate a bitstream (Valid Config Rates K7 = 3,6,9,12,22,33,40,50,66)
#
if { [string first xcvu35p $part] > -1} {
 set part xcu50-as-xcvu35p
}
if { [string last p- $part] > 0} {
 set_property BITSTREAM.Config.ConfigRate 85.0 [current_design]
 set_property BITSTREAM.Config.SPI_BusWidth 4 [current_design]
 set_property BITSTREAM.Config.SPI_Fall_Edge Yes [current_design]
} elseif { [string first xcu50 $part] > -1} {
 set_property CONFIG_MODE SPIx4 [current_design]
 set_property CONFIG_VOLTAGE 1.8 [current_design]
 set_property BITSTREAM.CONFIG.CONFIGFALLBACK Enable [current_design]
 set_property BITSTREAM.GENERAL.COMPRESS TRUE [current_design]
 set_property BITSTREAM.CONFIG.SPI_BUSWIDTH 4 [current_design]
 set_property BITSTREAM.CONFIG.CONFIGRATE 85.0 [current_design]
 set_property BITSTREAM.CONFIG.EXTMASTERCCLK_EN disable [current_design]
 set_property BITSTREAM.CONFIG.SPI_FALL_EDGE YES [current_design]
 set_property BITSTREAM.CONFIG.UNUSEDPIN Pullup [current_design]
 set_property BITSTREAM.CONFIG.SPI_32BIT_ADDR Yes [current_design]
} elseif { [string first xczu $part] > -1} {
 set_property CONFIG_MODE B_SCAN [current_design]
 set_property CONFIG_VOLTAGE 1.8 [current_design]
 set_property BITSTREAM.CONFIG.CONFIGFALLBACK Enable [current_design]
 set_property BITSTREAM.GENERAL.COMPRESS TRUE [current_design]
 set_property BITSTREAM.CONFIG.UNUSEDPIN PULLNONE [current_design]
 set_property BITSTREAM.CONFIG.PERSIST NO [current_design]
 set_property BITSTREAM.STARTUP.MATCH_CYCLE NOWAIT [current_design]
} elseif { [string first xcku $part] > -1} {
 set_property BITSTREAM.Config.ConfigRate 69 [current_design]
 set_property BITSTREAM.Config.SPI_BusWidth 4 [current_design]
 set_property BITSTREAM.Config.SPI_Fall_Edge Yes [current_design]
} else {
 set_property BITSTREAM.Config.ConfigRate 66 [current_design]
 set_property BITSTREAM.Config.SPI_BusWidth 4 [current_design]
 set_property BITSTREAM.Config.SPI_Fall_Edge Yes [current_design]
}
set_property BITSTREAM.Config.UserID 0x0001CE1D [current_design]
write_bitstream -force top.bit
puts "vFlow finished part=$part design=$desn card=$card io=$io p2=$pe hsv=$hsv"
exit
