module scrambler32 (input clk, input scram_rst, output [31:0] scram_out);

  reg [57:0] lfsr_q,lfsr_c;

  always @(*) begin
    lfsr_c[0] = lfsr_q[26] ^ lfsr_q[45];
    lfsr_c[1] = lfsr_q[27] ^ lfsr_q[46];
    lfsr_c[2] = lfsr_q[28] ^ lfsr_q[47];
    lfsr_c[3] = lfsr_q[29] ^ lfsr_q[48];
    lfsr_c[4] = lfsr_q[30] ^ lfsr_q[49];
    lfsr_c[5] = lfsr_q[31] ^ lfsr_q[50];
    lfsr_c[6] = lfsr_q[32] ^ lfsr_q[51];
    lfsr_c[7] = lfsr_q[33] ^ lfsr_q[52];
    lfsr_c[8] = lfsr_q[34] ^ lfsr_q[53];
    lfsr_c[9] = lfsr_q[35] ^ lfsr_q[54];
    lfsr_c[10] = lfsr_q[36] ^ lfsr_q[55];
    lfsr_c[11] = lfsr_q[37] ^ lfsr_q[56];
    lfsr_c[12] = lfsr_q[38] ^ lfsr_q[57];
    lfsr_c[13] = lfsr_q[39];
    lfsr_c[14] = lfsr_q[40];
    lfsr_c[15] = lfsr_q[41];
    lfsr_c[16] = lfsr_q[42];
    lfsr_c[17] = lfsr_q[43];
    lfsr_c[18] = lfsr_q[44];
    lfsr_c[19] = lfsr_q[45];
    lfsr_c[20] = lfsr_q[46];
    lfsr_c[21] = lfsr_q[47];
    lfsr_c[22] = lfsr_q[48];
    lfsr_c[23] = lfsr_q[49];
    lfsr_c[24] = lfsr_q[50];
    lfsr_c[25] = lfsr_q[51];
    lfsr_c[26] = lfsr_q[52];
    lfsr_c[27] = lfsr_q[53];
    lfsr_c[28] = lfsr_q[54];
    lfsr_c[29] = lfsr_q[55];
    lfsr_c[30] = lfsr_q[56];
    lfsr_c[31] = lfsr_q[57];
    lfsr_c[32] = lfsr_q[0];
    lfsr_c[33] = lfsr_q[1];
    lfsr_c[34] = lfsr_q[2];
    lfsr_c[35] = lfsr_q[3];
    lfsr_c[36] = lfsr_q[4];
    lfsr_c[37] = lfsr_q[5];
    lfsr_c[38] = lfsr_q[6];
    lfsr_c[39] = lfsr_q[7] ^ lfsr_q[26] ^ lfsr_q[45];
    lfsr_c[40] = lfsr_q[8] ^ lfsr_q[27] ^ lfsr_q[46];
    lfsr_c[41] = lfsr_q[9] ^ lfsr_q[28] ^ lfsr_q[47];
    lfsr_c[42] = lfsr_q[10] ^ lfsr_q[29] ^ lfsr_q[48];
    lfsr_c[43] = lfsr_q[11] ^ lfsr_q[30] ^ lfsr_q[49];
    lfsr_c[44] = lfsr_q[12] ^ lfsr_q[31] ^ lfsr_q[50];
    lfsr_c[45] = lfsr_q[13] ^ lfsr_q[32] ^ lfsr_q[51];
    lfsr_c[46] = lfsr_q[14] ^ lfsr_q[33] ^ lfsr_q[52];
    lfsr_c[47] = lfsr_q[15] ^ lfsr_q[34] ^ lfsr_q[53];
    lfsr_c[48] = lfsr_q[16] ^ lfsr_q[35] ^ lfsr_q[54];
    lfsr_c[49] = lfsr_q[17] ^ lfsr_q[36] ^ lfsr_q[55];
    lfsr_c[50] = lfsr_q[18] ^ lfsr_q[37] ^ lfsr_q[56];
    lfsr_c[51] = lfsr_q[19] ^ lfsr_q[38] ^ lfsr_q[57];
    lfsr_c[52] = lfsr_q[20] ^ lfsr_q[39];
    lfsr_c[53] = lfsr_q[21] ^ lfsr_q[40];
    lfsr_c[54] = lfsr_q[22] ^ lfsr_q[41];
    lfsr_c[55] = lfsr_q[23] ^ lfsr_q[42];
    lfsr_c[56] = lfsr_q[24] ^ lfsr_q[43];
    lfsr_c[57] = lfsr_q[25] ^ lfsr_q[44];
  end

  always @(posedge clk) begin
    // this makes sure scram_out resets to 32'hAAAAAAAA
//    if (scram_rst) lfsr_q <= 58'h2A5_A5FF_FFFA_5A5A; else lfsr_q <= lfsr_c;
    if (scram_rst) lfsr_q <= 58'h25A_5AFF_FFF5_A5A5; else lfsr_q <= lfsr_c;
//    if (scram_rst) lfsr_q <= 58'h3FF_FFFF_FFFF_FFFF; else lfsr_q <= lfsr_c;
  end
  assign scram_out[0] = lfsr_q[57];
  assign scram_out[1] = lfsr_q[56];
  assign scram_out[2] = lfsr_q[55];
  assign scram_out[3] = lfsr_q[54];
  assign scram_out[4] = lfsr_q[53];
  assign scram_out[5] = lfsr_q[52];
  assign scram_out[6] = lfsr_q[51];
  assign scram_out[7] = lfsr_q[50];
  assign scram_out[8] = lfsr_q[49];
  assign scram_out[9] = lfsr_q[48];
  assign scram_out[10] = lfsr_q[47];
  assign scram_out[11] = lfsr_q[46];
  assign scram_out[12] = lfsr_q[45];
  assign scram_out[13] = lfsr_q[44];
  assign scram_out[14] = lfsr_q[43];
  assign scram_out[15] = lfsr_q[42];
  assign scram_out[16] = lfsr_q[41];
  assign scram_out[17] = lfsr_q[40];
  assign scram_out[18] = lfsr_q[39];
  assign scram_out[19] = lfsr_q[38] ^ lfsr_q[57];
  assign scram_out[20] = lfsr_q[37] ^ lfsr_q[56];
  assign scram_out[21] = lfsr_q[36] ^ lfsr_q[55];
  assign scram_out[22] = lfsr_q[35] ^ lfsr_q[54];
  assign scram_out[23] = lfsr_q[34] ^ lfsr_q[53];
  assign scram_out[24] = lfsr_q[33] ^ lfsr_q[52];
  assign scram_out[25] = lfsr_q[32] ^ lfsr_q[51];
  assign scram_out[26] = lfsr_q[31] ^ lfsr_q[50];
  assign scram_out[27] = lfsr_q[30] ^ lfsr_q[49];
  assign scram_out[28] = lfsr_q[29] ^ lfsr_q[48];
  assign scram_out[29] = lfsr_q[28] ^ lfsr_q[47];
  assign scram_out[30] = lfsr_q[27] ^ lfsr_q[46];
  assign scram_out[31] = lfsr_q[26] ^ lfsr_q[45];

endmodule

