/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE-PIC5 Processor Module Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  12/15/2004

  Packet Contents

	Code	Signal	icnt
  p A5  Key	
  n 00  Cmd	
  p 04  Cnt	isync
  n 01  Chn
  p  0  Data	ichan	00	icycle up
  n  1
     2			03	wvali up
     3
     4			02
   ...
     6		idone	01	
     7
      			00	icycle dn

*/
`include "vdefs.h"
`include "../lib/ramdefs.h"

module pmodule (
  sclk,rst, scs,saddr, swr,swrbus, srd,srdbus, sack,
  vclk, vrst,
  vipc, vip, vopc, vop, 
  vinc, vin, vonc, von, 
  ioclk, istat,iena,ibus,isel, ostat,oena,obus,osel,
  istat1,istat2,ostat1,ostat2,mcena, 
  test);			

  parameter PORT=1;
  parameter IBW=64;

  // system bus
  input sclk,rst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;
  output sack;

  // HyperTransport Interface
  input vclk, vrst;
  inout vipc, vinc;
  inout [7:0] vip, vin;
  inout vopc, vonc;
  inout [7:0] vop, von;

  // DMA bus
  input ioclk,iena,oena;
  input [63:0] ibus;
  input [7:0] isel;
  output [63:0] obus;
  output [7:0] osel;
  output istat,ostat;

  // direct
  output istat1,istat2;
  output ostat1,ostat2;
  input [7:0] mcena;

  // test port
  output [7:0] test;

  // global signals
  wire L=0, H=1;
  reg [31:0] pm;
  assign sack=H;
  assign ostat1 = ostat;
  assign ostat2 = ostat;
  assign istat1 = istat;
  assign istat2 = istat;

  wire good = H;
  wire ena  = pm[0];
  wire qdr  = L;
  wire tp  = !pm[30];	// enable output test pattern
  wire mode = pm[31];   // raw data collect

  reg enb,dclkrst,dclkadj,dclkud;
  wire swriom = (scs && swr && saddr[5:2]==0);
  wire swriop = (scs && swr && saddr[5:0]==6);
  always @(posedge sclk) begin
    if (swriom) pm <= swrbus;
    dclkrst <= swriop && swrbus[0];
    dclkadj <= swriop && swrbus[1];
    dclkud  <= swriop && swrbus[2];
    enb     <= ena && !rst;
  end
  wire frst = !enb;

  // the 333 clock for the LVDS read strobe
  wire lclk,rclk,fclk;
`ifdef VIRTEX2
  dibuf _clkids (vipc,vinc,rclk);
  BUFG _clki (fclk,lclk);
  DCM i_dcm (.DSSEN(L),.PSCLK(sclk),.PSEN(dclkadj),.PSINCDEC(dclkud),.RST(dclkrst),
             .CLKIN(rclk),.CLKFB(fclk),.CLK0(lclk));
  defparam i_dcm.CLK_FEEDBACK = "1X";
  defparam i_dcm.DLL_FREQUENCY_MODE = "HIGH";
  defparam i_dcm.DUTY_CYCLE_CORRECTION = "TRUE";
  defparam i_dcm.CLKIN_PERIOD = 7.5;
  defparam i_dcm.CLKOUT_PHASE_SHIFT = "VARIABLE";
  defparam i_dcm.PHASE_SHIFT = 0;
  defparam i_dcm.STARTUP_WAIT = "FALSE";
`elsif VIRTEX4
  dibuf _clkids (vipc,vinc,rclk);
  IDELAYCTRL i_dlyc (.REFCLK(ioclk),.RST(dclkrst) );
  IDELAY i_dly (.C(sclk),.CE(dclkadj),.INC(dclkud),.RST(dclkrst), .I(rclk),.O(lclk) );
  defparam i_dly.IOBDELAY_TYPE = "VARIABLE";
  defparam i_dly.IOBDELAY_VALUE = 15;
  BUFR _clki (.O(fclk),.I(lclk));
`else
  dibuf _clkids (vipc,vinc,rclk);
  assign  fclk = rclk;
`endif

  // the I/O interface pins
  wire [31:0] fbus;
  wire [31:0] gbus;
`ifdef VIRTEX2
  diddrN #(8,1) _dati (vip,vin, fclk, fbus[7:0],fbus[23:16]);
  doddr         _clko (vopc,vonc, vclk,good, H,L);
  doddrN #(8,1) _dato (vop,von, vclk,good, gbus[7:0],gbus[23:16]);
`else
  diddrN #(8,1) _dati (vip,vin, fclk, fbus[7:0],fbus[23:16]);
  doddr         _clko (vopc,vonc, vclk,good, H,L);
  doddrN #(8,1) _dato (vop,von, vclk,good, gbus[7:0],gbus[23:16]);
`endif

  // input delay
  reg ival; always @(posedge ioclk) ival <= iena; 

  // channel wires
  wire wrdyo,wvalo;
  wire wrdyi,wvali;
  wire [1:0] wchni,wchno;
  wire [15:0] wbusi,wbuso;
  wire [7:0] ochn;
  reg  [2:0] icnt,ocnt;
  always @(posedge ioclk) begin
    if (!oena) ocnt <= 0; else ocnt <= ocnt+1;
    if (!iena) icnt <= 0; else icnt <= icnt+1;
  end
  wire ichi = isel[0];
  wire iten = isel[1];
  wire isen = isel[2];
  wire itena = isel[4];
  wire isena = isel[5];
  wire itenb = isel[6];
  wire isenb = isel[7];
  wire [7:0] ichn = {iten,iten,isen,ichi,isen,ichi,isen,ichi};
  assign osel = ochn;

  // the packet handler
  wire [7:0] ptest;
  ppack mpn (fclk,fbus, wrdyi,wvali,wbusi,wchni,
             vclk,gbus, wrdyo,wvalo,wbuso,wchno,
             enb, mode, qdr, tp, ptest);

  // input/output fifos 
  fifoNxM #(18,72,2,3,`BPAR,`PACKET) fi (fclk,frst, wrdyi,wvali,{wchni,wbusi}, ioclk,frst, ostat,oena,{ochn,obus});
  fifoNxM #(72,18,2,3,`BPAR,`PACKET) fo (ioclk,frst, istat,ival,{ichn,ibus},    vclk,frst, wrdyo,wvalo,{wchno,wbuso});

  // status counter readback ram
  reg tload,tincl,tincu,tputa,tputb,tag;
  reg [1:0] isenl;
  reg [31:0] tcnt;
  wire [31:0] twrbus,trdbus;
  always @(posedge ioclk) begin
    tload <= (icnt==1);
    tincl <= tload;
    tincu <= tload && (trdbus[15:0]==16'hFFFF);
    tputa <= tincl && !ichi;
    tputb <= tincl &&  ichi;
    tag   <= tload && isen && !isenl[ichi];
    if (tload) tcnt[15:00] <= trdbus[15:00]; else if (tincl) tcnt[15:00] <= tcnt[15:00]+1;
    if (tload) tcnt[31:16] <= trdbus[31:16]; else if (tincu) tcnt[31:16] <= tcnt[31:16]+1;
    if (!isena) isenl[0] <= 0; else if (tputa) isenl[0] <= isen;
    if (!isenb) isenl[1] <= 0; else if (tputb) isenl[1] <= isen;
  end
  wire twr = tag || tputa || tputb;
  wire [1:0] taddr = {tag,ichi};
  dpram #(2,32,32) rs (sclk,scs, saddr[10:2],swr, swrbus,srdbus,
                       ioclk,H, {7'b1,taddr},twr, twrbus,trdbus);
  assign twrbus = tcnt;

//  assign test = 0;
//  assign test = {dclkud,dclkadj,dclkrst,rclk,oena,iena,tfclk,tvclk};
//  assign test = {wvalo,wvali,oena,iena,tfclk,tvclk,mode,enb};
//  assign test = {wvalo,wvali,oena,iena,ptest[2:0],enb};
  assign test = ptest;

endmodule

/*
  this module must be placed near the pins

	idatp	idatpd	
	01A5
	XX00	01A5	isync
	...	XX00
	00A5	...
	XX01	00A5	isync
	data	XX01	icycle
		data	wvali

 fifo osel-d
       0 0  ostart
       1 0  ostart2
       2 1  ocycle  
       3 2  ocycle        chan@obus
   0   3 3  ocycle        chan@tmp
   1   3 3  ...           chan@gbusn
   2   3 3  ocycle
       3 3   
 N-1   0 3  ostart
       1 0  ostart2
*/
module ppack (fclk, fbus, wrdyi,wvali,wbusi,wchni,
              vclk, gbus, wrdyo,wvalo,wbuso,wchno,
               enb, mode, qdr, tp, test);

  input fclk,vclk,enb,mode,qdr,tp;
  input [31:0] fbus;
  output [31:0] gbus;
  output [31:0] wbusi;
  input  [31:0] wbuso;
  input wrdyi,wrdyo;
  input [1:0] wchno;
  output [1:0] wchni;
  output wvali,wvalo;
  output [7:0] test;

  wire L=0, H=1;

  // counters
  reg itick, otick;

  // input
  reg wvali,isync,ichn,icycle,idone,ihold;
  reg [31:0] fbusd, idat, idatd;
  reg [7:0] icnt,ichan;

  // for data integrity - vote on TMUX or CORE mode channels
  wire [7:0] vchan = idatd[15:8];
  wire voteh = (vchan[7]&vchan[6]) || (vchan[7]&vchan[5]) || (vchan[6]&vchan[5]);
  wire votel = (vchan[2]&vchan[1]) || (vchan[2]&vchan[0]) || (vchan[1]&vchan[0]);

  always @(posedge fclk) begin
    fbusd  <= fbus;
    idat   <= qdr? fbusd : {16'b0,fbusd[23:16],fbusd[7:0]};
    idatd  <= idat;
    if (icycle) isync <= 0; else isync <= (idat[7:0]==8'hA5);
    icycle <= (isync && idat[2:0]!=0 && enb) || (icycle && !idone);	// non-zero packet length ?
    idone  <= (icnt==2);
    itick  <= (icnt[4:0]==30);
    if (!icycle) icnt[4:0] <= 0;         else            icnt[4:0] <= icnt[4:0]-1; // 32 2by words per packet
    if (!icycle) icnt[7:5] <= idat[2:0]; else if (itick) icnt[7:5] <= icnt[7:5]-1; // 64by packet count
    wvali  <= icycle || mode;
    ichn   <= isync;
    if (mode) ichan <= 0; else if (ichn)  ichan <= voteh? {H,L,L,vchan[4:0]} : {L,{6{L}},votel};
    if (mode) ihold <= 0; else if (isync) ihold <= (vchan[2:0]!=0);
  end
  assign wbusi = idatd;
  mux4xN #(2) icm (wchni, ichan[7:6],ichan[5:4],ichan[3:2],ichan[1:0], icnt[1:0]);

  // output
  reg oready,oready2,ostart,ostart2,ocyclep,ocycle,odone;
  reg [31:0] gbus;
  reg [7:0] ocnt,ochan;
  wire [31:0] obus,wbusod;
  reg [1:0] osel;
  wire [1:0] oseld;
  reg [3:0] tst;
  wire [15:0] pattern = { ~tst, ~tst, tst, tst };
  wire oholdd,ocycled;
  reg jhold,ahold,ohold,ophase;

  // delay signals to allow wchi[2] to shift into ochan[8]
  srl16xNp #(2)  obc (vclk,H, 4'h3, osel,oseld);
  srl16xNp #(32) obd (vclk,H, 4'h3, wbuso,wbusod);
  srl16xNp #(1)  ob1 (vclk,H, 4'h2, ohold,oholdd);
  srl16xNp #(1)  ob2 (vclk,H, 4'h3, ocycle,ocycled);

  always @(posedge vclk) begin
    ophase  <= !tst[0];	// insure packets on 4 byte boundaries sync with tst fill pattern
    oready  <= wrdyo && enb && !ihold;
    oready2 <= oready;
    ostart  <= !ostart && !ocyclep && (oready||ahold) && ophase;
    ostart2 <= ostart;
    ocyclep <= (ostart && oready2) || (ocyclep && !odone);
    ocycle  <= ocyclep;
    osel    <= ostart? 1 : ostart2? 2 : ocycle? 3 : 0;
    ochan   <= {wchno,ochan[7:2]};
    odone   <= (ocnt==3); // stops ocyclep
    otick   <= (ocnt[4:0]==30);
    if (!ocycle) ocnt[4:0] <= 0; else            ocnt[4:0] <= ocnt[4:0]-1; // 32 2by words per packet
    if (!ocycle) ocnt[7:5] <= 1; else if (otick) ocnt[7:5] <= ocnt[7:5]-1; // 64by packet count
    gbus <= qdr? obus : {8'b0,obus[15:8],8'b0,obus[7:0]};
    if (!tp) tst <= 0; else tst <= tst+1;
    jhold <= enb && !mode && !wrdyi;
    if (!enb) ohold <= 0; else if (ostart2) ohold <= jhold;
    ahold <= (jhold || ohold); // if current or last sent is to hold off
  end
  assign wvalo = ocycle;
  mux4xNp #(16) mux (obus, pattern,{5'd0,oholdd,oholdd,oholdd,8'hA5},{ochan,7'd0,ocycled},wbusod, oseld,vclk);

  reg fff; always @(posedge vclk) fff <= !fff;
  assign test = {fff,oready,ocycle,ohold,fclk,icycle,isync,ihold};

endmodule

/*
   tst  ophase ostart osel oseld
   0
   1    1
   2    0      1
   3    1             1
   4    0                  1
   5    1
*/
