/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE PCI Defines

  Definitions for:
	 PCI command codes
	 PCI command/status register

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`ifndef _PCIDEFS
`define _PCIDEFS

// PCI command codes
`define INTERRUPT_ACKNOWLEDGE	4'b0000
`define SPECIAL_CYCLE		4'b0001
`define IO_READ			4'b0010
`define IO_WRITE		4'b0011
`define RESERVED1		4'b0100
`define RESERVED2		4'b0101
`define MEMORY_READ		4'b0110
`define MEMORY_WRITE		4'b0111
`define RESERVED3		4'b1000
`define RESERVED4		4'b1001
`define CONFIG_READ		4'b1010
`define CONFIG_WRITE		4'b1011
`define MEM_READ_MULTIPLE	4'b1100
`define DUAL_ADDRESS_CYCLE	4'b1101
`define MEM_READ_LINE		4'b1110
`define MEM_WRITE_INVALIDATE	4'b1111

// PCI command generalizations
`define CONFIG_RW31	3'b101
`define MEMORY_RW31	3'b011
`define OTHER_RW32	2'b11

// PCI command register bits
`define CSR_IO_ACCESS	0 	// enable IO target access
`define CSR_MEM_ACCESS	1	// enable MEM target access
`define CSR_BUS_MASTER	2	// enable bus mastering
`define CSR_SP_CYCLE	3	// enable special cycle
`define CSR_MEM_WR_INV	4	// enable MEM write and invalidate
`define CSR_PLT_SNOOP	5	// enable palette snoop
`define CSR_PERR	6	// enable parity error
`define CSR_WAIT_CYC	7	// enable wait cycle (addr/data stepping)
`define CSR_SERR	8	// enable system error
`define CSR_FAST_B2B	9	// fast back-to-back enable

// PCI status register bits
`define CSR_FB2B	23	// fast back-to-back
`define CSR_DPR		24	// data parity reported
`define CSR_DST0	25	// DEVSEL timing
`define CSR_DST1	26
`define CSR_STA		27	// signaled target abort
`define CSR_RTA		28	// received target abort
`define CSR_RMA		29	// received master abort
`define CSR_SSE		30	// signaled system error	
`define CSR_DPE		31	// detected parity error

// DEVSEL timing 
`define DEVSEL_FAST	0
`define DEVSEL_MED	1
`define DEVSEL_SLOW	2
`define DEVSEL_RESV	3
`define DEVSEL_TO	3

`endif
