/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Null Core Interface

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module nullengine (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
		   ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, test);

  parameter PORT=1;	// engine index
  parameter IBW=64;	// I/O bus input width
  parameter OBW=IBW;	// I/O bus output width
  parameter IKR=0;
  parameter OKR=0;
  parameter IOCLKS=1;

  localparam SBW=32;	// System bus width - always 32

  input sclk;		// system clock
  input srst;		// system reset
  input scs;		// system select
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;          // acknowledge


  input ioclk;          // I/O data bus clock
  output istat;         // istat - ready to accept 64 by burst
  input iena;           // input enable (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;     // input channel selection
  input [IBW-1:0] ibus; // input data bus
  output ostat;         // ostat - ready to provide 64 byte burst
  input oena;           // output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;    // output channel selection
  output [IBW-1:0] obus;// output data bus

  output [7:0] test;	// 8 test signals for scope probes

  assign srdbus = 0;
  assign sack = 1;
  assign osel = 0;
  assign obus = 0;
  assign istat = 0;
  assign ostat = 0;
  assign test = 0;

endmodule

