/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Convert Core 

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module convengine (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
		   ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, test);

  parameter PORT=1;	// engine index
  parameter IBW=64;	// I/O bus width - 32b in processor modules, 64b in main boards (PIC5)

  localparam SBW=32;	// System bus width - always 32
  localparam DBW=64;	// Data bus width (internal core use)
  localparam NR=2;	// Number of 16kb RAMS in fifos

  input sclk;		// system clock
  input srst;		// system reset
  input scs;		// system select (qualifies swr and srd for this core)
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;          // acknowledge

  input ioclk;          // I/O data bus clock
  output istat;         // istat - ready to accept 64 by burst
  input iena;           // input enable (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;     // input channel selection
  input [IBW-1:0] ibus; // input data bus
  output ostat;         // ostat - ready to provide 64 byte burst
  input oena;           // output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;    // output channel selection
  output [IBW-1:0] obus;// output data bus

  output [7:0] test;	// 8 test signals for scope probes
  
  wire L=0, H=1;
  assign sack=H;
  assign osel=0;	// single channel core

  // system status ram with parameterized ID 
  swrstat #("CONV",32'h1CE) ss (sclk,scs,swr, saddr, swrbus,srdbus);

  // system register address resolution - with pipeline
  wire [7:0] sb; swrbank #(0,8) swb (sclk,scs,swr,saddr,sb);
  wire swrsys  = sb[0]; // system register (required)
  wire swrdec  = sb[1]; // decimation register (optional)
  wire swrgain = sb[2]; // gain register (optional)
  wire swrrate = sb[3]; // rate register (optional
  wire swrfram = sb[5]; // frame register (optional
  wire swrflag = sb[7]; // flag register (optional)

  // system registers - written to by pic_cport() host control software
  reg [31:0] system,dec,gain,rate,frame,flag;	
  always @(posedge sclk) begin
    if (srst) system <= 0; else if (swrsys) system <= swrbus;
    if (srst) dec    <= 0; else if (swrdec) dec    <= swrbus;
    if (srst) rate   <= 0; else if (swrrate) rate  <= swrbus;
    if (srst) frame  <= 0; else if (swrfram) frame <= swrbus;
    if (srst) flag   <= 0; else if (swrflag) flag  <= swrbus;
  end
  wire enable     = system[0];		// core enable
  wire dir        = system[1];		// direction ? output:input
  wire reduce     = system[2];		// reduction ? enable:disable
  wire [3:0] ifmt = system[11:8];	// input format  bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real
  wire [3:0] ofmt = system[15:12];	// output format bit[2:0]? 0=16b 1=8b 2=4b 3=1b 4=32b  bit[3]?complex:real
  wire throttle   = flag[0];
  wire swap       = flag[1];

  wire reset = !enable;		// core reset (at boot or disabled)
  wire vena,wena,vstat,wstat;
  wire [DBW-1:0] vbus,wbus;

  reg ival; always @(posedge ioclk) ival <= iena; // handle iena early

  // this reformats any input type to output format 4'h8 = complex 16b
  fifoNxM #(IBW,DBW,NR) fi (ioclk,reset, istat,ival,ibus, sclk,reset, vstat,vena,vbus);

  // example function - replace with call to user verilog or vhdl here
`ifndef IOMODULE
  wire wenax; reg go; reg [4:0] cc;
  always @(posedge sclk) cc <= cc+1;
  always @(posedge sclk) go <= vstat && wstat && cc[4];
  delayp #(4) dp (sclk,go,wena);
  convert_12to16i #(DBW) inst (sclk,reset,H,L, go,vena,vbus, go,wenax,wbus);
`else
  convert_12to16i #(DBW) inst (sclk,reset,H,L, vstat,vena,vbus, wstat,wena,wbus);
`endif

  // this reformats the 4'h8 = complex 16b to any output type 
  fifoNxM #(DBW,IBW,NR) fo (sclk,reset, wstat,wena,wbus, ioclk,reset, ostat,oena,obus);

  assign test = {oena,ostat,iena,istat,wena,vena,dir,enable};	// example test probe

endmodule
