/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Various support routines

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module auxiliary (
  sclk,rst, scs,saddr, swr,swrbus,
  clka, clkb, clkc, clkc2, clkx, clkp, xclk, muxclk,
  xsynci, xsynco, xsctl, xgo, tsynci,
  pcref, pcsclk, pcsdat, pwr5v,
  test
  );

  // system bus
  input sclk,rst,scs,swr;
  input [31:0] saddr,swrbus;

  // mux clock signals
  input clka, clkb, clkc, clkc2, clkx, clkp, xclk;
  output muxclk; 

  input xsynci, xgo, tsynci;
  output [3:0] xsctl;
  inout xsynco;
  output pcref, pcsclk, pcsdat;
  output pwr5v;

  output [7:0] test;

  wire L=0,H=1;

  // programmable serial clock
  wire wpcs = scs && swr && (saddr[5:2]==0);
  wire wpcr = scs && swr && (saddr[5:2]==1);
  reg pcsclk, pcsdata, pcsden, prefx, prefi;
  reg [3:0] pcount;
  always @(posedge sclk) begin
    if (wpcr) prefx <= swrbus[0];
    if (rst) pcsclk <= 1;
    else if (wpcs) pcsclk <= swrbus[0];
    if (rst) pcsdata <= 1;
    else if (wpcs) pcsdata <= swrbus[1];
    if (rst) pcsden <= 1;
    else if (wpcs) pcsden <= swrbus[2];
    if (pcount==9) pcount <= 0;
    else pcount <= pcount+1;
    prefi <= (pcount<5);	// internal 10MHz
  end
  assign pcref = (prefx)? clkx : prefi;
  assign pcsdat = (pcsden)? pcsdata : 'bZ;

  // global mux clock
  wire wdiv  = scs && swr && (saddr[5:4]==2 && !saddr[3]);
  wire wgmc  = scs && swr && (saddr[5:4]==3 && !saddr[3] && !saddr[0]);
  wire wgmm  = scs && swr && (saddr[5:4]==3 && !saddr[3] &&  saddr[0]);
  reg [15:0] tim;
  reg [7:0] gmcr,gmmr;
  reg isel;
  always @(posedge sclk) begin
    if (wdiv) tim  <= swrbus[15:0];
    if (wgmc) gmcr <= swrbus[7:0];
    // special case for muxclk=D and N=1, use muxclk=C
    isel <= (gmcr[2:0]==0 || gmcr[2:0]==6) && tim==0;
    if (wgmm) gmmr <= swrbus[7:0];
  end
  wire   xsoe    = gmcr[4];	// output enable
  wire   xsac    = gmcr[5];	// AC or comparator input enable
  wire   xstp    = gmcr[6];	// test port input enable
  wire   xstrm   = gmcr[7];	// termination enable

  assign xsctl   = {xstrm,xstp,xsac,xsoe};

  assign pwr5v   = gmmr[7];

  // internal clock I
  reg clki, tload1;
  reg [11:0] timer1;
  always @(posedge clkc2) begin
    if (tload1) timer1 <= tim[11:0];
    else timer1 <= timer1-1;
    tload1 <= (timer1==1);
    clki <= timer1 > tim[11:1];
  end

  // internal clock D
  reg clkd, tload2;
  reg [7:0] timer2;
  always @(posedge clkc) begin
    if (tload2) timer2 <= tim[7:0];
    else timer2 <= timer2-1;
    tload2 <= (timer2==1);
    clkd <= timer2 > tim[7:1];
  end

  // internal clock Q
  wire clkq; 
  divide_by_64 db6 (clkp,clkq);
  
  // mux the clock sources
  wire [2:0] sel = (isel)? ~gmcr[2:0] : gmcr[2:0];
  mux8xN gcm (muxclk, clki,clkc,clka,clkb,clkx,clkp,clkd,clkq, sel);
  // synthesis attribute clock_signal of muxclk is "yes";

  assign xsynco = xsoe? (xstp?clkd:xgo) : 'bZ;

  assign test = {pcref,pcsclk,pcsdata,pwr5v, L,tsynci,xsynci,xgo};

endmodule

module div_to_pps (sclk,oppms,oppus);
  input sclk;
  output reg oppms,oppus;
  reg [6:0] oppusc;
  reg [9:0] oppmsc;
  always @(posedge sclk) begin
    oppus <= (oppusc==0);
    if (oppus) oppusc <= 7'h62; else oppusc <= oppusc-1;
    oppms <= (oppmsc==0) && oppus;
    if (oppms) oppmsc <= 10'h3E7; else if (oppus) oppmsc <= oppmsc-1;
  end
endmodule

module div_to_ppsx (sclk,opps,oppts,oppms,oppus);
  input sclk;
  output reg opps,oppts,oppms,oppus;
  reg [6:0] oppusc;
  reg [9:0] oppmsc;
  reg [6:0] opptsc;
  reg [3:0] oppsc;
  always @(posedge sclk) begin
    oppus <= (oppusc==0);
    if (oppus) oppusc <= 7'h62; else oppusc <= oppusc-1;
    oppms <= (oppmsc==0) && oppus;
    if (oppms) oppmsc <= 10'h3E7; else if (oppus) oppmsc <= oppmsc-1;
    oppts <= (opptsc==0) && oppms;
    if (oppts) opptsc <= 7'h63; else if (oppms) opptsc <= opptsc-1;
    opps <= (oppsc==0) && oppts;
    if (opps) oppsc <= 4'h9; else if (oppts) oppsc <= oppsc-1;
  end
endmodule

module divide_by_64 (clki,clko);
  input clki;
  output clko;
  reg [5:0] cntq; 
  always @(posedge clki) cntq <= cntq+1;
  wire clko = cntq[5];
endmodule

module max6577 (input clk, input oppms, input tsense, output[7:0] temp);
  reg [8:0] tcnt;
  reg [7:0] qcnt,tsav;
  reg qpps,t1,t2,ts;
  always @(posedge clk) begin
    if (qpps) qcnt<=0; else if (oppms) qcnt <= qcnt+1;
    qpps <= (qcnt==8'd250) && !qpps;
    t1 <= tsense;
    t2 <= t1;
    ts <= t1 && !t2;
    if (qpps) tcnt <= 0; else if (ts) tcnt <= tcnt+1;
    if (qpps) tsav <= tcnt[7:0];
  end
  assign temp = tsav;
endmodule

module xsyncsense (input clk, input oppms, input xsynci, output[7:0] status);
  reg [7:0] tcnt,scnt;
  reg [19:0] xcnt;
  reg trst,t1,t2,ts;
  
  always @(posedge clk) begin
    if (trst) tcnt <= 0; else if (oppms) tcnt <= tcnt+1;
    trst <= oppms && (tcnt==99);			// 100ms counter
    t1 <= xsynci; t2 <= t1; ts <= t1 && !t2;		// find pos transition
    if (trst) xcnt <= 0; else if (ts) xcnt <= xcnt+1;	// count transitions
    if (trst) scnt <= {xcnt[19:14],(xcnt>=999900 && xcnt<=1000100),(xcnt>=9 && xcnt<=11)};	// valid for 10Mhz and 100Hz
  end
  assign status = scnt;
//  assign status = {tcnt,t1,oppms,trst,clk};
endmodule
/*
module clocksense (input clk, input opps, input xref, output[7:0] status);
  reg [7:0] tcnt,scnt;
  reg [19:0] xcnt;
  reg trst,t1,t2,ts;
  
  always @(posedge clk) begin
    if (trst) tcnt <= 0; else if (oppms) tcnt <= tcnt+1;
    trst <= oppms && (tcnt==99);			// 100ms counter
    t1 <= xsynci; t2 <= t1; ts <= t1 && !t2;		// find pos transition
    if (trst) xcnt <= 0; else if (ts) xcnt <= xcnt+1;	// count transitions
    if (trst) scnt <= {xcnt[19:14],(xcnt>=999900 && xcnt<=1000100),(xcnt>=9 && xcnt<=11)};	// valid for 10Mhz and 100Hz
  end
  assign status = scnt;
//  assign status = {tcnt,t1,oppms,trst,clk};
endmodule
*/

module statusPPS (clk,pps,status);
  input clk,pps;
  output [31:0] status;
  reg ppsc,zcnt;
  reg [27:0] cnt,ccnt;	// current count
  reg [7:0] ppss;
  always @(posedge clk) begin
    ppss <= {ppss,pps};
    ppsc <= (ppss == 8'b00000011);
    zcnt <= (cnt[26:11]==0);	// protect from ringing in this region
    if (ppsc) cnt <= 0; else if (!cnt[27]) cnt <= cnt+1;
    if (ppsc && !zcnt) ccnt <= cnt;
  end
  assign status = {ccnt[26:11],cnt[26:11]};
endmodule

