`include "../lib/ramdefs.h"
module
pktengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
SBW
=
32
;
parameter
DBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
11
:
0
]
z3
;
swrbank
#
(
0
,
1
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z3
);
wire
z4
=
z3
[
0
];
reg
[
31
:
0
]
z5
;
always
@(
posedge
sclk
)
begin
if
(
srst
)
z5
<=
0
;
else
if
(
z4
)
z5
<=
swrbus
;
end
wire
z6
=
z5
[
0
];
wire
z7
=
z5
[
1
];
wire
z8
=
!
z6
;
wire
z9
,
z10
,
z11
,
z12
,
z13
,
z14
,
z15
,
z16
;
wire
[
DBW
-
1
:
0
]
z17
,
z18
,
z19
,
z20
;
wire
z21
,
z22
,
z23
,
z24
,
z25
;
wire
[
3
:
0
]
z26
,
z27
;
wire
[
31
:
0
]
z28
;
wire
[
7
:
0
]
z29
;
reg
z30
;
always
@(
posedge
ioclk
)
z30
<=
iena
;
fifoNxM
#
(
IBW
,
DBW
,
4
,
3
)
fi
(
ioclk
,
z8
,
istat
,
z30
,
ibus
,
sclk
,
z8
,
z13
,
z9
,
z17
);
dat2pkt
d2p
(
sclk
,
srst
,
scs
&
swr
,
saddr
,
swrbus
,
srdbus
,
z13
,
z9
,
z27
,
z17
,
z15
&
z23
,
z10
,
z18
,
z21
,
test
);
`ifdef PKTETH
pkt2eth
p2e
(
sclk
,
z8
,
z23
,
z10
,
z1
,
z18
,
z26
,
z28
,
z22
);
eth2pkt
e2p
(
sclk
,
z8
,
z26
,
z28
,
z11
,
z19
);
`else
assign
z19
=
z18
;
assign
z11
=
z10
;
assign
z23
=
z15
;
`endif
`ifdef PKTENGINE
wire
[
SBW
-
1
:
0
]
z31
;
wire
z32
;
wire
[
7
:
0
]
z33
;
`PKTENGINE #(0,DBW,IBW,0,1) p2d (sclk,srst, scs,saddr, swr,swrbus, srd,z31, z32,
ioclk
,
z15
,
z11
,
z33
,
z19
,
ostat
,
oena
,
osel
,
obus
,
test
);
`else
fifoNxM
#
(
DBW
,
IBW
,
4
,
3
)
fo
(
sclk
,
z8
,
z15
,
z11
,
z19
,
ioclk
,
z8
,
ostat
,
oena
,
obus
);
assign
osel
=
0
;
`endif
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z10
,
z9
,
z7
,
z8
};
endmodule
module
pkt2pkt
(
clk
,
z8
,
z13
,
z9
,
z17
,
z14
,
z10
,
wena2
,
z18
);
parameter
DBW
=
32
;
parameter
NC
=
1
;
input
clk
,
z8
;
input
[
1
:
0
]
z13
;
output
z9
;
input
[
DBW
-
1
:
0
]
z17
;
input
z14
;
output
reg
z10
,
wena2
;
output
[
DBW
-
1
:
0
]
z18
;
wire
z1
=
0
,
z2
=
1
;
reg
z34
,
z35
,
z36
;
reg
[
15
:
0
]
z37
;
always
@(
posedge
clk
)
begin
z34
<=
z13
&&
z14
&&
!
z34
&&
!
z35
;
if
(
z34
)
z37
<=
z17
[
15
:
0
];
else
if
(
z35
)
z37
<=
z37
-
4
;
z35
<=
(
z34
&&
(
z17
[
31
:
16
]==
16'h1CEF
)
&&
z17
[
15
:
0
]!=
0
)
||
(
z35
&&
(
z37
>
4
));
z36
<=
z35
;
z10
<=
z35
&&
z36
;
wena2
<=
z1
;
end
assign
z9
=
z34
||
z35
;
assign
z18
=
z17
;
endmodule
module
dat2pkt
(
clk
,
z8
,
pwr
,
paddr
,
pdata
,
pdatar
,
z13
,
z9
,
z27
,
z17
,
z14
,
z10
,
z18
,
bypass
,
test
);
parameter
DBW
=
32
;
parameter
NC
=
1
;
input
clk
,
z8
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
[
1
:
0
]
z13
;
output
[
2
:
0
]
z9
;
input
[
3
:
0
]
z27
;
input
[
DBW
-
1
:
0
]
z17
;
input
z14
;
output
z10
;
output
[
DBW
-
1
:
0
]
z18
;
output
bypass
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
reg
[
3
:
0
]
z38
;
reg
[
2
:
0
]
z39
;
reg
[
7
:
0
]
z40
,
z41
;
reg
[
11
:
0
]
z42
;
reg
[
31
:
0
]
z43
;
reg
[
3
:
0
]
z44
;
reg
z45
,
z46
,
z47
,
z48
,
z49
,
z50
;
reg
z51
,
z52
,
z53
,
z54
,
z55
,
z56
;
reg
z57
,
z58
,
z59
,
z60
;
reg
[
31
:
0
]
z61
;
wire
z6
=
z61
[
0
];
assign
bypass
=
z61
[
4
];
wire
z62
=
z61
[
6
];
wire
[
31
:
0
]
z63
,
z64
;
dpram
#
(
4
,
32
,
32
)
rseq
(
clk
,
z2
,
paddr
[
11
:
2
],
pwr
,
pdata
,
z64
,
clk
,
z2
,
{
z38
,
z40
},
z1
,
32'h0
,
z63
);
wire
[
7
:
0
]
z65
=
z43
[
7
:
0
];
wire
[
10
:
0
]
z66
=
z43
[
7
:
0
];
wire
[
3
:
0
]
z67
=
z43
[
11
:
8
];
wire
[
1
:
0
]
z68
=
z43
[
13
:
12
];
wire
z69
=
z43
[
19
];
wire
z70
=
z43
[
20
];
wire
z71
=
z63
[
21
];
wire
z72
=
z63
[
22
];
wire
z73
=
z43
[
23
]&
z57
;
wire
z74
=
z43
[
24
];
wire
z75
=
z43
[
25
];
wire
z76
=
z43
[
26
];
wire
z77
=
z43
[
27
];
wire
z78
=
z43
[
28
];
wire
z79
=
z43
[
29
];
wire
z80
=
z43
[
30
];
wire
z81
=
z43
[
31
];
wire
z82
=
z63
[
31
]&&
z49
;
wire
z83
=
z45
||
z49
||
z46
;
wire
z84
=
z72
;
wire
[
1
:
0
]
z85
=
z27
;
wire
[
7
:
0
]
z86
=
z44
[
z85
]?
z61
[
31
:
24
]
:
z61
[
23
:
16
];
wire
z87
=
z39
[
2
]
||
(!
z62
&&
!
z83
&&
!
z13
[
z59
]
&&
!
z60
);
always
@(
posedge
clk
)
begin
z54
<=
pwr
&&
(
paddr
[
11
:
0
]==
0
);
z55
<=
pwr
&&
(
paddr
[
11
:
2
]==
0
);
if
(
z8
)
z61
<=
0
;
else
if
(
z54
)
z61
<=
pdata
;
if
(
z8
)
z56
<=
0
;
else
if
(
z55
)
z56
<=
pdata
[
0
];
z39
<=
{
z39
,
z42
==
4
};
z45
<=
z13
[
z59
]
&&
z14
&&
!
z45
&&
!
z50
&&
!
z60
&&
z56
;
z46
<=
(
z49
&&
z82
)
||
(
z46
&&
!
z39
[
2
]
&&
!
z8
);
z47
<=
(
z49
&&
z71
)
||
(
z47
&&
!
z39
[
0
]
&&
!
z8
);
z48
<=
z47
;
z49
<=
z45
||
(
z49
&&
!
z84
&&
!
z8
);
z50
<=
z83
;
z60
<=
z87
;
if
(
z45
)
z38
<=
z85
;
if
(
z82
)
z42
<=
z63
[
11
:
0
];
else
if
(
z46
)
z42
<=
z42
-
1
;
if
(
z82
)
z51
<=
z63
[
12
];
if
(
z82
)
z52
<=
z63
[
13
];
if
(
z82
)
z53
<=
z63
[
14
];
if
(!
z83
)
z40
<=
z86
;
else
if
(
z73
)
z40
<=
z43
[
7
:
0
];
else
if
(!
z47
)
z40
<=
z40
+
1
;
if
(!
z49
||
z47
||
z48
)
z43
<=
0
;
else
z43
<=
z63
;
if
(
z8
)
z59
<=
0
;
else
if
(
z87
)
z59
<=
!
z59
;
end
assign
z9
=
(
NC
<
2
)?
z46
:
{
!
z46
&&
z59
,
z46
&&
z59
,
z46
&&
!
z59
};
wire
[
3
:
0
]
z88
;
reg
[
3
:
0
]
z89
;
wire
[
4
:
0
]
z90
=
{
z1
,
z88
}
+
z67
+
z58
;
always
@(
posedge
clk
)
begin
if
(
z74
)
z89
<=
z67
;
else
if
(
z75
)
z89
<=
z90
;
if
(
z78
)
z57
<=
z68
[
0
];
else
if
(
z80
)
z57
<=
z58
^
z68
[
0
];
if
(
z79
)
z58
<=
z68
[
1
];
else
if
(
z75
)
z58
<=
z90
[
4
];
if
(
z55
)
z44
<=
{
4
{
pdata
[
5
]}};
else
if
(
z70
)
z44
[
z38
]
<=
z58
;
end
wire
z91
=
(
pwr
&&
!
z77
)
||
z69
;
wire
[
9
:
0
]
z92
=
(
z77
|
z69
)?
{
z38
,
z65
}
:
paddr
[
11
:
2
];
wire
[
12
:
0
]
z93
=
{
z38
,
z66
};
wire
[
31
:
0
]
z94
;
dpram
#
(
4
,
4
,
32
)
rhdr
(
clk
,
z2
,
z93
,
z76
&
z57
,
z89
,
z88
,
clk
,
z2
,
z92
,
z91
,
z69
?
z17
:
pdata
,
z94
);
reg
z95
,
z10
,
z96
;
reg
[
1
:
0
]
z97
,
z98
;
reg
[
31
:
0
]
z20
;
wire
[
31
:
0
]
z19
;
always
@(
posedge
clk
)
begin
z97
<=
z77
?
3
:
z52
?
2
:
z51
?
1
:
0
;
z95
<=
z77
||
z46
;
z10
<=
z95
;
z96
<=
z46
&&
z53
;
if
(
z77
)
z98
<=
0
;
else
if
(
z96
)
z98
<=
(
z98
==
3
)?
1
:
z98
+
1
;
z20
<=
z19
;
end
mux4xNp
#
(
DBW
)
dom
(
z19
,
z17
,
{
z17
[
23
:
16
],
z17
[
31
:
24
],
z17
[
7
:
0
],
z17
[
15
:
8
]},
{
z17
[
7
:
0
],
z17
[
15
:
8
],
z17
[
23
:
16
],
z17
[
31
:
24
]},
z94
,
z97
,
clk
);
`ifdef NIO_SWAP12
mux4xN
#
(
DBW
)
dox
(
z18
,
z19
,
{
z17
[
3
:
0
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z19
[
23
:
20
],
z19
[
11
:
4
]},{
z19
[
19
:
16
],
z17
[
7
:
4
],
z19
[
27
:
20
],
z19
[
11
:
4
],
z20
[
27
:
24
],
z19
[
15
:
12
]},{
z19
[
27
:
20
],
z19
[
11
:
8
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z20
[
31
:
28
]},
z98
);
`else
assign
z18
=
z19
;
`endif
assign
test
=
{
z9
,
z46
,
z13
,
z59
,
z95
};
assign
pdatar
=
z94
;
endmodule
module
pkt2eth
(
clk
,
z8
,
trdy
,
tval
,
tvax
,
tbus
,
z26
,
z28
);
parameter
DBW
=
32
;
input
clk
,
z8
;
output
trdy
;
input
tval
,
tvax
;
input
[
31
:
0
]
tbus
;
output
[
3
:
0
]
z26
;
output
[
31
:
0
]
z28
;
wire
z1
=
0
,
z2
=
1
;
wire
[
31
:
0
]
z99
;
wire
[
31
:
0
]
z100
=
~
z99
;
reg
[
63
:
0
]
z101
;
reg
[
31
:
0
]
z28
;
reg
[
3
:
0
]
z26
;
reg
z102
,
z103
;
wire
z104
=
tval
&&
!
z102
;
wire
z105
=
z102
&&
!(
tval
|
tvax
);
wire
z106
;
delaypipe
#
(
1
)
dlst1
(
clk
,
z104
,
z106
);
wire
z107
;
delaypipe
#
(
2
)
dlst2
(
clk
,
z104
,
z107
);
wire
z108
;
delaypipe
#
(
2
)
dlval
(
clk
,
tval
|
tvax
,
z108
);
wire
z109
;
delaypipe
#
(
2
)
dlend
(
clk
,
z105
,
z109
);
wire
z110
;
delaypipe
#
(
3
)
dlvax
(
clk
,
tvax
,
z110
);
delaypipe
#
(
3
)
dlrdy
(
clk
,!
z102
,
trdy
);
always
@(
posedge
clk
)
begin
z103
<=
tvax
;
z102
<=
tval
||
tvax
;
z101
<=
z103
?
{
z100
,
z101
[
47
:
32
]}
:
z105
?
{
z100
,
z101
[
63
:
32
]}
:
{
tbus
,
z101
[
63
:
32
]};
z28
<=
z104
?
32'h555555FB
:
z106
?
32'hD5555555
:
z108
?
z101
[
47
:
16
]
:
z110
?
32'h070707FD
:
z109
?
{
16'h07FD
,
z101
[
31
:
16
]}
:
32'h07070707
;
z26
<=
z104
?
4'h1
:
z106
?
4'h0
:
z108
?
4'h0
:
z110
?
4'hF
:
z109
?
4'hC
:
4'hF
;
end
crc32_d32
txcrc
(
clk
,
z1
,!
z102
,
tval
,
tvax
,
tbus
,
z99
);
endmodule
module
eth2pkt
(
clk
,
rst
,
z26
,
z28
,
z95
,
obus
,
pena
,
pbus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
input
clk
,
rst
;
input
[
3
:
0
]
z26
;
input
[
31
:
0
]
z28
;
output
z95
,
pena
;
output
[
31
:
0
]
obus
,
pbus
;
wire
z1
=
0
,
z2
=
1
;
reg
[
63
:
0
]
z101
;
reg
z111
,
z112
,
z104
,
z113
,
z114
;
reg
[
NP
-
1
:
0
]
z115
;
wire
z105
=
z112
&&
!
z111
;
always
@(
posedge
clk
)
begin
if
(
rst
)
z111
<=
0
;
else
z111
<=
z111
?
(
z26
==
0
)
:
(
z26
==
4'h1
&&
z28
==
32'h555555FB
);
if
(
rst
)
z112
<=
0
;
else
z112
<=
z111
;
if
(
rst
)
z104
<=
0
;
else
z104
<=
(
z115
==
8
);
if
(!
z112
)
z115
<=
0
;
else
z115
<=
z115
+
1
;
z101
<=
{
z28
,
z101
[
63
:
32
]};
z113
<=
z104
;
z114
<=
z105
;
end
assign
z95
=
z111
;
assign
obus
=
z101
[
47
:
16
];
assign
pena
=
z104
||
z105
;
assign
pbus
=
{
z114
,
z113
,
2'b0
,
z115
,
2'b0
};
endmodule
module
pkt2dat
(
clk
,
rst
,
pwr
,
paddr
,
pdata
,
pdatar
,
z112
,
tbus
,
oval
,
obus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
parameter
INST
=
0
;
input
clk
,
rst
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
z112
;
input
[
31
:
0
]
tbus
;
output
oval
;
output
[
31
:
0
]
obus
;
wire
z1
=
0
,
z2
=
1
;
reg
z116
;
reg
[
31
:
0
]
z117
,
z118
,
z119
,
z120
;
wire
z104
=
z112
&&
!
z116
;
wire
z105
=
!
z112
&&
z116
;
wire
[
1
:
0
]
z38
=
INST
;
wire
z8
=
rst
||
z117
[
0
];
wire
[
31
:
0
]
z121
=
{
16'h01CE
,
3'h0
,
z8
,
2'h0
,
z38
};
always
@(
posedge
clk
)
begin
if
(
pwr
)
z117
<=
pdata
;
if
(
z112
)
z120
<=
tbus
;
z116
<=
z112
;
if
(
z8
)
z119
<=
0
;
else
if
(
z105
)
z119
<=
z119
+
1
;
if
(
z8
)
z118
<=
~
0
;
else
if
(
z112
)
z118
<=
z118
^
tbus
;
end
muxMxNp
#
(
4
,
32
)
rm
(
pdatar
,
{
z120
,
z121
,
z118
,
z119
},
paddr
[
3
:
2
],
clk
);
assign
oval
=
z116
;
assign
obus
=
z120
;
endmodule
`define Z122 1
`include "../lib/crc32.v"
