module
gsdengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
SBW
=
32
;
parameter
DBW
=
32
;
parameter
NF
=
1
;
`ifdef DTDM
parameter
ICNT
=(
NF
==
4
)?
4000
:
(
NF
==
2
)?
2000
:
1000
;
parameter
JCNT
=(
NF
==
4
)?
5120
:
(
NF
==
2
)?
2560
:
1312
;
`else
parameter
ICNT
=(
NF
==
4
)?
2000
:
(
NF
==
2
)?
1000
:
500
;
parameter
JCNT
=(
NF
==
4
)?
2560
:
(
NF
==
2
)?
1280
:
656
;
`endif
parameter
OCNT
=
256
*
NF
;
parameter
OBIT
=(
NF
==
4
)?
10
:
(
NF
==
2
)?
9
:
8
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
reg
[
31
:
0
]
z3
,
z4
,
z5
,
z6
,
z7
;
reg
z8
,
z9
,
z10
,
z11
,
z12
;
reg
z13
;
always
@(
posedge
sclk
)
begin
z8
<=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
0
);
z9
<=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
1
);
z10
<=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
2
);
z11
<=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
3
);
z12
<=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
4
);
if
(
z8
)
z3
<=
swrbus
;
if
(
z9
)
z4
<=
swrbus
;
if
(
z10
)
z5
<=
swrbus
;
if
(
z11
)
z6
<=
swrbus
;
if
(
z12
)
z7
<=
swrbus
;
end
reg
z14
;
reg
[
3
:
0
]
z15
;
reg
[
12
:
0
]
z16
;
wire
z17
=
(
z14
&&
(
z16
==(
JCNT
-
1
)))
||
srst
;
wire
z18
=
(
z14
&&
(
z16
==(
ICNT
-
1
)));
wire
z19
=
(
z16
==
0
);
always
@(
posedge
ioclk
)
begin
z14
<=
iena
;
if
(
srst
)
z13
<=
0
;
else
z13
<=
z13
^
z18
;
if
(
z19
)
z15
<=
z3
[
19
:
16
];
if
(
z17
)
z16
<=
0
;
else
if
(
z14
)
z16
<=
z16
+
1
;
end
wire
[
9
:
0
]
z20
;
wire
[
31
:
0
]
z21
;
`ifdef DTDM
wire
[
7
:
0
]
z22
;
wire
[
7
:
0
]
z23
=
ibus
[
31
]?
~
ibus
[
31
:
24
]
:
ibus
[
31
:
24
];
wire
[
11
:
0
]
z24
=
z16
[
11
:
0
]
-
z15
;
dpram
#
(
4
,
8
,
32
)
ramc
(
ioclk
,
z2
,
z24
,
z14
&!
z16
[
12
],
z23
,
z22
,
sclk
,
z2
,
z20
,
z1
,
32'b0
,
z21
);
`else
wire
[
15
:
0
]
z22
;
wire
[
15
:
0
]
z23
=
{
ibus
[
63
]?
~
ibus
[
63
:
56
]
:
ibus
[
63
:
56
],
ibus
[
31
]?
~
ibus
[
31
:
24
]
:
ibus
[
31
:
24
]};
wire
[
10
:
0
]
z24
=
z16
[
10
:
0
]
-
z15
[
3
:
1
];
dpram
#
(
4
,
16
,
32
)
ramc
(
ioclk
,
z2
,
z24
,
z14
&!
z16
[
11
],
z23
,
z22
,
sclk
,
z2
,
z20
,
z1
,
32'b0
,
z21
);
`endif
wire
z25
;
reg
[
15
:
0
]
z26
;
reg
[
31
:
0
]
z27
;
reg
z28
,
z29
;
wire
z30
=
z28
&&
z25
;
wire
z31
=
z30
&&
(
z26
[
7
:
0
]==
255
);
wire
z32
=
(
z26
[
4
:
0
]==
0
);
wire
z33
=
(
z26
[
4
:
0
]==
1
);
wire
z34
=
(
z26
[
4
:
0
]==
31
);
reg
[
9
:
0
]
z35
;
reg
[
3
:
0
]
z36
;
reg
[
7
:
0
]
z37
,
z38
,
z39
,
z40
;
wire
[
7
:
0
]
z41
=
{
5'd0
,
z26
[
7
:
5
]};
wire
[
7
:
0
]
z42
=
0
;
wire
[
7
:
0
]
z43
=
8'h56
;
always
@(
posedge
sclk
)
begin
if
(
srst
)
z26
<=
0
;
else
if
(
z30
)
z26
<=
z26
+
1
;
if
(
srst
)
z28
<=
0
;
else
z28
<=
z28
?
!
z31
:
(
z26
[
OBIT
]
^
z13
);
if
(!
z28
)
z40
<=
z3
[
31
:
24
];
if
(!
z28
)
z35
<=
z3
[
9
:
0
];
if
(!
z28
)
z36
<=
z6
[
3
:
0
];
if
(!
z28
)
z38
<=
z7
[
7
:
0
];
if
(!
z28
)
z39
<=
z7
[
15
:
8
];
z37
<=
z40
[
6
]?
3
:
z40
[
3
]?
2
:
(
z26
[
6
:
5
]==
1
)?
0
:
1
;
z27
<=
z32
?
{
z41
,
z37
,
z36
,
2'h0
,
z35
}
:
z33
?
z4
:
z34
?
{
z39
,
z38
,
z43
,
z42
}
:
z21
;
z29
<=
z30
;
end
fifoNxM
#
(
DBW
,
IBW
)
fo
(
sclk
,
srst
,
z25
,
z29
,
z27
,
ioclk
,
srst
,
ostat
,
oena
,
obus
);
assign
istat
=
z25
;
assign
z20
=
z26
[
9
:
0
];
assign
srdbus
=
{
z3
[
31
:
16
],
12'h1CE
,
z3
[
3
:
0
]};
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z3
[
3
:
0
]};
endmodule
