`include "../lib/firdefs.h"
`ifndef FIR_ORDER
`define FIR_ORDER 5
`endif
`define Z1 1
module
firengine
(
sclk
,
rst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
DBW
=
16
;
parameter
CBW
=
20
;
parameter
GBW
=
4
;
parameter
RBW
=
10
;
parameter
ORDER
=`FIR_ORDER
;
`ifdef Z1
parameter
NPC
=
2
;
`else
parameter
NPC
=
1
;
`endif
`ifdef FIR_PARALLEL
parameter
NPS
=`FIR_PARALLEL
;
`else
parameter
NPS
=
1
;
`endif
localparam
BBW
=
3
;
localparam
ABW
=
2
;
localparam
SBW
=
18
;
localparam
CDRBW
=
BBW
+
DBW
+
4
;
input
sclk
;
input
rst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z2
=
0
,
z3
=
1
;
assign
sack
=
z3
;
wire
z4
,
z5
,
z6
;
reg
z7
,
z8
,
z9
,
z10
;
reg
[
31
:
0
]
z11
;
reg
[
15
:
0
]
z12
;
statusblk
#
(
"FIR"
,
ORDER
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
15
:
0
]
z13
;
swrbank
#
(
0
,
16
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z13
);
wire
z14
=
z13
[
0
];
wire
z15
=
z13
[
9
];
wire
z16
=
z13
[
12
];
wire
z17
=
z13
[
13
];
always
@(
posedge
sclk
)
begin
z10
<=
!
z11
[
0
]
||
rst
;
if
(
z14
)
z11
<=
swrbus
;
if
(
z15
)
z12
<=
swrbus
[
15
:
0
];
end
wire
z18
=
z3
;
wire
[
3
:
0
]
z19
=
z11
[
11
:
8
];
wire
[
3
:
0
]
z20
=
z11
[
15
:
12
];
wire
z21
=
!
z20
[
0
];
wire
z22
=
z20
[
0
];
wire
z23
=
z19
[
3
];
wire
z24
=
z20
[
3
];
always
@(
posedge
sclk
)
begin
z7
<=
z5
&&
z4
&&
z6
;
z8
<=
z7
;
end
always
@(
posedge
ioclk
)
z9
<=
iena
;
`ifdef FIR_PARALLEL
wire
[
NPS
*
NPC
*
DBW
-
1
:
0
]
z25
;
wire
[
NPC
*
DBW
-
1
:
0
]
z26
;
wire
z27
;
fifoNxM
#
(
IBW
,
NPS
*
NPC
*
DBW
)
fi
(
ioclk
,
z10
,
istat
,
z9
,
ibus
,
sclk
,
z10
,
z5
,
z7
,
z25
);
firfilter
#
(
ORDER
,
DBW
,
CBW
,
DBW
,
GBW
,
RBW
,`RCELLO
,
NPC
,
NPS
)
fir
(
sclk
,
z10
,
z16
,
z17
,
swrbus
,
z4
,
z8
,
z25
,
z27
,
z26
,
z2
);
fifoNxM
#
(
NPC
*
DBW
,
IBW
)
fo
(
sclk
,
z10
,
z6
,
z27
,
z26
,
ioclk
,
z10
,
ostat
,
oena
,
obus
);
`elsif Z1
wire
[
31
:
0
]
z25
,
z26
;
wire
z27
;
fifoNxMfmt
#
(
IBW
,
32
)
fi
(
ioclk
,
z10
,
z19
,
istat
,
z9
,
ibus
,
sclk
,
z10
,
4'h8
,
z5
,
z7
,
z25
);
firfilter
#
(
ORDER
,
DBW
,
CBW
,
DBW
,
GBW
,
RBW
,`ANTISYM
|`CAUSAL
,
NPC
,
NPS
)
fir
(
sclk
,
z10
,
z16
,
z17
,
swrbus
,
z4
,
z8
,
z25
,
z27
,
z26
,
z2
);
fifoNxMfmti
#
(
IBW
,
32
)
fo
(
ioclk
,
z10
,
z20
,
ostat
,
oena
,
obus
,
sclk
,
z10
,
4'h8
,
z6
,
z27
,
z26
);
`else
wire
[
31
:
0
]
z25
;
fifoNxMfmt
#
(
IBW
,
32
)
fi
(
ioclk
,
z10
,
z19
,
istat
,
z9
,
ibus
,
sclk
,
z10
,
4'h8
,
z5
,
z7
,
z25
);
wire
[
SBW
-
1
:
0
]
z28
;
wire
z29
,
z30
,
z31
;
firfilter
#
(
ORDER
,
DBW
,
CBW
,
SBW
,
GBW
,
RBW
,`ANTISYM
|`CAUSAL
,
NPC
,
NPS
)
fir
(
sclk
,
z10
,
z16
,
z17
,
swrbus
,
z4
,
z8
,
z25
,
z29
,
z28
,
z2
);
wire
[
CDRBW
-
1
:
0
]
z32
,
z33
,
z34
;
srmul
#
(
SBW
,
16
,
CDRBW
)
scl
(
z28
,
z12
,
z32
,
sclk
,
z3
);
roundN2Mc
#
(
CDRBW
,
DBW
,
BBW
)
rndi
(
z32
,
z33
,
z21
,
z18
,
sclk
,
z30
);
roundN2Mc
#
(
CDRBW
,
8
,
BBW
)
rndb
(
z33
,
z34
,
z22
,
z18
,
sclk
,
z31
);
wire
z35
,
z36
;
wire
[
31
:
0
]
z37
;
reg
z38
,
z39
,
z40
,
z27
;
fifoNxM
#
(
32
,
32
)
fb
(
sclk
,
z10
,
z35
,
z8
,
z25
,
sclk
,
z10
,
z36
,
z39
,
z37
);
wire
[
15
:
0
]
z41
=
z34
[
CDRBW
-
BBW
-
1
:
CDRBW
-
BBW
-
DBW
];
reg
[
31
:
0
]
z26
;
always
@(
posedge
sclk
)
begin
z38
<=
z29
;
z39
<=
z38
;
z40
<=
z39
;
z27
<=
z40
;
z26
<=
z24
?
{
z41
,
z37
[
15
:
0
]}
:
{
16'h0
,
z41
};
end
fifoNxMfmti
#
(
IBW
,
32
)
fo
(
ioclk
,
z10
,
z20
,
ostat
,
oena
,
obus
,
sclk
,
z10
,
4'h8
,
z6
,
z27
,
z26
);
`endif
endmodule
module
firfilter
(
clk
,
srst
,
sload
,
cload
,
sbus
,
z4
,
vin
,
din
,
vout
,
dout
,
opt
);
parameter
ORDER
=
4
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
GBW
=
8
;
parameter
RBW
=
4
;
parameter
FLAGS
=`ANTISYM
;
parameter
NPC
=
1
;
parameter
NPS
=
1
;
localparam
ANTISYM
=(
FLAGS
&`ANTISYM
)?
1
:
0
;
localparam
PREOUT
=(
FLAGS
&`PREOUT
)?
1
:
0
;
localparam
RCELLO
=(
ORDER
>
1
&&
NPS
<=
1
&&
(
FLAGS
&`RCELLO
)==
0
);
localparam
CAUSAL
=(
FLAGS
&`CAUSAL
)?
1
:
0
;
localparam
C2ROUT
=(
FLAGS
&`C2ROUT
)?
1
:
0
;
localparam
SCLOUT
=(
FLAGS
&`SCLOUT
)?
1
:
0
;
localparam
M
=(
FLAGS
&`XTAPS
)?
5
:
4
;
localparam
XCOEF
=(
FLAGS
&`XCOEF
)?
1
:
0
;
localparam
PBW
=
IBW
+
CBW
-
1
;
localparam
SBW
=
OBW
+
GBW
+
RBW
;
localparam
DBW
=(
PREOUT
||
C2ROUT
)?
SBW
:
OBW
;
localparam
CELLS
=(
2
**
ORDER
);
localparam
RCELL
=(
RCELLO
)?(
CELLS
-
3
):(
CELLS
-
2
*
NPS
);
localparam
TBW
=
NPC
*
IBW
;
localparam
QBW
=
NPC
*
DBW
;
localparam
NPSO
=(
NPS
==
4
)?
2
:(
NPS
==
2
)?
1
:
1
;
input
clk
,
srst
;
input
sload
,
cload
;
input
[
31
:
0
]
sbus
;
input
vin
;
input
[
NPS
*
TBW
-
1
:
0
]
din
;
output
z4
,
vout
;
output
[
QBW
-
1
:
0
]
dout
;
input
opt
;
wire
z2
=
0
,
z3
=
1
;
wire
[
NPS
*
TBW
-
1
:
0
]
z42
,
z43
;
wire
[
TBW
-
1
:
0
]
z44
[
CELLS
-
1
:
0
],
z45
[
CELLS
-
1
:
0
];
wire
[
CBW
-
1
:
0
]
z46
[
CELLS
-
1
:
0
];
wire
[
CBW
-
1
:
0
]
z47
=
sbus
[
32
-
XCOEF
-
1
:
32
-
XCOEF
-
CBW
];
wire
[
NPSO
-
1
:
0
]
z48
=
sbus
[
NPSO
-
1
:
0
];
wire
[
NPC
*
SBW
-
1
:
0
]
z49
;
wire
z50
=
(
SCLOUT
)?
z2
:
opt
;
wire
z51
=
(
SCLOUT
)?
opt
:
z2
;
wire
[
27
:
0
]
z52
;
reg
[
M
:
0
]
z53
;
reg
[
M
-
1
:
0
]
z54
,
z55
,
z56
,
z57
,
z58
,
z59
;
reg
[
9
:
0
]
z60
;
reg
signed
[
16
:
0
]
z61
;
reg
z4
,
z62
,
z63
,
z64
,
z65
,
z66
,
z67
,
z68
,
z69
,
z70
,
z71
,
z72
,
z73
,
z74
;
wire
z75
=
z72
||
(
z62
&&
(
z59
==
z58
));
wire
z76
=
(
z60
==
0
);
wire
z77
=
(
z62
&&
z52
[
27
]
&&
!
z76
);
always
@(
posedge
clk
)
begin
if
(
z75
)
z59
<=
0
;
else
if
(
z62
)
z59
<=
z59
+
1
;
z54
<=
z52
[
5
:
0
];
z55
<=
z52
[
11
:
6
];
z56
<=
z52
[
17
:
12
];
z53
<=
z52
[
23
:
18
];
z66
<=
(
z62
&&
z52
[
24
])
||
z72
;
z67
<=
(
z62
&&
z52
[
25
]
&&
!
z65
)
||
z72
;
z70
<=
(
z62
&&
z52
[
26
]);
z71
<=
(
z62
&&
z52
[
27
]
&&
((
CAUSAL
==
0
)
||
z76
));
z63
<=
z62
;
z68
<=
sload
&&
sbus
[
31
];
z69
<=
sload
&&
z72
;
z72
<=
srst
;
z73
<=
z72
;
z57
<=
cload
?
z58
:
z56
;
if
(
z68
)
z60
<=
sbus
[
9
:
0
];
else
if
(
z77
)
z60
<=
z60
-
1
;
if
(
z68
)
z58
<=
sbus
[
21
:
16
];
if
(
z68
)
z64
<=
sbus
[
28
];
if
(
z68
)
z65
<=
sbus
[
29
];
if
(
z51
)
z61
<=
sbus
;
if
(
z51
)
$write
(
"Scale=%x\n"
,
sbus
);
end
srlMxN
#
(
M
,
28
)
seqr
(
clk
,
z69
,
z59
,
sbus
[
27
:
0
],
z52
);
wire
z78
,
z79
,
z80
;
wire
[
3
:
0
]
z81
=
1
+
ORDER
+
0
;
wire
[
3
:
0
]
z82
=
1
+
ORDER
+
1
+(
1
-
PREOUT
)+
SCLOUT
;
wire
[
3
:
0
]
z83
=
1
+
ORDER
+
1
;
srl16xNp
rdys
(
clk
,
z3
,
z81
,
z63
,
z80
);
srl16xNp
accs
(
clk
,
z3
,
z81
,
z70
,
z78
);
srl16xNp
acos
(
clk
,
z3
,
z82
,
z71
,
z79
);
reg
[
3
:
0
]
z84
,
z85
;
always
@(
posedge
clk
)
begin
if
(
z72
)
z84
<=
0
;
else
if
(
z66
&!
vin
)
z84
<=
z84
-
1
;
else
if
(!
z66
&
vin
)
z84
<=
z84
+
1
;
if
(
z72
)
z85
<=
z50
;
else
if
(
z66
&!
vin
)
z85
<=
z85
-
1
;
else
if
(!
z66
&
vin
)
z85
<=
z85
+
1
;
z4
<=
(
z84
<
8
)
||
(
z84
==
15
);
z62
<=
(
z84
>
2
)
&&
(
z84
!=
15
);
end
wire
z86
=
z72
&&
(
CAUSAL
==
0
);
genvar
i
,
j
,
n
,
m
;
generate
reg
[
NPS
-
1
:
0
]
z87
;
for
(
i
=
0
;
i
<
NPS
;
i
=
i
+
1
)
begin
:
cld
always
@(
posedge
clk
)
z87
[
i
]
<=
cload
&&
(
NPS
<=
1
||
z48
==
i
);
end
for
(
i
=
0
;
i
<
CELLS
;
i
=
i
+
1
)
begin
:
srl
/* verilator lint_off SELRANGE */
`ifdef VIVADO
localparam
k1
=
NPS
-
1
-(
i
);
localparam
k2
=
NPS
-
1
-(
i
-(
CELLS
-
NPS
));
srlMxN
#
(
M
,
TBW
)
insta
(
clk
,
z66
,
z54
,
(
i
<
NPS
)?
z42
[(
k1
+
1
)*
TBW
-
1
:
k1
*
TBW
]:
z44
[
i
-
NPS
],
z44
[
i
]);
srlMxN
#
(
M
,
TBW
)
instb
(
clk
,
z67
,
z55
,
(
i
>=
CELLS
-
NPS
)?
z43
[(
k2
+
1
)*
TBW
-
1
:
k2
*
TBW
]:
z45
[
i
+
NPS
],
z45
[
i
]);
`else
`define k1 (NPS-1-(i))
`define k2 (NPS-1-(i-(CELLS-NPS)))
srlMxN
#
(
M
,
TBW
)
insta
(
clk
,
z66
,
z54
,
(
i
<
NPS
)?
z42
[(`k1
+
1
)*
TBW
-
1
:`k1
*
TBW
]:
z44
[
i
-
NPS
],
z44
[
i
]);
srlMxN
#
(
M
,
TBW
)
instb
(
clk
,
z67
,
z55
,
(
i
>=
CELLS
-
NPS
)?
z43
[(`k2
+
1
)*
TBW
-
1
:`k2
*
TBW
]:
z45
[
i
+
NPS
],
z45
[
i
]);
`endif
/* verilator lint_on SELRANGE */
srlMxN
#
(
M
,
CBW
)
instc
(
clk
,
z87
[
i
%
NPS
],
z57
,
(
i
<
NPS
)?
z47
:
z46
[
i
-
NPS
],
z46
[
i
]);
end
endgenerate
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
ipc
for
(
m
=
0
;
m
<
NPS
;
m
=
m
+
1
)
begin
:
ips
wire
signed
[
IBW
-
1
:
0
]
z88
=
z44
[
RCELL
+
m
][(
n
+
1
)*
IBW
-
1
:
n
*
IBW
];
wire
signed
[
IBW
-
1
:
0
]
z89
=
(
z64
&&
ANTISYM
)?
-
z88
:
z88
;
`ifdef VIVADO
localparam
k3
=
m
*
NPC
+
n
;
srl16xN
#
(
IBW
)
fifo
(
clk
,
z86
|
vin
,
(
n
==
0
)?
z85
:
z84
,
z86
?
0
:
din
[(
k3
+
1
)*
IBW
-
1
:
k3
*
IBW
],
z42
[(
k3
+
1
)*
IBW
-
1
:
k3
*
IBW
]);
srlMxN
#
(
M
+
1
,
IBW
)
instrH
(
clk
,
z66
,
z53
,
z89
,
z43
[(
k3
+
1
)*
IBW
-
1
:
k3
*
IBW
]);
`else
`define k3 (m*NPC+n)
srl16xN
#
(
IBW
)
fifo
(
clk
,
z86
|
vin
,
(
n
==
0
)?
z85
:
z84
,
z86
?
0
:
din
[(`k3
+
1
)*
IBW
-
1
:`k3
*
IBW
],
z42
[(`k3
+
1
)*
IBW
-
1
:`k3
*
IBW
]);
srlMxN
#
(
M
+
1
,
IBW
)
instrH
(
clk
,
z66
,
z53
,
z89
,
z43
[(`k3
+
1
)*
IBW
-
1
:`k3
*
IBW
]);
`endif
end
wire
signed
[
OBW
+
RBW
:
0
]
z90
[
CELLS
-
1
:
0
];
wire
signed
[
SBW
-
1
:
0
]
z91
,
z92
,
z93
;
reg
signed
[
SBW
-
1
:
0
]
z94
[
CELLS
-
1
:
0
][
ORDER
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z95
;
for
(
i
=
0
;
i
<
CELLS
;
i
=
i
+
1
)
begin
:
tap
reg
signed
[
CBW
-
1
:
0
]
z96
;
reg
signed
[
IBW
-
1
:
0
]
z97
,
z98
;
reg
signed
[
IBW
:
0
]
z99
;
reg
signed
[
PBW
+
1
:
0
]
z100
;
always
@(
posedge
clk
)
begin
z97
<=
z44
[
i
][(
n
+
1
)*
IBW
-
1
:
n
*
IBW
];
z98
<=
z45
[
i
][(
n
+
1
)*
IBW
-
1
:
n
*
IBW
];
z99
<=
z97
+
z98
;
z96
<=
z46
[
i
];
z100
<=
z99
*
z96
;
end
assign
z90
[
i
]
=
z100
[
XCOEF
+
PBW
:
XCOEF
+
PBW
-
OBW
-
RBW
];
end
for
(
j
=
0
;
j
<
ORDER
;
j
=
j
+
1
)
begin
:
order
for
(
i
=
0
;
i
<(
2
**
j
);
i
=
i
+
1
)
begin
:
tree
always
@(
posedge
clk
)
z94
[
i
][
j
]
<=
(
j
+
1
==
ORDER
)?
z90
[
i
+
i
]
+
z90
[
i
+
i
+
1
]
:
z94
[
i
+
i
][
j
+
1
]
+
z94
[
i
+
i
+
1
][
j
+
1
];
end
end
assign
z91
=
z94
[
0
][
0
];
assign
z92
=
z91
+
z95
;
always
@(
posedge
clk
)
if
(
z80
)
z95
<=
z78
?
z92
:
z91
;
assign
z49
[(
n
+
1
)*
SBW
-
1
:
n
*
SBW
]
=
z95
;
end
endgenerate
generate
if
(
C2ROUT
)
begin
wire
z101
,
z102
;
srl16xNp
avmi
(
clk
,
z3
,
z83
,
z71
,
z101
);
delayp
#
(
1
)
avmq
(
clk
,
z101
,
z102
);
delayp
#
(
2
)
avmo
(
clk
,
z101
||
z102
,
vout
);
reg
[
1
:
0
]
z103
;
reg
signed
[
SBW
-
1
:
0
]
z104
,
z105
,
z106
;
always
@(
posedge
clk
)
begin
if
(
z72
)
z103
<=
0
;
else
if
(
z101
||
z102
)
z103
<=
z103
+
1
;
z104
<=
z49
[
2
*
SBW
-
1
:
SBW
];
z105
<=
(
z103
[
0
])?
z104
:
z49
[
SBW
-
1
:
0
];
z106
<=
(
z103
[
1
]&
z50
)?
-
z105
:
z105
;
end
assign
dout
[
SBW
-
1
:
0
]
=
z106
;
end
else
begin
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
ipc
wire
signed
[
24
:
0
]
z107
=
z49
[
24
+
n
*
SBW
:
n
*
SBW
];
reg
signed
[
40
:
0
]
z108
;
always
@(
posedge
clk
)
z108
<=
z107
*
z61
;
wire
z109
;
wire
signed
[
SBW
-
1
:
0
]
z110
,
z111
;
if
(
SCLOUT
)
assign
z110
=
z108
[
SBW
+
8
-
1
:
8
];
if
(!
SCLOUT
)
assign
z110
=
z49
[(
n
+
1
)*
SBW
-
1
:
n
*
SBW
];
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
cvt
(
z110
,
z111
,
z3
,
z3
,
clk
,
z109
);
assign
dout
[(
n
+
1
)*
DBW
-
1
:
n
*
DBW
]
=
(
PREOUT
)?
z110
:
z111
[
SBW
-
GBW
-
1
:
SBW
-
GBW
-
OBW
];
end
assign
vout
=
z79
;
end
endgenerate
endmodule
