!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  Command to allow user to quickly show additional information about
!  the NeXtMidas session / environment parameters
!
!  @author  Jeff Schoen
!  @since   NeXtMidas 3.1.1
!  @version $Id: show.mm,v 1.5 2015/11/16 21:21:29 ntn Exp $
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro s:view u:label

if view eqss "WHAT" then
  say "SHOW <view> <label> where view is one of:"
  say "  ASCII       - Display mapping of ASCII characters"
  say "  AUXes       - Display current auxes"
  say "  CONstants   - Display all universal constants"
  say "  COMMands    - Display all commands"
  say "  ENVironment - Display current environment variables"
  say "  EXTENsions  - Display supported file extensions"
  say "  FILES       - Display all files in current auxes"
  say "  HELP        - Runs HELP/GUI"
  say "  HW          - Display all hardware aliases"
  say "  PACKets     - Display supported packet types"
  say "  RESOurses   - Display supported file resources types"
  say "  WHAT        - Display supported views"
elseif view eqss "ASCII" then
  help "ASCII"
elseif view eqss "AUX" then
  auxiliary
elseif view eqss "CON" then
  query/fields/list=fields "nxm.sys.inc.Constants"
  table tab create
  foreach key inlist fields
    invoke val=nxm.sys.inc.Constants.^key
    set tab.^key val
  endfor
elseif view eqss "COMM" then
  menu
elseif view eqss "ENV" then
  environment
elseif view eqss "EXTEN" then
  set tab reg.handlers.file
elseif view eqss "FILE" then
  files
elseif view eqss "HELP" then
  help/gui
elseif view eqss "HW" then
  hw sh alias
elseif view eqss "PACK" then
  set tab reg.handlers.packet
elseif view eqss "RESO" then
  set tab reg.handlers.resource
else
  error "Unsupported view=^view"
endif

if tab nrexists then
  ! nothing to display or save to results label
elseif label neqs "" then
  set/global ^label tab
else
  res tab
endif

endmacro
