!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! DEMO - Spectral Dynamics NeXtMidas Demo Macro
! @author Jeff Schoen
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/theme=gear2

call setDatDir

pipe init

set sr 1e5
panel/setup/controls=gc/wmsgid=main ! special handling of window messages

waveform/rt _wave{ps=32k} shape=sin form=cf elem=inf amp=32e3 freq=sr/10 delta=1/sr

fft/psd/log _wave _waveb nfft=1k 

demod/lut _wave _waved{ps=32k} mode=fm

plot/id=gplot ^{datDir}.world.prm|^{datDir}.sv1.prm|^{datDir}.sv2.prm|^{datDir}.sv3.prm options=+BStore view=geo
plot/id=3dplot ^{datDir}.alaska.prm view=xyz
plot/id=srplot ^{datDir}.altitude.prm
!plot/id=jpplot Sunset.jpg

shellgui/id=term

plot/id=plot1 _waveb cnt=motion type=line axis=tf 
feature ,, hilite {NAME=PK,TYPE=DATA|VLINE,COLOR=WHITE,ENABLE=0,X=sr/8,DX=sr/10} plot1

plot/id=plot2 _waveb cnt=click axis=bf 

plot/id=rplot ^{datDir}.apenny.prm axis=frame type=cont

gcontrol label  macro "MACRO" AlwaysOpen
gcontrol button state "" "Run,Pause,Stop"  1 /lh=40
gcontrol label  wavef "Waveform" 
gcontrol choice shape "WaveShape" reg.waveform.shapeList sin
gcontrol dval   sfreq "SineFreq " ,, -1e5 1e5 1e3 /fmt="#0.0# ?Hz" /mon=reg.waveform.freq /slider
gcontrol dval   cfreq "CentFreq " 0 0 1e9 1e3
gcontrol dval   filtw "FilterBW " 1e4 0 1e6 1e4 /fmt="0.0 ?Hz"
gcontrol label  geola "GeoPlotter" Closed
gcontrol choice view  "ViewPoint" reg.gplot.viewList "Geo"
gcontrol choice feat  "Feature  " "New,Move,Clear" /tleft
gcontrol label  demo  "Demodulator" 
gcontrol button dmod  "" reg.demod.modeList "FM" /nc=4
gcontrol label  audm  "Audio Mixer" Open
gcontrol lval   gain  "Gain  " 5 0 10 1 /slider /nonumb
gcontrol lval   low   "Low   " 5 0 10 1 /slider /nonumb
gcontrol lval   mid   "Mid   " 5 0 10 1 /slider /nonumb
gcontrol lval   high  "High  " 5 0 10 1 /slider /nonumb
gcontrol label  auds  "Audio Spectra" 
gcontrol panel  apan  "Spectra" 200 100
gcontrol button pop   "" "Pop" 0 /nostate/nodepress
gcontrol label  other "Other" 
gcontrol prompt comm  "Comment" "All Java" 
gcontrol lval   "CPU" "CPU Use" 0 0 100 1 /gauge
gcontrol pipemon pmon _waveb

plot/id=apan/nopushpop _waved{fs=512} type=line axis=frame 
set this.timer(0) 2

if /server gt 0 then rmif/http /server _waveb

pipe run
pipe wait
pipe off

endmacro

!****************************************************************************!
! This is the callback procedure that is automatically called by NeXtMidas
! when there is a (targeted or automatic) message (msg) to send to this macro.
! See the Users's Guide ->Macros ->Messages in Macros section for more details
procedure processMessage m:msg

!say "Msg ^msg.name = ^msg.data from ^msg.fid"

if msg.fid eqs "PANEL"
  if msg.name eqs "STATE"
    pipe ^msg.data
  elseif msg.name eqs "VIEW"
    set reg.gplot.view msg.data
  elseif msg.name eqs "FEAT"
    if msg.data eqs "NEW"
      set l:nfeat reg.gplot.mp.features.getsize+1
      feature ,, ff {NAME=F^nfeat,TYPE=4,X=10,Y=20,DX=2,DY=2,COLOR=red} gplot
    endif
  elseif msg.name eqs "SHAPE"
    set reg.waveform.shape msg.data
  elseif msg.name eqs "DMOD"
    set reg.demod.mode msg.data
  elseif msg.name eqs "WINDOW" then
    if msg.data eqs "CLOSING" pipe stop
  elseif msg.name eqs "POP" then
    if msg.data eqs "POP" then
      message send apan ,, "POP" -1 "TOGGLE"
      set gc.pop.items "Push"
    else
      message send apan ,, "POP" -1 "TOGGLE"
      set gc.pop.items "Pop"
    endif
  endif

elseif msg.fid eqss "PLOT" then
  set fid msg.fid
  if msg.fid eqs "PLOT1"
    set toid "PLOT2"
  else
    set toid "PLOT1"
  endif
  if msg.name eqs "MARK" or msg.name eqs "POINTER" then
    if msg.fid eqs "PLOT2"
      set hilite.x msg.data.x
      set hilite.enable 0x1
    endif
    set reg.waveform.freq msg.data.x
  elseif msg.name eqs "ZOOM" then
    set msg.name "ZOOMX"
    message pass ^toid msg
  elseif msg.name eqs "UNZOOM" then
    message pass ^toid msg
  elseif msg.name eqs "PANXY" then
    pause 0.2
    message prune ,, msg
    set msg.name "PANX"
    message pass ^toid msg
  elseif msg.name eqs "PANX" then
    message pass ^toid msg
  endif

else
  ! say "Unhandled message ^msg.name from ^msg.fid"
endif
return

!******************************************************************************!
! This is the callback procedure that is automatically called by NeXtMidas
! when there is an uncaught exception thrown from commands in this macro
procedure processException m:emsg
  if emsg.data instanceof java.awt.HeadlessException
    if /server gt 0 and /headless isTrue then
      ! ignore exception since BOTH /headless and /server=<port> was specified  
    else ! otherwise stop pipe section and hence the macro 
      warn "No display server! Got error from ^emsg.fid. Stopping macro..."
      pipe stop
    endif
  else 
    warn "Unexpected exception: from ^emsg.fid ^emsg data=^emsg.data"
    if "Trace" SUBS ENV.DEBUG then invoke ,, emsg.data.printStackTrace()
  endif
return

!******************************************************************************!
! Set the dat directory
!******************************************************************************!
procedure setDatDir
  invoke nxmMajor env.nmversion.subString(0,1)
  invoke major java.lang.Integer.valueOf(nxmMajor)
  if major GE 4 then
    invoke s:datDir           nxm.sys.test.DatLocator.getDatDirLocation()
    invoke s:datDirSlash      nxm.sys.test.DatLocator.getDatDirSlashLocation()
    invoke z:sysDatFull       nxm.sys.test.DatLocator.sysDatFull()
    invoke z:sysTestDatExists nxm.sys.test.DatLocator.sysTestDatExists()
  else
    set s:datDir           "nxm.sys.dat"
    set s:datDirSlash      "nxm/sys/dat"
    set z:sysDatFull       true
    set z:sysTestDatExists false
  endif
return
