/************
 *  cdefs.h
 *
 *  Description :  Things C should have but doesn't
 *  Author:	   CLI  6/94
 *
 *  Version:  $Id: cdefs.h,v 1.8 2010/12/07 16:40:35 ntn Exp $
 *
 */

/************************ PORTABILITY ISSUES *************************/

#ifndef _cdefs_h

#if vaxc
#define signed
#endif

#include <limits.h>

/* Type definitions */
#if !__cplusplus
typedef unsigned int	bool;
#endif

typedef signed char     int_1;
typedef short           int_2;
typedef unsigned char   int_u1;
typedef unsigned short  int_u2;

#if _OSF|_SGI|__LP64__
typedef int             int_4;
typedef long            int_8;
typedef unsigned int    int_u4;
typedef unsigned long   int_u8;
#elif _WIN
#ifndef __int64
#define __int64 long long
#endif
typedef int                int_4;
typedef __int64            int_8;
typedef unsigned int       int_u4;
typedef unsigned __int64   int_u8;
#else
/** all other platforms (i.e. Linux, Solaris, etc.) */
typedef int                int_4;
typedef long long          int_8;
typedef unsigned int       int_u4;
typedef unsigned long long int_u8;
#endif

typedef int_u1  bool_1;
typedef int_u2  bool_2;
typedef int_u4  bool_4;

typedef float   real_4;
typedef double  real_8;
typedef char *  pointer;


#if vaxc
typedef struct {
  int_u2 length;
  char dtype,class;
  char *c;
} VAXstring;
#endif

#if !__cplusplus
typedef struct {
  float re;
  float im;
} complex_8;

typedef struct {
  double re;
  double im;
} complex_16;
#endif

/* Constants */

/*
 * We expect that the values for TRUE and FALSE below are portable.
 * That is, interpreted correctly by FORTRAN and C on all platforms.
 */
#ifndef TRUE
#  define	TRUE	1
#endif
#ifndef FALSE
#  define	FALSE	0
#endif

#define MAXINT_4	(int_4)INT_MAX
#define MININT_4	(int_4)INT_MIN
#define MAXINT_U4	(int_u4)UINT_MAX
#define MAXINT_2	(int_2)SHRT_MAX
#define MININT_2	(int_2)SHRT_MIN
#define MAXINT_U2	(int_u2)USHRT_MAX

#define MAX_BOUNDARY	sizeof(double)

/* Return Status */
#if _VMS
#  include <ssdef.h>
#  define EXIT_NORMAL SS$_NORMAL
#  define EXIT_ERROR  SS$_ABORT
#else
#  define EXIT_NORMAL 0
#  define EXIT_ERROR  1
#endif

/* Macros */

#ifndef MIN
#define MIN(x,y)	(((x)<(y))? (x):(y))
#endif
#ifndef MAX
#define MAX(x,y)	(((x)>(y))? (x):(y))
#endif

#define streq(s, t)	(strcmp(s, t) == 0)
#define strneq(s, t, n)	(strncmp(s, t, n) == 0)


/*
   Routines
   These are here just to get around the problem that macros have, in that
   their arguments may be evaluated more than once.
*/
/* RDA: 5-Mar-99  DUnix def'd min/max in Xlibint.h.  Undef if set */
#ifdef min
#undef min
#endif
#ifdef max
#undef max
#endif

static	int	min(const int x, const int y) { return MIN(x, y); }
static	int	max(const int x, const int y) { return MAX(x, y); }

/* NTN: New for C/C++ Primitives support
 * Create a macro that expands to 'extern "C"' for C-interface routines in
 * C++, but expands to 'extern' for C
 */
#ifdef __cplusplus
#define XM_EXTERNC extern "C"
#else
#define XM_EXTERNC extern
#endif

#define _cdefs_h
#endif
