/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class timeslicer
extends Primitive {
    private DataFile hi;
    private Data data_in;
    private DataFile ho;
    private Data data_out;
    private int frameSize;
    private double frameStart;
    private double frameTimeLength;
    private double binTimeLength;
    private int bName = -1;
    private int bAmp = -1;
    private int bTime = -1;
    private String fName = null;
    private int num_subrec;
    private int recLength;

    @Override
    public int open() {
        double xStart;
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        int iName = this.hi.findRec("NAME");
        int iAmp = this.hi.findRec("AMP");
        int iTime = this.hi.findRec("EVENT_TIME");
        this.bName = iName >= 0 ? (int)this.hi.getCompOffset(iName) : -1;
        this.bAmp = iAmp >= 0 ? (int)this.hi.getCompOffset(iAmp) : -1;
        this.bTime = iTime >= 0 ? (int)this.hi.getCompOffset(iTime) : -1;
        this.fName = this.hi.getCompFormat(iName);
        this.frameStart = xStart = this.hi.getXStart();
        this.frameSize = this.MA.getI("FS");
        this.frameTimeLength = this.MA.getI("TIME_PER_FRAME");
        this.binTimeLength = this.frameTimeLength / (double)this.frameSize;
        this.data_in = new Data("SB", this.recLength);
        this.recLength = this.hi.getRecLength();
        this.num_subrec = this.hi.getSubSize();
        this.data_out = new Data("SD", this.frameSize);
        this.ho = this.MA.getDataFile("OUT", "2000", "SD", 0);
        this.ho.setSubSize(this.frameSize);
        this.ho.setXStart(xStart);
        this.ho.setXDelta(this.binTimeLength);
        this.ho.setXUnits(1);
        this.ho.setYStart(xStart);
        this.ho.setYDelta(this.frameTimeLength);
        this.ho.setYUnits(1);
        this.ho.setInternals();
        this.ho.open(2);
        this.data_in = new Data("SB", this.recLength);
        double old_size = this.hi.size;
        this.hi.setFormat("SB");
        this.hi.setType(1000);
        this.hi.setFS(0);
        this.hi.setSize(old_size * (double)this.recLength);
        return 0;
    }

    @Override
    public int process() {
        int n = this.hi.read(this.data_in, this.recLength);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        int len = Data.getBPA(this.fName);
        String name = this.data_in.unpackS(this.bName, len);
        double amp = this.data_in.unpackD(this.bAmp);
        double time = this.data_in.unpackD(this.bTime);
        if (time > this.frameStart + this.frameTimeLength) {
            this.ho.write(this.data_out);
            this.data_out = new Data("SD", this.frameSize);
            this.frameStart += this.frameTimeLength;
            while (time > this.frameStart + this.frameTimeLength) {
                this.ho.write(this.data_out);
                this.frameStart += this.frameTimeLength;
            }
        }
        int bin = (int)((time - this.frameStart) / this.binTimeLength);
        double currentValue = this.data_out.getD((bin = Math.min(this.frameSize, bin)) * this.data_out.getAPE());
        if (amp > currentValue) {
            this.data_out.setD(bin * this.data_out.getAPE(), amp);
        }
        return 0;
    }

    @Override
    public int close() {
        if (this.hi.getSize() > 0.0) {
            this.ho.write(this.data_out);
        }
        this.hi.close();
        this.ho.close();
        return 0;
    }
}

