/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.util.List;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

@ProvisionalUseOnly(value="This was created to create educational and test data and has not been fully tested")
public class table2blue10002000
extends Primitive {
    private int throttle;
    private double delta;
    private double tstart;
    private String form;
    private DataFile hcb;
    private Data data;
    private List<Double> tabData;
    public static final String throttleList = "RealTime,Full,Block";
    private static final int REALTIME = 1;
    private static final int FULL = 2;
    private static final int BLOCK = 3;

    @Override
    public int open() {
        Table configTable = this.MA.getTable("IN");
        String type = configTable.getS("TYPE", "1000");
        String format = configTable.getS("FORMAT", "SD");
        String xUnits = configTable.getS("XUNITS", "NONE");
        double xStart = configTable.getD("XSTART", 0.0);
        double xDelta = configTable.getD("XDELTA", 1.0);
        this.tabData = configTable.getList("DATA", null);
        this.hcb = this.MA.getDataFile("OUT", type, format, 0);
        this.hcb.setXStart(xStart);
        this.hcb.setXDelta(xDelta);
        this.hcb.setXUnits(xUnits);
        if (this.hcb.getType() == 2000) {
            int frameSz = configTable.getL("FRAMESIZE", 1);
            String yUnits = configTable.getS("YUNITS", "NONE");
            double yStart = configTable.getD("YSTART", 0.0);
            double yDelta = configTable.getD("YDELTA", 1.0);
            this.hcb.setFrameSize(frameSz);
            this.hcb.setYUnits(yUnits);
            this.hcb.setYStart(yStart);
            this.hcb.setYDelta(yDelta);
        }
        double size = 0.0;
        switch (this.hcb.getType()) {
            case 1000: {
                size = this.tabData.size() / this.hcb.getSPA();
                break;
            }
            case 2000: {
                size = this.tabData.size() / (this.hcb.getSPA() * this.hcb.getFrameSize());
                break;
            }
            default: {
                throw new MidasException("Type " + this.hcb.getType() + " is not supported");
            }
        }
        this.hcb.setSize(size);
        this.hcb.open(2);
        this.throttle = this.MA.getState("/RT") ? 1 : 2;
        this.throttle = this.MA.getChoice("/THROTTLE", throttleList, this.throttle);
        if (this.throttle == 1) {
            this.hcb.setTimeAt(Time.current());
        }
        this.xfer = this.MA.getL("/TL", 4096);
        this.data = this.hcb.getDataBuffer(this.xfer, (byte)68);
        this.todo(size);
        return 0;
    }

    @Override
    public int process() {
        int ndo;
        if (this.throttle > 0) {
            if (this.throttle == 1) {
                if (this.tstart == 0.0) {
                    this.tstart = Time.current() - this.hcb.seek() * this.delta;
                }
                if (Time.current() < this.tstart + this.hcb.seek() * this.delta) {
                    return -1;
                }
            } else {
                this.tstart = 0.0;
            }
            if (this.throttle == 3) {
                return -1;
            }
        }
        if ((ndo = this.todo()) == 0) {
            return 9;
        }
        int i = 0;
        double[] dbuf = this.data.castD(false);
        for (double value : this.tabData) {
            dbuf[i++] = value;
        }
        this.data.uncast(dbuf, true);
        this.hcb.write(this.data, ndo);
        return 0;
    }

    @Override
    public int close() {
        this.hcb.close();
        return 0;
    }

    @Override
    public int restart() {
        this.hcb.close();
        this.hcb = this.MA.getDataFile("OUT", this.hcb, 0);
        this.hcb.setFormat(this.form);
        this.hcb.setSize(this.todo);
        this.hcb.open();
        this.data = this.hcb.getDataBuffer(this.xfer, (byte)70);
        this.tstart = 0.0;
        return 0;
    }

    @Override
    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        return this.hcb.processReady(this.xfer);
    }

    public void setThrottle(String value) {
        this.throttle = Parser.find(throttleList, value, this.throttle, 0, 1);
    }

    public void setFormat(String format) {
        if (this.form.equals(format)) {
            return;
        }
        this.form = format;
        this.setState(7);
    }

    public String getThrottle() {
        return Parser.get(throttleList, this.throttle);
    }

    public String getFormat() {
        return this.MA.getS("FORM");
    }
}

