/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.lib.TimeLine;

public class addjitter
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data data;
    private double jitter;
    private double delta;
    private double tolr;
    private boolean randomJitter;
    private long count;

    @Override
    public int open() {
        this.inFile = this.MA.getDataFile("IN");
        this.inFile.open(1);
        this.delta = this.inFile.getDelta();
        this.tolr = this.inFile.getTimeLineTolerance();
        this.outFile = this.MA.getDataFile("OUT", this.inFile, 0);
        this.outFile.setDefaultQualifier("TYPE", this.inFile.getType());
        this.outFile.open(2);
        this.xfer = this.outFile.getType() % 1000 == 1 ? Math.max(1, (int)((double)this.bufSize / this.inFile.getBPE())) : 1;
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.jitter = this.MA.getD("JITTER", 0.0);
        this.randomJitter = this.MA.getZ("/RANDOM");
        this.count = 0L;
        this.data = this.inFile.getDataBuffer(this.xfer);
        if (this.jitter > this.delta && this.randomJitter) {
            this.M.warning("Random jitter mode with max jitter (" + this.jitter + ") greater than delta (" + this.delta + ") may result in back-in-time timeline entries");
        }
        return 0;
    }

    @Override
    public int process() {
        double jitterMultiplier = this.randomJitter ? Math.random() * 2.0 - 1.0 : 0.01 * (double)(this.count % 100L);
        double dt = jitterMultiplier * this.jitter;
        Time t0 = this.inFile.getTimeAtCurrent();
        Time t1 = t0.addSec(dt);
        int n = this.inFile.read(this.data);
        ++this.count;
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        this.outFile.setTimeAt(t1, TimeLine.NotifyInvalidEntry.WARNING);
        this.outFile.write(this.data, n);
        return 0;
    }

    @Override
    public int close() {
        if (this.inFile != null) {
            this.inFile.close();
        }
        if (this.outFile != null) {
            this.outFile.close();
        }
        return 0;
    }
}

