/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Waveform;

public final class waveform
extends Primitive {
    private int shape;
    private int throttle;
    private int lrs = 1;
    private int cur = 0;
    private double size;
    private double amp;
    private double freq;
    private double poff;
    private double phase;
    private double chirp;
    private double mean;
    private double var;
    private double sdev;
    private double a2s;
    private double start;
    private double delta;
    private double tstart;
    private boolean dble;
    private boolean exact;
    private String form;
    private DataFile hcb;
    private Data data;
    public static final String shapeList = "Sine,Cosine,Square,Triangle,SawTooth,Pulse,Constant,Zero,White,LRS,Ramp";
    private static final int SIN = 1;
    private static final int COS = 2;
    private static final int SQU = 3;
    private static final int TRI = 4;
    private static final int SAW = 5;
    private static final int PUL = 6;
    private static final int CON = 7;
    private static final int ZER = 8;
    private static final int WHI = 9;
    private static final int LRS = 10;
    private static final int RAM = 11;
    public static final String throttleList = "RealTime,Full,Block";
    private static final int REALTIME = 1;
    private static final int FULL = 2;
    private static final int BLOCK = 3;

    @Override
    public int open() {
        this.shape = this.MA.getChoice("SHAPE", shapeList, 0);
        this.form = this.MA.getFormat("FORM", "S#,C#");
        this.freq = this.MA.getD("FREQ");
        this.amp = this.MA.getD("AMP");
        this.poff = this.MA.getD("PHASE");
        this.size = this.MA.getD("ELEM");
        this.chirp = this.MA.getD("CHIRP", 0.0);
        this.mean = this.MA.getD("MEAN", 0.0);
        this.var = this.MA.getD("VARIANCE", Math.pow(this.amp / 2.3025850929940455, 2.0));
        this.sdev = this.MA.getD("SDEV", Math.sqrt(this.var));
        this.start = this.MA.getD("START");
        this.delta = this.MA.getD("DELTA");
        this.hcb = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.parseRFargs();
        this.hcb.setFormat(this.form);
        this.hcb.setXStart(this.start);
        this.hcb.setXDelta(this.delta);
        this.hcb.setXUnits(1);
        this.hcb.setSize(this.size);
        this.hcb.open(2);
        this.throttle = this.MA.getState("/RT") ? 1 : 2;
        this.throttle = this.MA.getChoice("/THROTTLE", throttleList, this.throttle);
        if (this.throttle == 1) {
            this.hcb.setTimeAt(Time.current());
        }
        this.dble = this.MA.getState("/DP", this.hcb.getFormatType() == 68);
        this.exact = this.MA.getState("/EXACT");
        this.xfer = this.MA.getL("/TL", 4096);
        this.data = this.hcb.getDataBuffer(this.xfer, this.dble ? (byte)68 : 70);
        this.a2s = this.sdev / this.amp;
        this.todo(this.size);
        Waveform.setSeed(this.MA.getL("/SEED", -1));
        return 0;
    }

    @Override
    public int process() {
        int mode;
        int ndo;
        if (this.throttle > 0) {
            if (this.throttle == 1) {
                if (this.tstart == 0.0) {
                    this.tstart = Time.current() - this.hcb.seek() * this.delta;
                }
                if (Time.current() < this.tstart + this.hcb.seek() * this.delta) {
                    return -1;
                }
            } else {
                this.tstart = 0.0;
            }
            if (this.throttle == 3) {
                return -1;
            }
        }
        if ((ndo = this.todo()) == 0) {
            return 9;
        }
        double p = this.phase + this.poff;
        double dp = this.freq * this.delta;
        if (this.poff != 0.0) {
            p -= Math.floor(p);
        }
        if (dp < 0.0 && this.shape != 1) {
            dp = -dp;
        }
        int n = mode = this.exact && (this.shape == 1 || this.shape == 2) ? -this.hcb.spa : this.hcb.spa;
        if (this.dble) {
            double[] dbuf = this.data.castD(false);
            switch (this.shape) {
                case 1: {
                    Waveform.sincos(dbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 2: {
                    Waveform.sincos(dbuf, this.amp, p + 0.25, dp, ndo, mode);
                    break;
                }
                case 3: {
                    Waveform.square(dbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 4: {
                    Waveform.triangle(dbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 5: {
                    Waveform.sawtooth(dbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 6: {
                    Waveform.pulse(dbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 7: {
                    Waveform.constant(dbuf, this.amp, ndo, mode);
                    break;
                }
                case 8: {
                    Waveform.constant(dbuf, 0.0, ndo, mode);
                    break;
                }
                case 9: {
                    Waveform.whitenoise(dbuf, this.sdev, ndo, mode);
                    break;
                }
                case 10: {
                    this.lrs = Waveform.lrs(dbuf, this.amp, ndo, mode, this.lrs);
                    break;
                }
                case 11: {
                    this.cur = Waveform.ramp(dbuf, this.amp, ndo, mode, this.cur);
                }
            }
            if (this.mean != 0.0) {
                int i = 0;
                while (i < ndo * this.hcb.spa) {
                    int n2 = i++;
                    dbuf[n2] = dbuf[n2] + this.mean;
                }
            }
            this.data.uncast(dbuf, true);
        } else {
            float fmean = (float)this.mean;
            float[] fbuf = this.data.castF(false);
            switch (this.shape) {
                case 1: {
                    Waveform.sincos(fbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 2: {
                    Waveform.sincos(fbuf, this.amp, p + 0.25, dp, ndo, mode);
                    break;
                }
                case 3: {
                    Waveform.square(fbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 4: {
                    Waveform.triangle(fbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 5: {
                    Waveform.sawtooth(fbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 6: {
                    Waveform.pulse(fbuf, this.amp, p, dp, ndo, mode);
                    break;
                }
                case 7: {
                    Waveform.constant(fbuf, this.amp, ndo, mode);
                    break;
                }
                case 8: {
                    Waveform.constant(fbuf, 0.0, ndo, mode);
                    break;
                }
                case 9: {
                    Waveform.whitenoise(fbuf, this.sdev, ndo, mode);
                    break;
                }
                case 10: {
                    this.lrs = Waveform.lrs(fbuf, this.amp, ndo, mode, this.lrs);
                    break;
                }
                case 11: {
                    this.cur = Waveform.ramp(fbuf, this.amp, ndo, mode, this.cur);
                }
            }
            if (fmean != 0.0f) {
                int i = 0;
                while (i < ndo * this.hcb.spa) {
                    int n3 = i++;
                    fbuf[n3] = fbuf[n3] + fmean;
                }
            }
            this.data.uncast(fbuf, true);
        }
        this.hcb.write(this.data, ndo);
        this.phase += dp * (double)ndo;
        this.phase -= Math.floor(this.phase);
        if (this.chirp != 0.0) {
            this.freq += this.chirp * this.delta * (double)ndo;
        }
        return 0;
    }

    @Override
    public int close() {
        this.hcb.close();
        return 0;
    }

    @Override
    public int restart() {
        this.hcb.close();
        this.hcb = this.MA.getDataFile("OUT", this.hcb, 0);
        this.hcb.setFormat(this.form);
        this.hcb.setSize(this.todo);
        this.hcb.open();
        this.data = this.hcb.getDataBuffer(this.xfer, (byte)70);
        this.tstart = 0.0;
        return 0;
    }

    @Override
    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        return this.hcb.processReady(this.xfer);
    }

    public void setShape(String value) {
        this.shape = Parser.find(shapeList, value, this.shape, 0, 1);
    }

    public void setMean(double value) {
        this.mean = value;
    }

    public void setSDev(double value) {
        this.sdev = value;
    }

    public void setVariance(double value) {
        this.sdev = Math.sqrt(value);
    }

    public void setAmplitude(double value) {
        this.amp = value;
        this.sdev = this.amp * this.a2s;
    }

    public void setFrequency(double value) {
        this.freq = value;
    }

    public void setChirp(double value) {
        this.chirp = value;
    }

    public void setPhase(double value) {
        this.phase = value;
    }

    public void setThrottle(String value) {
        this.throttle = Parser.find(throttleList, value, this.throttle, 0, 1);
    }

    public void setFormat(String format) {
        if (this.form.equals(format)) {
            return;
        }
        this.form = format;
        this.setState(7);
    }

    public String getShape() {
        return Parser.get(shapeList, this.shape);
    }

    public double getMean() {
        return this.mean;
    }

    public double getSDev() {
        return this.sdev;
    }

    public double getVariance() {
        return this.sdev * this.sdev;
    }

    public double getAmplitude() {
        return this.amp;
    }

    public double getFrequency() {
        return this.freq;
    }

    public double getChirp() {
        return this.chirp;
    }

    public double getPhase() {
        return this.phase;
    }

    public String getThrottle() {
        return Parser.get(throttleList, this.throttle);
    }

    public String getFormat() {
        return this.MA.getS("FORM");
    }

    private void parseRFargs() {
        boolean cx;
        Double rf = this.MA.getD("RF", null);
        Double vrf = this.MA.getD("VRF", null);
        Double bw = this.MA.getD("BW", null);
        Double sr = this.MA.getD("SR", null);
        Double dur = this.MA.getD("DURATION", null);
        if (rf != null) {
            if (vrf == null) {
                throw new MidasException("Can not use RF=" + rf + " without VRF=");
            }
            if (bw == null) {
                throw new MidasException("Can not use RF=" + rf + " without BW=");
            }
        }
        boolean bl = cx = Data.getSPA(this.form.charAt(0)) == 2;
        if (sr != null) {
            this.delta = 1.0 / sr;
        }
        if (bw != null) {
            double d = this.delta = cx ? 1.0 / bw : 0.5 / bw;
        }
        if (rf != null) {
            double d = this.freq = cx ? rf - vrf : rf - vrf + bw / 2.0;
        }
        if (dur != null) {
            this.size = Math.ceil(dur / this.delta);
        }
        if (vrf != null) {
            this.hcb.getKeywordsObject().put("D:VRF", vrf);
        }
    }
}

