/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JScrollPane;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GValue;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJTextArea;
import nxm.sys.libg.MWindow;

public class textdisplay
extends GPrimitive {
    private MJTextArea mjta;
    private JScrollPane scrollPane;
    private int exitMask = -1;
    private static final int EXIT_MENU = 1;
    public static String exitFlagsList = "Menu";
    private String scrollString = "NONE";

    @Override
    public int open() {
        String title = this.MA.getS("/TITLE", "NeXtMidas TextBox");
        Object input = null;
        input = this.MA.getO("TEXT", null);
        String initialText = "" + input;
        if (input instanceof Table) {
            initialText = textdisplay.convertTableToText((Table)input, null, 0);
        }
        int rows = this.MA.getL("/ROWS", 20);
        int cols = this.MA.getL("/COLS", 80);
        boolean editAble = this.MA.getState("/EDIT", false);
        this.exitMask = this.MA.getOptionMask("/EXIT", exitFlagsList, this.exitMask);
        this.scrollString = this.MA.getS("/SCROLL", this.scrollString);
        this.MW = new MWindow(title, this);
        this.MW.open();
        this.MW.setTheme(this.MA.getO("/THEME"));
        this.MW.addTo(this);
        this.setupTextArea(initialText, rows, cols, editAble);
        this.resize();
        return 0;
    }

    @Override
    public int process() {
        return -1;
    }

    @Override
    public int close() {
        this.MW.close();
        this.MW = null;
        this.mjta = null;
        return 9;
    }

    @Override
    public int processMessage(Message msg) {
        if (this.MW.processMessage(msg) <= 0) {
            if (msg.name.equals("RESIZE")) {
                this.resize();
            } else {
                if (msg.name.equals("EXIT")) {
                    return 9;
                }
                if (msg.name.equals("TITLE")) {
                    this.MW.setTitle((String)msg.data);
                } else if (msg.name.startsWith("APPEND") || msg.name.equals("TEXT")) {
                    String text = "";
                    text = msg.data instanceof Table ? textdisplay.convertTableToText((Table)msg.data, null, 0) : (String)msg.data;
                    if (msg.name.equalsIgnoreCase("APPEND")) {
                        this.mjta.append(text);
                    } else {
                        this.mjta.appendLine(text);
                    }
                } else if (msg.name.equals("CLEAR")) {
                    this.mjta.setText("");
                } else if (msg.name.equals("REPLACE")) {
                    String text = "";
                    text = msg.data instanceof Table ? textdisplay.convertTableToText((Table)msg.data, null, 0) : (String)msg.data;
                    this.mjta.setText(text);
                } else if (msg.name.equals("MENU")) {
                    String menu = this.isEditAble() ? "Rows,Cols,Cut,Copy,Paste" : "Rows,Cols,Copy";
                    if ((this.exitMask & 1) != 0) {
                        menu = menu + ",Exit";
                    }
                    new GMenu(this.MW, "TextBox", menu, 0, 0, this);
                } else if (msg.name.equals("TEXTBOX")) {
                    if (msg.data.equals("ROWS")) {
                        int rows = this.getRows();
                        new GValue((Object)this.MW, "Rows", rows, 1, 1000, 1, 0, (MessageHandler)this);
                    } else if (msg.data.equals("COLS")) {
                        int cols = this.getCols();
                        new GValue((Object)this.MW, "Cols", cols, 1, 1000, 1, 0, (MessageHandler)this);
                    } else if (msg.data.equals("CUT")) {
                        try {
                            if (this.isEditAble()) {
                                StringSelection data = new StringSelection(this.getSelectedText());
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(data, data);
                                String text = this.getText();
                                this.setText(text.substring(0, this.getSelectionStart()) + text.substring(this.getSelectionEnd(), text.length()));
                            }
                        }
                        catch (Exception data) {}
                    } else if (msg.data.equals("COPY")) {
                        try {
                            StringSelection data = new StringSelection(this.getSelectedText());
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(data, data);
                        }
                        catch (Exception data) {}
                    } else if (msg.data.equals("PASTE")) {
                        try {
                            Clipboard clipboard;
                            Transferable data;
                            if (this.isEditAble() && (data = (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(null)) != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                this.insert(data.getTransferData(DataFlavor.stringFlavor).toString(), this.getCaretPosition());
                            }
                        }
                        catch (Exception exception) {}
                    } else if (msg.data.equals("EXIT")) {
                        msg.name = "EXIT";
                        if ((this.exitMask & 1) != 0) {
                            this.MQ.put(msg);
                        }
                    } else {
                        this.M.warning("Unhandled menu choice " + msg.data);
                    }
                } else if (msg.name.equals("ROWS")) {
                    this.mjta.setRows(Convert.o2l(msg.data));
                    this.MW.setSize(this.mjta.getWidth(), this.mjta.getHeight());
                } else if (msg.name.equals("COLS")) {
                    this.mjta.setRows(Convert.o2l(msg.data));
                    this.MW.setSize(this.mjta.getWidth(), this.mjta.getHeight());
                } else if (msg.name.equals("REFRESH")) {
                    this.MW.refresh();
                } else if (!msg.name.equals("POINTER") && !msg.name.equals("SHOWN") && !msg.name.equals("MOVED") && !msg.name.equals("FOCUS") && msg.name.equals("WINDOW") && msg.data.toString().equals("CLOSING")) {
                    msg.name = "EXIT";
                    this.MQ.put(msg);
                }
            }
        }
        return 0;
    }

    public static String convertTableToText(Table table, String tableAsText, int level) {
        if (tableAsText == null) {
            tableAsText = "";
        }
        Table.Iterator ti = table.iterator();
        while (ti.getNext()) {
            Object result;
            String key = ti.key;
            if (key == null || (result = ti.value) == null) continue;
            if (result instanceof Table) {
                tableAsText = textdisplay.convertTableToText((Table)result, tableAsText, level + 1);
                continue;
            }
            String pad = "";
            for (int i = 0; i < level; ++i) {
                pad = "  " + pad;
            }
            tableAsText = tableAsText + pad + key + " = " + result + "\n";
        }
        return tableAsText;
    }

    public void resize() {
        if (this.mjta != null) {
            this.mjta.setSize(this.MW.pos.w, this.MW.pos.h);
        }
        if (this.scrollPane != null) {
            this.scrollPane.setBounds(this.mjta.getBounds());
        }
    }

    private void setupTextArea(String initialText, int rows, int cols, boolean editAble) {
        this.mjta = new MJTextArea(initialText, rows, cols);
        this.mjta.setEditable(editAble);
        this.mjta.setMessageHandler(this.MW.mh);
        this.mjta.setAttributes(this.MW.panel);
        if (this.scrollString.equals("NONE")) {
            this.MW.panel.add(this.mjta);
        } else {
            this.scrollPane = new JScrollPane(this.mjta);
            if (this.scrollString.indexOf(72) > -1) {
                this.scrollPane.setHorizontalScrollBarPolicy(30);
                this.mjta.setLineWrap(false);
            }
            if (this.scrollString.indexOf(86) > -1) {
                this.scrollPane.setVerticalScrollBarPolicy(20);
            }
            this.resize();
            this.MW.panel.add(this.scrollPane);
        }
        this.mjta.addKeyListener(this.MW);
        this.mjta.addMouseListener(this.MW);
    }

    private boolean isEditAble() {
        return this.mjta.isEditable();
    }

    private int getRows() {
        return this.mjta.getHeight() / this.mjta.getFont().getSize();
    }

    private int getCols() {
        return this.mjta.getWidth() / this.mjta.getFont().getSize();
    }

    private String getText() {
        return this.mjta.getText();
    }

    private String getSelectedText() {
        return this.mjta.getSelectedText();
    }

    private int getSelectionStart() {
        return this.mjta.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.mjta.getSelectionEnd();
    }

    private void setText(String text) {
        this.mjta.setText(text);
    }

    private void insert(String text, int position) {
        this.mjta.insert(text, position);
    }

    private int getCaretPosition() {
        return this.mjta.getCaretPosition();
    }

    public void setSelectedTextColor(String color) {
        this.setSelectedTextColor(MColor.getColor(color));
    }

    public void setSelectedTextColor(Color c) {
        this.mjta.setSelectedTextColor(c);
    }

    public String getSelectedTextColorString() {
        return MColor.toString(this.getSelectedTextColor());
    }

    public Color getSelectedTextColor() {
        return this.mjta.getSelectedTextColor();
    }

    public void setSelectionColor(String c) {
        this.mjta.setSelectionColor(MColor.getColor(c));
    }

    public void setSelectionColor(Color c) {
        this.mjta.setSelectionColor(c);
    }

    public String getSelectionColorString() {
        return MColor.toString(this.mjta.getSelectionColor());
    }

    public Color getSelectionColor() {
        return this.mjta.getSelectionColor();
    }
}

