/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class split
extends Primitive {
    private DataFile hi;
    private Data data_in;
    private DataFile[] ho;
    private Data[] data_out;
    private String[] formats;
    private String[] names;
    private int[] lengths;
    private int[] offsets;
    private int[] out_types;
    private String root;
    private int num_subrec;
    private int elts;
    private int recLength;
    private int last;
    private double dp_elts;

    @Override
    public int open() {
        this.root = this.MA.getS("ROOT");
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.recLength = this.hi.getRecLength();
        this.num_subrec = this.hi.getSubSize();
        this.ho = new DataFile[this.num_subrec];
        this.data_out = new Data[this.num_subrec];
        this.formats = new String[this.num_subrec];
        this.names = new String[this.num_subrec];
        this.lengths = new int[this.num_subrec];
        this.offsets = new int[this.num_subrec];
        this.out_types = new int[this.num_subrec];
        for (int i = 0; i < this.num_subrec; ++i) {
            this.formats[i] = this.hi.getRecFormat(i);
            this.names[i] = this.hi.getRecName(i);
            this.offsets[i] = this.hi.getRecOffset(i);
            this.lengths[i] = i + 1 < this.num_subrec ? this.hi.getRecOffset(i + 1) - this.offsets[i] : this.recLength - this.offsets[i];
            this.dp_elts = this.lengths[i] / Data.getBPA(this.formats[i]);
            this.elts = (int)Math.rint(this.dp_elts);
            if (Math.abs((double)this.elts - this.dp_elts) > 1.0E-6) {
                this.M.warning("Invalid length for subrecord " + i);
            }
            this.out_types[i] = this.elts == 1 ? 1000 : 2000;
            this.ho[i] = new DataFile();
            this.last = this.names[i].indexOf(" ");
            if (this.last < 0) {
                this.last = this.names[i].length();
            }
            String name = this.root + this.names[i].substring(0, this.last);
            this.ho[i].init(this.M, (Object)name.toLowerCase());
            this.ho[i].setType(1000);
            this.ho[i].setFormat("SB");
            this.ho[i].setXStart(0.0);
            this.ho[i].setXDelta(1.0);
            this.ho[i].open(2);
            this.data_out[i] = new Data("SB", this.lengths[i]);
        }
        this.data_in = new Data("SB", this.recLength);
        double old_size = this.hi.size;
        this.hi.setFormat("SB");
        this.hi.setType(1000);
        this.hi.setFS(0);
        this.hi.setSize(old_size * (double)this.recLength);
        return 0;
    }

    @Override
    public int process() {
        int n = this.hi.read(this.data_in, this.recLength);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        int offset = 0;
        for (int i = 0; i < this.num_subrec; ++i) {
            offset = this.offsets[i];
            for (int j = 0; j < this.lengths[i]; ++j) {
                this.data_out[i].buf[j] = this.data_in.buf[j + offset];
            }
            this.ho[i].write(this.data_out[i], this.lengths[i]);
        }
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        for (int i = 0; i < this.num_subrec; ++i) {
            double old_size = this.ho[i].seek();
            this.ho[i].close();
            double new_size = old_size / (double)this.lengths[i];
            this.ho[i].open(3);
            this.ho[i].setType(this.out_types[i]);
            if (this.out_types[i] == 2000) {
                this.ho[i].setSubSize(this.lengths[i] / Data.getBPA(this.formats[i]));
            }
            this.ho[i].setFormat(this.formats[i]);
            this.ho[i].setSize(new_size);
            this.ho[i].update();
            this.ho[i].close();
        }
        return 0;
    }
}

