/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.SDDSPacket;
import nxm.sys.lib.Time;
import nxm.sys.lib.UdpResource;

public class sinksdds
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data data;
    private SDDSPacket pkho;
    private SDDSPacket pkh;
    private boolean rt;
    private boolean wrap;
    private boolean swap;
    private boolean inputIsSDDS;
    private double tdelta;
    private double tstart;
    private Time time;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "SN,SB,SI", 0);
        this.hi.open();
        this.pkh = new SDDSPacket();
        this.pkh.setFormat(this.hi.getFormat());
        this.pkho = (SDDSPacket)this.hi.getPacketHandler();
        this.inputIsSDDS = this.pkho != null;
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        if (this.inputIsSDDS) {
            this.pkh = this.pkho;
        } else {
            this.ho.setPacketHandler(this.pkh);
        }
        this.ho.open();
        if (this.ho.io instanceof UdpResource) {
            this.pkh.setUDP(false);
        }
        this.wrap = this.MA.getState("/WRAP");
        this.rt = this.MA.getState("/RT");
        this.xfer = (int)(1024.0 / this.hi.dbpe);
        this.data = this.hi.getDataBuffer(this.xfer);
        this.swap = this.data.bps == 2 && !Convert.isBigEndian(this.data.rep);
        this.tdelta = this.hi.getDelta();
        this.tstart = 0.0;
        this.time = this.hi.getTime();
        if (this.time.getWSec() == 0.0) {
            this.time.fromCurrent();
        }
        if (this.rt && this.tdelta >= 0.1) {
            this.M.warning("Realtime with dt>0.1 ?");
        }
        return 0;
    }

    @Override
    public int process() {
        int n;
        if (this.rt) {
            if (this.tstart == 0.0 && this.hi.avail() < (double)this.xfer) {
                return -1;
            }
            if (this.tstart == 0.0) {
                this.tstart = Time.current();
            }
            if (Time.current() < this.tstart + this.ho.seek() * this.tdelta) {
                return -1;
            }
        }
        if ((n = this.hi.read(this.data)) > 0) {
            if (this.swap) {
                Convert.swap2(this.data.buf, 0, n);
            }
            if (n < this.xfer) {
                this.M.warning("Partial packet of " + n + " elements not output");
            } else if (this.inputIsSDDS) {
                this.ho.write(this.data);
            } else {
                this.pkh.setTC(0, this.tdelta, this.time.getWSec(), this.time.getFSec());
                this.ho.write(this.data);
                this.pkh.upCount();
                this.time.addSec((double)this.xfer * this.tdelta);
            }
        } else {
            if (n == 0) {
                return -1;
            }
            if (this.wrap && (this.hi.isFile() || this.hi.isJarFile())) {
                this.hi.seek(0.0);
            } else {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }
}

