/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.net.dgnetsend;

@Deprecated
public class sinkdg
extends Primitive {
    private TextFile logfile;
    private dgnetsend dgsend = null;
    private static final int defaultport = 18800;
    private static final int defaulttimeout = 5000;
    private static final int defaultttl = 1;
    private static final int defaultrtp = 0;
    private static final int PLEN = 2048;
    private byte[] inbuf = null;
    private DataFile hin = null;
    private short ptype = (short)97;
    private int ssrc = 1;
    private int blen;
    private int csrc0 = 0;
    private double freq = 0.0;
    private double bw = 0.0;
    private String host = null;
    private String hinformat = null;
    private int tl;
    private int port = 18800;
    private int timeOut = 5000;
    private int ttl = 1;
    private int rtp = 0;
    private boolean verbose = false;
    private boolean packetDebug = false;
    private boolean keepopen = true;
    private boolean opened = false;
    private boolean popened = false;
    private boolean rtptime = false;
    private boolean icein = false;
    private boolean outputPackets = true;

    @Override
    public void setVerbose(boolean ptemp) {
        this.verbose = ptemp;
    }

    public void setRTPType(int rtptype) {
        this.ptype = (short)rtptype;
    }

    public void setRTPSSRC(int pssrc) {
        this.ssrc = pssrc;
    }

    public void setRTPCSRC(int pcsrc) {
        this.csrc0 = pcsrc;
    }

    public void setSocketDebug(boolean ptemp) {
        if (this.dgsend != null) {
            try {
                this.dgsend.setVerbose(ptemp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setPacketDebug(boolean ptemp) {
        this.packetDebug = ptemp;
        if (this.dgsend != null) {
            try {
                this.dgsend.setPacketDebug(ptemp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setPTypeSSRC(int pptype, int pssrc) {
        this.ptype = (short)pptype;
        this.ssrc = pssrc;
    }

    public void setPTypeSRCs(int pptype, int pssrc, int pcsrc) {
        this.ptype = (short)pptype;
        this.ssrc = pssrc;
        this.csrc0 = pcsrc;
    }

    public void setTimeOut(int ptimeout) {
    }

    public void setTTL(int pttl) {
        this.ttl = pttl;
        if (this.dgsend != null) {
            try {
                this.dgsend.setTTL(this.ttl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        return "DG: Host=" + this.host + " Port=" + this.port;
    }

    public void setKeepOpen(boolean pkeep) {
        this.keepopen = pkeep;
        if (this.dgsend != null) {
            try {
                this.dgsend.setKeepOpen(pkeep);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setHost(String phost) {
        this.host = phost;
        if (this.dgsend != null) {
            try {
                this.dgsend.setHost(phost);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int pport) {
        this.port = pport;
        if (this.dgsend != null) {
            try {
                this.dgsend.setPort(pport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setHostPort(String phost, int pport) {
        this.host = phost;
        this.port = pport;
        if (this.dgsend != null) {
            try {
                this.dgsend.setHost(this.host);
                this.dgsend.setPort(this.port);
                if (!this.opened) {
                    this.open();
                }
            }
            catch (Exception e) {
                this.M.printStackTrace(e);
            }
        } else {
            this.M.info("sinkdg: class not created ");
        }
    }

    public dgnetsend getDgnetsend() {
        return this.dgsend;
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4 for debugging purposes only")
    public dgnetsend getDgsend() {
        return this.dgsend;
    }

    public void setOutputPackets(boolean val) {
        this.outputPackets = val;
    }

    public boolean getOutputPackets() {
        return this.outputPackets;
    }

    @Override
    public int open() {
        try {
            if (this.dgsend == null) {
                int i;
                this.dgsend = new dgnetsend();
                if (this.dgsend == null) {
                    this.M.error("sinkdg: Could not open socket");
                    return 9;
                }
                if (this.MA.find("/VERBOSE")) {
                    this.verbose = true;
                }
                if (this.MA.find("/PACKETS")) {
                    this.packetDebug = true;
                }
                this.timeOut = this.MA.getL("/TIMEOUT", 5000);
                if (this.MA.find("/KEEPOPEN")) {
                    this.keepopen = true;
                }
                this.ttl = this.MA.getL("/TTL", 1);
                this.rtp = this.MA.getL("/RTP", 0);
                this.rtptime = this.MA.getState("/RTPTIME", this.rtptime);
                this.icein = this.MA.getState("/ICEIN", this.icein);
                this.ptype = this.MA.getI("/PTYPE", this.ptype);
                this.ssrc = this.MA.getL("/SSRC", this.ssrc);
                this.csrc0 = this.MA.getL("/CSRC", this.csrc0);
                this.tl = this.MA.getL("/TL", 2048);
                String hostport = this.MA.getS("/HOSTPORT", "");
                if (this.MA.find("/LOG")) {
                    this.logfile = this.MA.getTextFile("/LOG");
                    if (!this.logfile.open(34)) {
                        this.logfile.writeln("sinkdg log started at " + Time.tag());
                    } else {
                        this.M.warning("Could not find URL=" + this.logfile.getURL());
                        this.logfile = null;
                    }
                }
                this.setVerbose(this.verbose);
                this.setPacketDebug(this.packetDebug);
                this.setTTL(this.ttl);
                if (this.verbose) {
                    this.M.info("sinkdg: Verbose=" + this.verbose + ". PacketDebug=" + this.packetDebug + ". Keepopen=" + this.keepopen);
                    this.M.info("sinkdg: TTL=" + this.ttl);
                }
                if (this.keepopen && this.host == null && (i = hostport.indexOf(58)) > 0) {
                    this.host = hostport.substring(0, i).toLowerCase();
                    this.port = Integer.parseInt(hostport.substring(i + 1));
                    this.M.info("sinkdg: HOSTPORT=" + hostport);
                }
            }
            this.hin = this.MA.getDataFile("IN", "1000,2000", "", 0);
            this.popened = false;
            if (this.hin == null) {
                this.M.info("Invalid Input File - 1000,2000 only");
            }
            this.hinformat = this.hin.getFormat();
            if (this.verbose && this.host != null) {
                this.M.info("sinkdg: HOST,PORT=" + this.host + "," + this.port);
            }
            if (this.host != null && this.hin != null && !this.popened) {
                String fname = this.MA.getS("IN");
                if (fname.length() > 0) {
                    this.M.info("Opening hin " + fname + "," + this.hin.isOpen() + " for " + this.host);
                    this.hin.open();
                    this.hinformat = this.hin.getFormat();
                    this.popened = true;
                    this.inbuf = new byte[this.tl];
                    this.keepopen = true;
                } else {
                    this.M.info("sinkdg Invalid Input File");
                    this.hin.close();
                    this.hin = null;
                }
            }
            if (this.keepopen) {
                if (this.host != null) {
                    this.dgsend.open(this.host, this.port);
                    this.opened = true;
                    if (this.verbose) {
                        this.M.info("sinkdg: Host=" + this.host + ". Port=" + this.port);
                    }
                } else {
                    this.M.info("sinkdg: host is null");
                }
            } else if (this.host != null) {
                this.dgsend.open();
                this.opened = true;
                if (this.verbose) {
                    this.M.info("sinkdg: Host=" + this.host + ". Port=" + this.port);
                }
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: open failed", e);
        }
        return 0;
    }

    @Override
    public int close() {
        try {
            if (this.logfile != null) {
                this.logfile.writeln("sinkdg log stopped at " + Time.tag());
                this.logfile.close();
            }
            if (this.hin != null) {
                this.hin.close();
            }
            if (this.dgsend != null) {
                this.dgsend.close();
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: close failed", e);
        }
        return 0;
    }

    public int send(byte[] buf) {
        try {
            if (this.verbose) {
                this.M.info("senddg: send(byte[] buf) Packet data=" + new String(buf));
            }
            if (buf == null || this.dgsend == null) {
                return -1;
            }
            boolean sent = this.dgsend.write(buf);
            if (!sent) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: send failed", e);
        }
        return 1;
    }

    public int send(String data) {
        try {
            if (this.verbose) {
                this.M.info("senddg: send(String data) Packet data=" + data);
            }
            if (data == null || this.dgsend == null) {
                return -1;
            }
            byte[] buf = data.getBytes();
            boolean sent = this.dgsend.write(buf);
            if (!sent) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: send failed", e);
        }
        return 1;
    }

    public int send(String host, String port, String data) {
        try {
            if (this.verbose) {
                this.M.info("senddg: send(host,port,data)->Packet data=" + data);
            }
            if (host == null || data == null || this.dgsend == null) {
                return -1;
            }
            int iPort = Integer.parseInt(port);
            if (iPort < 0 || iPort > 65535) {
                return -1;
            }
            boolean sent = this.dgsend.write(host, iPort, data);
            if (!sent) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: send failed", e);
        }
        return 1;
    }

    public int sendRTP(byte[] buf, int bsize) {
        try {
            if (this.verbose) {
                this.M.info("senddg: send(byte[] buf) Packet data=" + new String(buf));
            }
            if (buf == null || this.dgsend == null) {
                return -1;
            }
            boolean sent = this.dgsend.writeRTP(buf, bsize, this.ptype, this.ssrc, 0, this.csrc0);
            if (!sent) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: sendRTP failed", e);
        }
        return 1;
    }

    public int sendRTP(String data) {
        try {
            if (this.verbose) {
                this.M.info("senddg: send(String data) Packet data=" + data);
            }
            if (data == null || this.dgsend == null) {
                return -1;
            }
            byte[] buf = data.getBytes();
            boolean sent = this.dgsend.writeRTP(buf, buf.length, this.ptype, this.ssrc, 0, this.csrc0);
            if (!sent) {
                return 0;
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: sendRTP failed", e);
        }
        return 1;
    }

    @Override
    public int process() {
        if (this.inbuf == null) {
            return -1;
        }
        this.blen = this.hin.read(this.inbuf, 0, this.tl);
        if (this.blen == 0) {
            return -1;
        }
        if (this.blen < 0) {
            return 9;
        }
        if (!this.outputPackets) {
            return 0;
        }
        if (this.rtp > 0) {
            if (this.rtptime) {
                if (this.icein) {
                    this.dgsend.writeRTPICE(this.inbuf, this.blen, this.ptype, this.ssrc, this.csrc0);
                } else {
                    this.dgsend.writeRTPICE(this.inbuf, this.blen, this.hinformat, Time.current(), this.freq, this.bw, this.ptype, this.ssrc, 0, this.csrc0);
                }
            } else if (this.icein) {
                this.dgsend.writeRTP(this.inbuf, this.blen - 64, this.ptype, this.ssrc, 64, this.csrc0);
            } else {
                this.dgsend.writeRTP(this.inbuf, this.blen, this.ptype, this.ssrc, 0, this.csrc0);
            }
        } else {
            this.dgsend.write(this.inbuf);
        }
        return 0;
    }

    @Override
    public synchronized int processMessage(Message msg) {
        try {
            if (this.verbose) {
                this.M.info("sinkdg: Processing a message: " + msg.name);
            }
            if (msg.name.equals("OPENNET")) {
                if (this.keepopen) {
                    String hostport = (String)msg.data;
                    int i = hostport.indexOf(58);
                    if (i > 0) {
                        this.host = hostport.substring(0, i).toLowerCase();
                        this.port = Integer.parseInt(hostport.substring(i + 1));
                        this.dgsend.open(this.host, this.port);
                        if (this.verbose) {
                            this.M.info("sinkdg: Host=" + this.host + ". Port=" + this.port);
                        }
                    } else {
                        this.M.error("sinkdg: open failed: host:port wrong" + this.host + ":" + this.port + ". hostport=" + hostport);
                    }
                } else {
                    this.dgsend.open();
                }
            } else if (!msg.name.equals("SENDNET")) {
                if (msg.name.equals("CLOSENET")) {
                    this.dgsend.close();
                } else if (msg.name.equals("EXITNET")) {
                    this.dgsend.close();
                    return 9;
                }
            }
        }
        catch (Exception e) {
            throw new MidasException("sinkdg: processMessage failed", e);
        }
        return 0;
    }

    public int getSSRC() {
        return this.ssrc;
    }
}

