/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.net.HDisplay;
import nxm.sys.net.HMessage;
import nxm.sys.net.HQuery;
import nxm.sys.net.HServer;
import nxm.sys.net.Rmif;
import nxm.sys.net.RmifSM;

public class rmif
extends Primitive
implements Chainable {
    protected Rmif rmif;
    protected HServer http;
    protected TextFile logfile;
    private boolean stateBasedMsgHandlingIsDefault;
    private boolean killForTestingOnly = false;

    @Override
    public int open() {
        String item;
        String host;
        boolean reOpen;
        int prange;
        int port;
        block16: {
            String dev;
            port = this.MA.getL("PORT");
            prange = this.MA.getL("/PRANGE", 1);
            reOpen = this.MA.getState("/REOPEN", true);
            host = this.MA.getS("/HOST", "");
            if (this.verbose && !"".equals(host)) {
                this.M.info("HOST SWITCH: " + host);
            }
            if (!"".equals(dev = this.MA.getS("/DEVICE", ""))) {
                if (this.verbose) {
                    this.M.info("DEVICE SWITCH: " + dev);
                }
                try {
                    NetworkInterface nintf = NetworkInterface.getByName(dev);
                    if (nintf != null) {
                        Enumeration<InetAddress> e = nintf.getInetAddresses();
                        while (e.hasMoreElements()) {
                            InetAddress ia = e.nextElement();
                            if (!(ia instanceof Inet4Address)) continue;
                            host = ia.getHostAddress();
                            break block16;
                        }
                        break block16;
                    }
                    this.M.warning("Network device [" + dev + "] could not be resolved.");
                }
                catch (SocketException se) {
                    this.M.printStackTrace("Unable to get network device to bind on for /DEVICE=" + dev, se);
                }
            }
        }
        this.stateBasedMsgHandlingIsDefault = this.MA.getState("/STATEM", false);
        this.openRmifConnection(this.getMessageHandler(), host, port, prange);
        if (this.MA.find("/LOG")) {
            this.openLogFile(this.MA.getTextFile("/LOG"));
        }
        this.initRmifConnection(reOpen, this.MA.getTable("/PPT"));
        this.rmif.addProperty("Q:SET");
        this.rmif.addProperty("Q:GET");
        this.rmif.addProperty("Q:RET");
        this.rmif.addProperty("Q:ACK");
        String tmp = this.MA.getS("PROPS");
        while (tmp.length() > 0) {
            int i = tmp.indexOf(124);
            if (i < 0) {
                item = tmp;
                tmp = "";
            } else {
                item = tmp.substring(0, i);
                tmp = tmp.substring(i + 1);
            }
            this.rmif.addProperty(item);
        }
        int ir = 1;
        while (ir * 2 < this.MA.nargs) {
            tmp = this.MA.getS(ir * 2 + 1);
            Rmif.Remote r = this.rmif.openRemote(Convert.o2t(tmp));
            tmp = this.MA.getS(ir * 2 + 2);
            while (tmp.length() > 0) {
                int i = tmp.indexOf(124);
                if (i < 0) {
                    item = tmp;
                    tmp = "";
                } else {
                    item = tmp.substring(0, i);
                    tmp = tmp.substring(i + 1);
                }
                this.rmif.addChannel(r, -1, item);
            }
            ++ir;
        }
        if (this.MA.getState("/HTTP")) {
            this.openHttpServer("RMIF Web Server", this.MA.getCS("/HOMEPAGE"), this.MA.getS("/AUXLIST"));
        }
        return 0;
    }

    @Override
    public int process() {
        int stat = 0;
        stat += this.rmif.checkRemotes();
        if ((stat += this.rmif.serveProperties()) == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int close() {
        if (this.http != null) {
            this.http.stopThread();
        }
        if (this.rmif != null) {
            if (this.killForTestingOnly) {
                this.rmif.hardKillForTestingOnly();
            } else {
                this.rmif.close();
            }
        }
        if (this.logfile != null) {
            this.logfile.writeln("RMIF log stopped at " + Time.tag());
            this.logfile.close();
        }
        return 0;
    }

    protected void openRmifConnection(MessageHandler handler, int port, int prange) {
        this.openRmifConnection(handler, "0.0.0.0", port, prange);
    }

    protected void openRmifConnection(MessageHandler handler, String host, int port, int prange) {
        this.rmif = this.stateBasedMsgHandlingIsDefault ? new RmifSM(this.M, this, handler) : new Rmif(this.M, this, handler);
        this.rmif.open(host, port, prange);
    }

    private Rmif useJeremy2019Version() {
        this.M.info("TEMPORARY OPTION IS ENABLED: Using pure Jeremy 2019 Rmif code");
        return null;
    }

    protected void openLogFile(TextFile log) {
        this.logfile = log;
        if (this.logfile.open(50)) {
            this.logfile.writeln("RMIF log started at " + Time.tag());
            this.rmif.setLogFile(this.logfile);
        } else {
            this.M.warning("Could not open log at URL=" + this.logfile.getURL());
        }
    }

    protected void initRmifConnection(boolean reOpen, Table ppt) {
        this.rmif.setVerbose(this.verbose);
        this.rmif.setReOpen(reOpen);
        if (ppt != null) {
            KeyObject.setKeys(this.rmif, ppt);
        }
    }

    protected void openHttpServer(String title, String homepage, String auxlist) {
        if (auxlist == null) {
            auxlist = "";
        }
        this.http = HServer.launch(this, title, this.rmif.getPort(), homepage, auxlist);
        this.http.addSource(new HDisplay("Display", this.M));
        this.http.addSource(new HMessage("Message", this.M));
    }

    public int getPartners() {
        return this.MA.getL("/PARTNERS", 0);
    }

    public HServer getServer() {
        return this.http;
    }

    @Override
    public synchronized int processMessage(Message msg) {
        if (!this.thisIsMe()) {
            this.MQ.put(msg);
            return 0;
        }
        Rmif.Remote r = null;
        int flags = 0;
        Object quals = msg.getQuals();
        if (quals instanceof Table) {
            String protocol = ((Table)quals).getS("PROTOCOL");
            flags = Parser.find("RDP,UDP,TCP,IDP", protocol, 0, -1);
        }
        if (msg.to instanceof Rmif.Remote) {
            r = (Rmif.Remote)msg.to;
        } else if (msg.to instanceof Rmif.RemoteAddress) {
            r = this.rmif.getRemoteForAddress((Rmif.RemoteAddress)msg.to);
        }
        if (this.verbose) {
            this.M.info("Processing msg: " + msg.name);
        }
        if (msg.name.startsWith("ADDR")) {
            r = this.rmif.addRemote(Convert.o2t(msg.data));
        } else if (msg.name.equals("OPEN")) {
            r = this.rmif.openRemote(Convert.o2t(msg.data));
            if (this.http != null) {
                this.http.addSource(new HQuery(r.getTag(), r, null, 64));
            }
        } else if (msg.name.startsWith("ADDC")) {
            int cflags = 0;
            if (msg.name.indexOf("/M") > 0) {
                cflags = 1;
            }
            this.rmif.addChannel(r, msg.info, msg.data.toString(), cflags);
        } else if (msg.name.startsWith("DELC")) {
            if (msg.info > 0) {
                this.rmif.closeChannel(msg.info);
            } else {
                this.rmif.closeChannel(msg.data.toString());
            }
        } else if (msg.name.equals("RADDR")) {
            if (msg.data != null) {
                r = this.rmif.getRemote(Convert.o2t(msg.data));
            }
            this.rmif.removeRemote(r);
            if (this.http != null) {
                this.http.removeSource(r.getTag());
            }
        } else if (msg.name.startsWith("CLOSE")) {
            this.rmif.closeRemote(r);
            if (msg.name.indexOf("/R") > 0) {
                this.rmif.removeRemote(r);
            }
            if (this.http != null) {
                this.http.removeSource(r.getTag());
            }
        } else if (msg.name.equals("SET")) {
            while (r != null) {
                this.rmif.sendPacket((byte)101, msg.info, Convert.o2ba(msg.data), r, flags);
                r = r.next;
            }
        } else if (msg.name.equals("GET")) {
            while (r != null) {
                this.rmif.sendPacket((byte)102, msg.info, Convert.o2ba(msg.data), r, flags);
                r = r.next;
            }
        } else if (msg.name.equals("RET")) {
            if (r == null) {
                this.rmif.servePacket((byte)103, msg.info, Convert.o2ba(msg.data), flags);
            } else {
                this.rmif.sendPacket((byte)103, msg.info, Convert.o2ba(msg.data), r, flags);
            }
        } else if (msg.name.equals("ACK")) {
            if (r == null) {
                this.rmif.servePacket((byte)104, msg.info, Convert.o2ba(msg.data), flags);
            } else {
                this.rmif.sendPacket((byte)104, msg.info, Convert.o2ba(msg.data), r, flags);
            }
        } else if (msg.name.equals("KEYS") || msg.name.equals("PROPS")) {
            this.rmif.sendPacket((byte)121, msg.info, r, flags);
        } else if (msg.name.equals("PING")) {
            this.rmif.sendPacket((byte)109, 0, r, flags);
        } else if (msg.name.equals("MODIFY")) {
            while (r != null) {
                this.rmif.sendPacket((byte)114, msg.info, Convert.o2ba(msg.data), r, flags);
                r = r.next;
            }
        } else if (msg.name.equals("TESTLINK")) {
            this.rmif.testLink(r, msg.info);
        } else {
            if (msg.name.equals("EXIT")) {
                return 9;
            }
            if (msg.name.equals("KILL_FOR_TESTING_ONLY")) {
                this.M.warning("RMIF: '" + this.getID() + "' killed by " + msg.from);
                this.killForTestingOnly = true;
                return 9;
            }
        }
        return 0;
    }

    public KeyVector getRemotes() {
        return this.rmif.getRemotes();
    }

    public KeyVector getProps() {
        return this.rmif.getProperties();
    }

    public KeyVector getChans() {
        return this.rmif.getChannels();
    }

    @Override
    public Object getNextLink() {
        return this.rmif;
    }

    @Override
    public Object getPrevLink() {
        return null;
    }

    public Rmif getRmif() {
        return this.rmif;
    }

    @Override
    public synchronized void setMessageHandler(MessageHandler mh) {
        super.setMessageHandler(mh);
        if (this.rmif != null) {
            this.rmif.setMessageHandler(mh);
        }
    }
}

