/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.MMath;
import nxm.sys.libm.Subtract;

public class polyfit
extends Primitive {
    DataFile hi;
    DataFile ho;
    DataFile hf;
    DataFile he;
    Data dbi;
    Data dbo;
    Data dbf;
    Data dbe;
    int order;
    int ndata;
    String label;
    double xs;
    double xd;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000,2000", "S#", 0);
        this.hi.open();
        this.xs = this.hi.getXStart();
        this.xd = this.hi.getXDelta();
        this.order = this.MA.getL("ORDER");
        this.label = this.MA.getU("COEF");
        this.ho = this.MA.getDataFile("OUT", "2000", "SD", 0);
        this.ho.setSubSize(this.order + 1);
        this.ho.setInternals();
        this.ho.open(66);
        this.hf = this.MA.getDataFile("FIT", this.hi, 0);
        this.hf.open(66);
        this.he = this.MA.getDataFile("ERR", this.hi, 0);
        this.he.open(66);
        if (this.hi.typeClass == 1) {
            this.ndata = (int)this.hi.getSize();
            this.hi.setDFS(this.ndata);
            this.hf.setDFS(this.ndata);
            this.he.setDFS(this.ndata);
        } else {
            this.ndata = this.hi.getSubSize();
        }
        this.dbi = this.hi.getDataBuffer(1, (byte)68);
        this.dbo = this.ho.getDataBuffer(1, (byte)68);
        this.dbf = this.hf.getDataBuffer(1, (byte)68);
        this.dbe = this.he.getDataBuffer(1, (byte)68);
        return 0;
    }

    @Override
    public int process() {
        int n = this.hi.read(this.dbi);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        double[] vi = this.dbi.castD(true);
        double[] vo = this.dbo.castD(false);
        double[] vf = this.dbf.castD(false);
        double[] ve = this.dbe.castD(false);
        MMath.leastSquaresFit(vo, this.order, vi, this.ndata, 0, this.ndata);
        MMath.leastSquaresEval(vo, this.order, vf, this.ndata);
        MMath.deNormalizeCoef(vo, this.order, this.xs, this.xd, this.ndata);
        Subtract.SSS(vi, vf, ve, this.ndata);
        this.dbi.uncast(vi, false);
        this.dbo.uncast(vo, true);
        this.ho.write(this.dbo);
        this.dbf.uncast(vf, true);
        this.hf.write(this.dbf);
        this.dbe.uncast(ve, true);
        this.he.write(this.dbe);
        return 0;
    }

    @Override
    public int close() {
        if (!(this.ho.isOpen || this.hf.isOpen || this.he.isOpen || this.label.length() != 0)) {
            this.M.info("Coef = " + this.dbo);
        }
        this.MR.put(this.label, (Object)this.dbo);
        this.hi.close();
        this.ho.close();
        this.hf.close();
        this.he.close();
        return 0;
    }
}

