/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;

public class mux
extends Primitive {
    private DataFile hc;
    private DataFile hr;
    private DataFile hi;
    private Data dc;
    private Data dr;
    private Data di;
    private double constant;
    private int mode;
    public static String modeList = "RI,RR,II,IR";
    private static int mRI = 1;
    private static int mRR = 2;
    private static int mII = 3;
    private static int mIR = 4;

    @Override
    public int open() {
        this.mode = this.MA.getSelectionIndex("/MODE", modeList, mRI);
        this.hr = this.MA.getDataFile("REAL", "1000", "S#", 0);
        this.hr.open();
        this.hi = this.MA.getDataFile("IMAG", "1000", "S#", 0);
        if (!this.MA.getState("/CONST")) {
            this.hi.open();
        }
        byte dtype = this.hr.getFormatType();
        if (this.hi.isOpen) {
            if (this.hr.getXDelta() != this.hi.getXDelta()) {
                this.M.error("File xdeltas do not match");
            }
            if (this.hr.getXUnits() != this.hi.getXUnits()) {
                this.M.error("File xunits do not match");
            }
            dtype = Data.promoteType(dtype, this.hi.getFormatType());
        }
        this.hc = this.MA.getDataFile("COMP", this.hr, 0);
        this.hc.setFormatMode((byte)67);
        this.hc.setFormatType(dtype);
        this.hc.open(2);
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hc.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.dr = this.hr.getDataBuffer(this.xfer, dtype);
        this.dc = this.hc.getDataBuffer(this.xfer, dtype);
        if (this.hi.isOpen) {
            this.di = this.hi.getDataBuffer(this.xfer, dtype);
        } else {
            this.setConstant(this.MA.getD("IMAG"));
        }
        return 0;
    }

    @Override
    public int process() {
        int ni;
        int nr = this.hr.read(this.dr);
        if (nr == 0) {
            return -1;
        }
        if (nr < 0) {
            return 9;
        }
        int n = ni = this.hi.isOpen ? this.hi.read(this.di) : nr;
        if (ni == 0) {
            return -1;
        }
        if (ni < 0) {
            return 9;
        }
        int n2 = Math.min(nr, ni);
        if (this.hr.isOpen) {
            if (this.mode == mRI || this.mode == mRR) {
                DataOp.copy(this.dr, 0, this.dr.bpe, this.dc, 0 * this.dc.bps, this.dc.bpe, this.dr.bpe, n2);
            }
            if (this.mode == mIR || this.mode == mRR) {
                DataOp.copy(this.dr, 0, this.dr.bpe, this.dc, 1 * this.dc.bps, this.dc.bpe, this.dr.bpe, n2);
            }
        }
        if (this.hi.isOpen) {
            if (this.mode == mRI || this.mode == mII) {
                DataOp.copy(this.di, 0, this.di.bpe, this.dc, 1 * this.dc.bps, this.dc.bpe, this.di.bpe, n2);
            }
            if (this.mode == mIR || this.mode == mII) {
                DataOp.copy(this.di, 0, this.di.bpe, this.dc, 0 * this.dc.bps, this.dc.bpe, this.di.bpe, n2);
            }
        }
        this.hc.write(this.dc, n2);
        return 0;
    }

    @Override
    public int close() {
        this.hr.close();
        this.hi.close();
        this.hc.close();
        return 0;
    }

    public void setConstant(double value) {
        this.constant = value;
        DataOp.fill(this.dc, 0, value, this.xfer);
    }

    public double getConstant() {
        return this.constant;
    }

    public void setMode(String smode) {
        this.mode = Parser.find(modeList, smode, this.mode);
    }
}

