/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.MWindow;

public class messagelog
extends GPrimitive {
    private Logger logfile;
    private LogButton IBut;
    private LogButton WBut;
    private LogButton EBut;
    private Label LogLabel;
    private Panel LogPane;
    private CardLayout CL;
    private ColorListBox[] CLB = new ColorListBox[8];
    private Color BGC;
    private Color FGC;
    private Color ERRColor = Color.red;
    private Color WRNColor = Color.yellow;
    private Color INFColor = Color.white;

    @Override
    public int open() {
        if (this.MA.find("/FILE")) {
            this.logfile = this.MA.getState("/BUFFER", true) ? new Logger(true) : new Logger(false);
            this.logfile.open(this.MA.getFileName("/FILE"));
            this.logfile.writeln("Message log started at " + Time.tag());
        }
        String title = this.MA.getS("/TITLE", "NeXt Midas Message Log");
        this.MW = new MWindow(title, this);
        this.MW.open();
        this.MW.setSize(400, 200);
        this.MW.addTo(this);
        this.MW.setTheme(this.MA.getO("/THEME"));
        this.BGC = this.MW.panel.getBackground();
        this.FGC = this.MW.panel.getForeground();
        this.EBut = new LogButton("ERRORS ON", "ERRORS OFF", this.ERRColor, this.FGC, this);
        this.EBut.Value = 1;
        this.WBut = new LogButton("WARNINGS ON", "WARNINGS OFF", this.WRNColor, this.FGC, this);
        this.WBut.Value = 2;
        this.IBut = new LogButton("INFO ON", "INFO OFF", this.INFColor, this.FGC, this);
        this.IBut.Value = 4;
        this.EBut.addTo(this.MW);
        this.WBut.addTo(this.MW);
        this.IBut.addTo(this.MW);
        this.EBut.toggleOn();
        this.WBut.toggleOn();
        this.IBut.toggleOn();
        this.CL = new CardLayout();
        this.LogPane = new Panel();
        this.LogPane.setLayout(this.CL);
        for (int i = 0; i < 8; ++i) {
            this.CLB[i] = new ColorListBox(null, this.BGC, this.FGC);
            this.CLB[i].setTrim(true);
            this.CLB[i].setTrimSize(500);
            this.LogPane.add((Component)this.CLB[i], "" + i);
        }
        this.MW.panel.add(this.LogPane);
        this.CL.show(this.LogPane, "7");
        this.LogLabel = new Label("TYP   DAY        TIME        YEAR  TEXT");
        this.MW.panel.add(this.LogLabel);
        this.resize();
        if (!this.MA.getState("/ERROR", true)) {
            Message m = new Message(new String("BUTTON"), 2, new String("ERR"));
            this.handleButtonMsg(m);
        }
        if (!this.MA.getState("/WARN", true)) {
            Message m = new Message(new String("BUTTON"), 1, new String("WARN"));
            this.handleButtonMsg(m);
        }
        if (!this.MA.getState("/INFO", true)) {
            Message m = new Message(new String("BUTTON"), 0, new String("INFO"));
            this.handleButtonMsg(m);
        }
        return 0;
    }

    @Override
    public int process() {
        return -1;
    }

    @Override
    public int processMessage(Message msg) {
        if (!this.thisIsMe()) {
            this.MQ.put(msg);
        } else if (msg.name.equals("RESIZE")) {
            this.resize();
        } else {
            if (msg.name.equals("EXIT")) {
                return 9;
            }
            if (msg.name.equals("LOG")) {
                this.handleLogMsg(msg);
            } else if (msg.name.equals("LOGSTATUS")) {
                this.handleLogStatusMsg(msg);
            } else if (msg.name.equals("BUTTON") && msg.data != null) {
                this.handleButtonMsg(msg);
            }
        }
        return 0;
    }

    @Override
    public int close() {
        this.MW.close();
        if (this.logfile != null) {
            this.logfile.writeln("Message log stopped at " + Time.tag());
            this.logfile.close();
        }
        return 0;
    }

    public void resize() {
        if (this.LogPane != null && this.EBut != null && this.WBut != null && this.IBut != null) {
            int btWidth = this.MW.pos.w / 3;
            int ComponentHeight = 20;
            int LogWidth = this.MW.pos.w;
            int LogHeight = this.MW.pos.h;
            this.LogLabel.setBounds(0, 0, LogWidth, ComponentHeight);
            this.LogPane.setBounds(0, 22, LogWidth, LogHeight - 28);
            this.EBut.resize(0, LogHeight - 22, btWidth, ComponentHeight);
            this.WBut.resize(btWidth, LogHeight - 22, btWidth, ComponentHeight);
            this.IBut.resize(btWidth * 2, LogHeight - 22, btWidth, ComponentHeight);
            for (int i = 0; i < 8; ++i) {
                this.CLB[i].setBounds(0, 22, LogWidth, LogHeight - 25);
            }
        }
    }

    public Object setKey(String name, Object value) {
        if (name.equals("FONT")) {
            Font font = new Font("monospaced", 0, Convert.o2l(value));
            this.resize();
        } else if (name.equals("FONTH")) {
            Font font = new Font("monospaced", 0, Convert.o2l(value));
            this.resize();
        } else if (name.equals("FONTB")) {
            Font font = new Font("monospaced", 0, Convert.o2l(value));
            this.EBut.setFont(font);
            this.WBut.setFont(font);
            this.IBut.setFont(font);
            this.resize();
        } else if (name.equals("THEME")) {
            this.MW.setTheme((String)value);
            this.M.info("Changing colors: " + this.MW.panel.getBackground());
            this.BGC = this.MW.panel.getBackground();
            this.EBut.setBackground(this.BGC);
            this.WBut.setBackground(this.BGC);
            this.IBut.setBackground(this.BGC);
            this.LogLabel.setBackground(this.BGC);
            this.LogPane.setBackground(this.BGC);
            for (int i = 0; i < 8; ++i) {
                this.CLB[i].setListBackground(this.BGC);
            }
            this.FGC = this.MW.panel.getForeground();
            this.EBut.OffColor = this.FGC;
            this.WBut.OffColor = this.FGC;
            this.IBut.OffColor = this.FGC;
            this.LogLabel.setForeground(this.FGC);
            this.LogPane.paintAll(this.LogPane.getGraphics());
        }
        return value;
    }

    private void handleLogStatusMsg(Message msg) {
        String logName = (String)msg.data;
        if (logName.startsWith("ERR")) {
            int status = msg.info;
            status = status == 0 ? 0 : 1;
            Message m = new Message(new String("BUTTON"), status, new String("ERR"));
            this.handleButtonMsg(m);
        } else if (logName.startsWith("WARN")) {
            int status = msg.info;
            status = status == 0 ? 0 : 2;
            Message m = new Message(new String("BUTTON"), status, new String("WARN"));
            this.handleButtonMsg(m);
        } else {
            int status = msg.info;
            status = status == 0 ? 0 : 4;
            Message m = new Message(new String("BUTTON"), status, new String("INFO"));
            this.handleButtonMsg(m);
        }
    }

    private void handleLogMsg(Message msg) {
        String[] logType = new String[]{"INF", "WRN", "ERR", "UNK"};
        Date thisDay = Calendar.getInstance().getTime();
        Color color = null;
        int colorcode = 8;
        String newline = msg.info > 2 ? "UNK  " + thisDay.toString() + "  " + msg.data : logType[msg.info] + "  " + thisDay.toString() + "  " + msg.data;
        switch (msg.info) {
            case 0: {
                color = this.INFColor;
                colorcode = 4;
                break;
            }
            case 1: {
                color = this.WRNColor;
                colorcode = 2;
                break;
            }
            case 2: {
                color = this.ERRColor;
                colorcode = 1;
            }
        }
        for (int i = 1; i < 8; ++i) {
            if ((i & colorcode) == colorcode) {
                this.CLB[i].addListItem(newline, this.BGC, color);
            }
            this.CLB[i].scrollToBottom();
        }
        if (this.logfile != null) {
            this.logfile.writeln(newline);
        }
    }

    private void handleButtonMsg(Message msg) {
        String btnName = (String)msg.data;
        if (btnName.startsWith("ERR")) {
            this.EBut.toggleState();
            this.EBut.Value = !this.EBut.selected ? 0 : 1;
        } else if (btnName.startsWith("WARN")) {
            this.WBut.toggleState();
            this.WBut.Value = !this.WBut.selected ? 0 : 2;
        } else {
            this.IBut.toggleState();
            this.IBut.Value = !this.IBut.selected ? 0 : 4;
        }
        this.CL.show(this.LogPane, "" + (this.EBut.Value + this.WBut.Value + this.IBut.Value));
    }

    public class ColorListBox
    extends ScrollPane {
        private static final long serialVersionUID = 2012122813331L;
        private Panel P = new Panel();
        private ArrayList<ListItem> SelectedItems;
        private ArrayList<ListItem> ListItems;
        private boolean Selectable;
        private boolean Trim;
        private int TrimSize;
        private byte LIWidth;

        public ColorListBox() {
            this(null);
        }

        public ColorListBox(String[] List2) {
            this(List2, Color.black);
        }

        public ColorListBox(String[] List2, Color FGC) {
            this(List2, Color.white, FGC);
        }

        public ColorListBox(String[] List2, Color BGC, Color FGC) {
            this.P.setBackground(BGC);
            this.P.setLayout(null);
            this.add(this.P);
            this.SelectedItems = new ArrayList(100);
            this.ListItems = new ArrayList(100);
            this.Selectable = true;
            this.Trim = false;
            this.TrimSize = 0;
            this.LIWidth = (byte)14;
            if (List2 != null) {
                for (int i = 0; i < List2.length; ++i) {
                    this.addListItem(List2[i], BGC, FGC);
                }
            }
        }

        public void addListItem(String Text) {
            this.addListItem(Text, Color.black);
        }

        public void addListItem(String Text, Color FGC) {
            this.addListItem(Text, Color.white, FGC);
        }

        public void addListItem(String Text, Color BGC, Color FGC) {
            ListItem item = new ListItem(Text, BGC, FGC);
            this.ListItems.add(item);
            this.drawListItem(item);
        }

        public void addListItem(ListItem Item) {
            this.ListItems.add(Item);
            this.drawListItem(Item);
        }

        public int getNumberOfListItems() {
            return this.ListItems.size();
        }

        public int getNumberOfSelectedItems() {
            return this.SelectedItems.size();
        }

        public ListItem getListItem(int Index2) {
            return this.ListItems.get(Index2);
        }

        public String[] getSelectedItems() {
            String[] rtnstr = new String[this.SelectedItems.size()];
            for (int i = 0; i < this.SelectedItems.size(); ++i) {
                ListItem item = this.SelectedItems.get(i);
                rtnstr[i] = item.getText();
            }
            return rtnstr;
        }

        public void clearSelectedItems() {
            for (int i = 0; i < this.SelectedItems.size(); ++i) {
                ListItem item = this.SelectedItems.get(i);
                item.setBackground(item.BGC);
                item.Selected = false;
            }
            this.SelectedItems.clear();
        }

        public void removeAllItems() {
            this.ListItems.clear();
            this.SelectedItems.clear();
            this.P.removeAll();
        }

        public boolean removeListItem(String Text) {
            boolean foundit = false;
            for (int i = 0; i < this.ListItems.size(); ++i) {
                ListItem item = this.ListItems.get(i);
                if (!Text.equals(item.getText())) continue;
                if (item.Selected) {
                    this.deselectItem(item);
                }
                this.ListItems.remove(i);
                foundit = true;
                break;
            }
            return foundit;
        }

        public void addTo(MWindow MW) {
            Container panel2 = MW.panel;
            Color cb = panel2.getBackground();
            this.setBackground(cb);
            panel2.add(this);
        }

        public void scrollToBottom() {
            Dimension dim = this.getViewportSize();
            int PHeight = this.P.getHeight();
            this.setScrollPosition(0, (int)((double)PHeight - dim.getHeight()));
        }

        public void scrollToTop() {
            this.setScrollPosition(0, 0);
        }

        public void setSelectable(boolean Opt) {
            this.Selectable = Opt;
        }

        public boolean isSelectable() {
            return this.Selectable;
        }

        public void setTrim(boolean Opt) {
            this.Trim = Opt;
        }

        public boolean trimOn() {
            return this.Trim;
        }

        public void setTrimSize(int Size) {
            this.TrimSize = Size;
        }

        public int GetTrimSize() {
            return this.TrimSize;
        }

        public byte getItemWidth() {
            return this.LIWidth;
        }

        public void setItemWidth(byte Width) {
            this.LIWidth = Width;
        }

        public void setListBackground(Color NewColor) {
            this.P.setBackground(NewColor);
        }

        public void setColorListBoxSize(int Width, int Height) {
            this.setSize(Width, Height);
        }

        public void resize(int X, int Y, int Width, int Height) {
            this.setBounds(X, Y, Width, Height);
        }

        private void drawListItem(ListItem Item) {
            if (this.Trim && this.ListItems.size() > this.TrimSize) {
                Color nextColor = Item.getForeground();
                String nextText = Item.getText();
                this.ListItems.remove(this.TrimSize);
                for (int i = this.ListItems.size() - 1; i >= 0; --i) {
                    ListItem toItem = this.ListItems.get(i);
                    Color saveColor = toItem.getForeground();
                    String saveText = toItem.getText();
                    toItem.setForeground(nextColor);
                    toItem.setText(nextText);
                    nextColor = saveColor;
                    nextText = saveText;
                }
                return;
            }
            int Width = this.getWidth();
            int Height = this.ListItems.size() * this.LIWidth;
            this.P.setBounds(0, 0, Width, Height);
            this.P.add(Item);
            Item.setBounds(0, Height - this.LIWidth, Width, this.LIWidth);
            this.paintAll(this.getGraphics());
        }

        private void selectItem(ListItem Item) {
            this.SelectedItems.add(Item);
            Item.setBackground(Color.lightGray);
            Item.Selected = true;
        }

        private void deselectItem(ListItem Item) {
            for (int i = 0; i < this.SelectedItems.size(); ++i) {
                if (!Item.equals(this.SelectedItems.get(i))) continue;
                this.SelectedItems.remove(i);
                break;
            }
            Item.setBackground(Item.BGC);
            Item.Selected = false;
        }

        class ListItem
        extends Label {
            private static final long serialVersionUID = 2012122814331L;
            private boolean Selected;
            private transient ListItemListener Listener;
            private Color BGC;

            ListItem(String Text, Color BGC, Color FGC) {
                super(Text);
                this.setBackground(BGC);
                this.BGC = BGC;
                this.setForeground(FGC);
                this.Listener = new ListItemListener();
                this.addMouseListener(this.Listener);
            }

            private class ListItemListener
            extends MouseAdapter {
                private ListItemListener() {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ColorListBox.this.Selectable) {
                        ListItem theSource = (ListItem)e.getSource();
                        if (!theSource.Selected) {
                            ColorListBox.this.selectItem(theSource);
                        } else {
                            ColorListBox.this.deselectItem(theSource);
                        }
                    }
                }
            }
        }
    }

    public class MButton
    extends Button {
        private static final long serialVersionUID = 2012122812331L;
        public Container panel;
        public String label;
        public transient MessageHandler mh;

        public MButton(String label, MessageHandler mh) {
            super(label);
            this.initialize(label, mh);
        }

        public MButton(String label) {
            this(label, null);
        }

        private void initialize(String label, MessageHandler mh) {
            this.label = label;
            this.mh = mh;
            this.enableEvents(16L);
            this.enableEvents(8L);
        }

        public void addTo(MWindow mw) {
            this.panel = mw.panel;
            Color cb = this.panel.getBackground();
            this.setBackground(cb);
            Color cf = this.panel.getForeground();
            this.setForeground(cf);
            this.panel.add(this);
        }

        public void close() {
            if (this.panel != null) {
                this.panel.remove(this);
            }
        }

        @Override
        public void processEvent(AWTEvent e) {
            if (e.getID() == 502) {
                this.mh.processMessage(new Message("BUTTON", 0, this.label));
            }
            super.processEvent(e);
        }

        public void resize(int x, int y, int w, int h) {
            this.setBounds(x, y, w, h);
        }
    }

    private class Logger {
        private boolean _buffered;
        private boolean _writeable;
        private PrintWriter _writer;

        private Logger(boolean buffer) {
            this._buffered = buffer;
            this._writeable = false;
        }

        public boolean open(FileName name) {
            if (name.getPath() == "") {
                name.setPath(messagelog.this.M.io.getAuxPath("1"));
            }
            try {
                FileWriter fwriter = new FileWriter(name.toString());
                this._writer = this._buffered ? new PrintWriter(new BufferedWriter(fwriter)) : new PrintWriter(fwriter);
                this._writeable = true;
            }
            catch (Exception e) {
                this._writeable = false;
            }
            return true;
        }

        public boolean writeln(String line) {
            if (this._writeable) {
                try {
                    this._writer.write(line + "\n");
                    if (!this._buffered) {
                        this._writer.flush();
                    }
                }
                catch (Exception e) {
                    Shell.printStackTrace(e);
                }
                return true;
            }
            return false;
        }

        public boolean close() {
            if (this._writeable) {
                try {
                    this._writer.flush();
                    this._writer.close();
                }
                catch (Exception e) {
                    Shell.printStackTrace(e);
                }
                return true;
            }
            return false;
        }
    }

    private class LogButton
    extends MButton {
        private static final long serialVersionUID = 2012122811331L;
        private Color OnColor;
        private Color OffColor;
        private String OnText;
        private String OffText;
        private boolean selected;
        private int Value;

        private LogButton(String OnText, String OffText, Color OnColor, Color OffColor, MessageHandler mh) {
            super(OnText, mh);
            this.OnText = OnText;
            this.OffText = OffText;
            this.OnColor = OnColor;
            this.OffColor = OffColor;
            this.toggleOn();
        }

        private void toggleState() {
            if (this.selected) {
                this.toggleOff();
            } else {
                this.toggleOn();
            }
        }

        private void toggleOn() {
            this.setLabel(this.OnText);
            this.setForeground(this.OnColor);
            this.selected = true;
        }

        private void toggleOff() {
            this.setLabel(this.OffText);
            this.setForeground(this.OffColor);
            this.selected = false;
        }
    }
}

