/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;

public class histogram
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data data;
    private double start;
    private double end;
    private double delta;
    private int bins;
    private int[] counts;
    private float offset;
    private float scale;
    private boolean specialInf;
    private boolean specialBit;
    private long totalCounted;
    private long tooSmall;
    private long tooLarge;
    private boolean complex;
    private int cxmode = 1;
    public static final int M_MAG = 1;
    public static final int M_PHASE = 2;
    public static final int M_REAL = 3;
    public static final int M_IMAG = 4;
    public static final String modeList = "Mag,Phase,Real,Imag";

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "S#,C#", 1);
        this.hi.open();
        this.start = this.MA.getD("START");
        this.end = this.MA.getD("END");
        this.delta = this.MA.getD("DELTA");
        this.specialInf = false;
        this.specialBit = this.MA.getState("/BITS");
        this.bins = this.MA.getL("BINS", -1);
        boolean bl = this.complex = this.hi.getFormatMode() == 67;
        if (this.complex) {
            this.cxmode = this.MA.getSelectionIndex("CXMODE", modeList, this.cxmode, 0);
        }
        if (this.end <= this.start) {
            switch (this.hi.getFormatType()) {
                case 68: {
                    this.start = -1.7976931348623157E308;
                    this.end = Double.MAX_VALUE;
                    this.specialInf = true;
                    break;
                }
                case 70: {
                    this.start = -3.4028234663852886E38;
                    this.end = 3.4028234663852886E38;
                    this.specialInf = true;
                    break;
                }
                case 88: {
                    this.start = -9.223372036854776E18;
                    this.end = 9.223372036854776E18;
                    break;
                }
                case 76: {
                    this.start = -2.147483648E9;
                    this.end = 2.147483647E9;
                    break;
                }
                case 73: {
                    this.start = -32768.0;
                    this.end = 32767.0;
                    break;
                }
                case 66: {
                    this.start = -128.0;
                    this.end = 127.0;
                    break;
                }
                case 78: {
                    this.start = -8.0;
                    this.end = 7.0;
                    break;
                }
                case 80: {
                    this.start = -128.0;
                    this.end = 127.0;
                    this.specialBit = true;
                }
            }
        }
        if (this.delta <= 0.0 && this.bins <= 0) {
            this.bins = 512;
        }
        if (this.specialBit) {
            this.delta = 1.0;
            this.bins = 2;
        } else if (this.bins > 0) {
            this.delta = (this.end - this.start) / (double)(this.bins - 1);
        } else {
            this.bins = (int)((this.end - this.start) / this.delta) + 1;
        }
        this.scale = (float)(1.0 / this.delta);
        this.offset = (float)(this.start - 0.5 / (double)this.scale);
        this.ho = this.MA.getDataFile("OUT", "1000", "SL", 2);
        this.ho.setXUnits(32);
        this.ho.setXStart(this.start);
        this.ho.setXDelta(this.delta);
        this.ho.setSize(this.bins);
        this.ho.open();
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hi.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.counts = new int[this.bins];
        this.totalCounted = 0L;
        this.tooSmall = 0L;
        this.tooLarge = 0L;
        this.data = this.hi.getFormatType() == 68 || this.hi.getFormatType() == 88 ? this.hi.getDataBuffer(this.xfer, (byte)68) : this.hi.getDataBuffer(this.xfer, (byte)70);
        return 0;
    }

    @Override
    public int process() {
        int n = this.hi.read(this.data);
        if (n < 0) {
            return 9;
        }
        if (n == 0) {
            return -1;
        }
        if (this.complex) {
            switch (this.cxmode) {
                case 1: {
                    DataOp.mag(this.data, this.data, n, 18);
                    break;
                }
                case 2: {
                    DataOp.phase(this.data, this.data, n, 18);
                    break;
                }
                case 3: {
                    DataOp.real(this.data, this.data, n, 18);
                    break;
                }
                case 4: {
                    DataOp.imag(this.data, this.data, n, 18);
                    break;
                }
                default: {
                    DataOp.mag(this.data, this.data, n, 18);
                }
            }
        }
        if (this.specialBit) {
            int bps = Data.getBPS(this.data.type);
            for (int i = 0; i < n * bps; ++i) {
                byte b = this.data.getB(i);
                int pop = (b >> 0 & 1) + (b >> 1 & 1) + (b >> 2 & 1) + (b >> 3 & 1) + (b >> 4 & 1) + (b >> 5 & 1) + (b >> 6 & 1) + (b >> 7 & 1);
                this.counts[0] = this.counts[0] + (8 - pop);
                this.counts[1] = this.counts[1] + pop;
            }
            this.totalCounted += (long)(n * bps);
        } else if (this.data.type == 68) {
            double[] dbuf = this.data.castD(true);
            for (int i = 0; i < n; ++i) {
                double val = dbuf[i];
                int bin = (int)((val - (double)this.offset) * (double)this.scale);
                if (bin < 0) {
                    ++this.tooSmall;
                    continue;
                }
                if (bin >= this.bins) {
                    ++this.tooLarge;
                    continue;
                }
                int n2 = bin;
                this.counts[n2] = this.counts[n2] + 1;
            }
            this.data.uncast(dbuf, false);
            this.totalCounted += (long)n;
        } else {
            float[] fbuf = this.data.castF(true);
            for (int i = 0; i < n; ++i) {
                float val = fbuf[i];
                int bin = (int)((val - this.offset) * this.scale);
                if (bin < 0) {
                    ++this.tooSmall;
                    continue;
                }
                if (bin >= this.bins) {
                    ++this.tooLarge;
                    continue;
                }
                int n3 = bin;
                this.counts[n3] = this.counts[n3] + 1;
            }
            this.data.uncast(fbuf, false);
            this.totalCounted += (long)n;
        }
        if (this.specialInf) {
            this.counts[0] = (int)((long)this.counts[0] + this.tooSmall);
            int n4 = this.bins - 1;
            this.counts[n4] = (int)((long)this.counts[n4] + this.tooLarge);
            this.tooSmall = 0L;
            this.tooLarge = 0L;
        }
        if (this.hi.isPipe()) {
            this.ho.write(new Data(this.counts));
        }
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.write(new Data(this.counts));
        this.ho.close();
        if (this.verbose) {
            long totalSkipped = this.tooSmall + this.tooLarge;
            long totalPoints = this.totalCounted + totalSkipped;
            this.M.println("Input file            : " + this.hi.getName());
            this.M.println("Output file           : " + this.ho.getName());
            this.M.println("Start                 : " + this.start);
            this.M.println("End                   : " + this.end);
            this.M.println("Delta                 : " + this.delta);
            this.M.println("Bins                  : " + this.bins);
            this.M.println("Total points          : " + totalPoints);
            this.M.println("  Counted             : " + this.totalCounted);
            this.M.println("  Skipped (total)     : " + totalSkipped);
            this.M.println("  Skipped (N < start) : " + this.tooSmall);
            this.M.println("  Skipped (N > end)   : " + this.tooLarge);
        }
        return 0;
    }
}

