/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.Fft;

public class fft
extends Primitive {
    public static final String windowList = DataOp.windowList;
    public static final String partialList = "None,All,Start";
    public static final int P_NONE = 1;
    public static final int P_ALL = 2;
    public static final int P_START = 3;
    public static final String packList = "Unpack,DC,Zero";
    public static final int P_UNPACK = 1;
    public static final int P_DC = 2;
    public static final int P_ZERO = 3;
    private DataFile hi1;
    private DataFile ho1;
    private DataFile hi2;
    private DataFile ho2;
    private DataFile hox;
    private Data dbi1;
    private Data dbi2;
    private Data dbf1;
    private Data dbf2;
    private Data dbfx;
    private Data dbo;
    private Data dbw;
    private Data dba1;
    private Data dba2;
    private Data dbax;
    private Data dac;
    private Data db;
    private int nfft;
    private int nin;
    private int nrot;
    private int nout;
    private int navg;
    private int nexp;
    private int iavg;
    private int iexp;
    private int stride;
    private int pack;
    private int partial;
    private double factor;
    private double over;
    private double size;
    private double rnavg;
    private double rnexp;
    private boolean mag;
    private boolean psd;
    private boolean log;
    private boolean fdb;
    private boolean cxm;
    private boolean absc;
    private boolean out1d;
    private boolean in2d;
    private boolean dp;
    private boolean ac;
    private boolean cmag;
    private String wname;
    private Fft fft;

    @Override
    public int open() {
        double stry;
        double dely;
        this.hi1 = this.MA.getDataFile("IN1", "1000,2000", "S#,C#", 0);
        this.hi1.open(131072);
        this.in2d = this.hi1.typeClass == 2;
        this.hi2 = this.MA.getDataFile("IN2", "1000,2000", "S#,C#", 0);
        this.hi2.open(131136);
        this.nfft = this.MA.getL("NFFT");
        if (this.nfft == -1) {
            this.nfft = (int)this.hi1.getSize();
        }
        this.nin = this.MA.getL("/TL", this.nfft);
        this.psd = this.MA.getState("/PSD");
        this.log = this.MA.getState("/LOG");
        this.fdb = this.MA.getState("/DBF");
        this.mag = this.MA.getState("/MAG", this.fdb || this.log || this.psd);
        this.cmag = this.MA.getState("/CMAG");
        this.absc = this.MA.getState("/ABSC", true);
        this.out1d = this.MA.getState("/1D");
        this.ac = this.MA.getState("/AC");
        this.dp = this.MA.getState("/DP");
        this.partial = this.MA.getSelectionIndex("/PARTIAL", partialList, 3);
        if (this.state != 7) {
            this.navg = this.MA.getL("NAVG");
            this.over = this.MA.getD("OVER");
            this.nexp = this.MA.getL("/NEXP", 1);
            this.wname = this.MA.getS("WIN");
        }
        double delx = this.hi1.getXDelta();
        double delf = 1.0 / ((double)this.nfft * delx);
        boolean bl = this.cxm = this.hi1.spa == 2 || this.hi2.isOpen && this.hi2.spa == 2;
        if (this.in2d) {
            this.nin = this.hi1.getSubSize();
            dely = this.hi1.getYDelta();
            stry = this.hi1.getYStart();
            this.hi1.setFS(0);
            this.hi2.setFS(0);
            this.setOverlap(this.over);
        } else {
            this.setOverlap(this.over);
            dely = delx * (double)this.stride;
            stry = this.hi1.getXStart();
            if (this.hi2.isOpen) {
                this.hi1.align(this.hi2, this.absc, false);
            }
        }
        this.size = this.hi1.size;
        if (this.hi2.isOpen) {
            this.size = Math.min(this.hi2.size, this.size);
        }
        if (this.navg < 0) {
            this.navg = (int)((this.size - (double)this.nfft) / (double)this.stride) + 1;
        }
        this.setNAvg(this.navg);
        this.setNExp(this.nexp);
        int flags = 8;
        byte dtype = this.dp ? (byte)68 : 70;
        String cform = this.dp ? "CD" : "CF";
        String sform = this.dp ? "SD" : "SF";
        this.pack = this.out1d ? 1 : 3;
        this.pack = this.MA.getSelectionIndex("/PACK", packList, this.pack);
        if (this.cxm) {
            this.nout = this.nfft;
            this.nrot = this.nfft / 2 - 1;
            flags |= 2;
            this.factor = 1.0 / (double)this.nfft;
            this.pack = 0;
        } else {
            this.nout = this.nfft / 2;
            if (this.nfft != this.nout * 2) {
                this.M.error("Invalid FFT size parameter: " + this.nfft);
            }
            this.nrot = 0;
            flags |= 1;
            if (this.pack == 1) {
                flags |= 0x40;
                ++this.nout;
            } else {
                flags |= 0x20;
            }
            this.factor = 1.0 / (double)(2 * this.nfft);
        }
        this.factor = this.MA.getD("/SCALE", this.factor);
        this.fft = new Fft(this.nfft, flags);
        if (this.psd) {
            this.factor /= Math.sqrt(delf);
        }
        if (!this.MA.getState("/ROTATE", this.cxm)) {
            this.nrot = 0;
        }
        String oform = this.mag ? sform : cform;
        double osize = this.out1d ? 1.0 : Math.max(1.0, Math.floor((this.size - (double)this.nfft) / (double)this.stride / (double)this.navg));
        this.ho1 = this.MA.getDataFile("OUT1", "2000", oform, 0);
        this.ho1.propagate(this.hi1, "TIMECODE|KEYWORDS");
        this.ho1.setSubSize(this.nout);
        this.ho1.setXStart((double)(-this.nrot) * delf);
        this.ho1.setXDelta(delf);
        this.ho1.setXUnits(3);
        this.ho1.setYStart(stry + (double)((this.nfft + (this.navg - 1) * this.stride) / 2) * delx);
        this.ho1.setYDelta(dely * (double)this.navg);
        if (!this.out1d) {
            this.ho1.setYUnits(1);
        }
        this.ho1.setSize(osize);
        this.ho1.open(131136);
        this.setWindow(this.wname);
        this.dac = this.hi1.getDataBuffer(1, dtype);
        this.dbi1 = this.hi1.getDataBuffer(this.nin, dtype);
        this.dbf1 = new Data(cform, this.nout);
        this.dbo = this.ho1.getDataBuffer(1, dtype);
        this.dba1 = this.ho1.getDataBuffer(1, dtype);
        this.ho2 = this.MA.getDataFile("OUT2", this.ho1, 0);
        this.ho2.propagate(this.hi2, "TIMECODE|KEYWORDS");
        this.ho2.open(131136);
        this.hox = this.MA.getDataFile("CROSS", this.ho1, 0);
        if (this.cmag) {
            this.hox.setFormat(oform);
        } else {
            this.hox.setFormat(cform);
        }
        this.hox.open(131136);
        if (!this.hi2.isOpen && this.hox.isOpen) {
            this.M.error("CROSS parameter is invalid when only one input file supplied");
        }
        if (this.ho2.isOpen || this.hox.isOpen) {
            this.dbi2 = this.hi2.getDataBuffer(this.nin, dtype);
            this.dba2 = this.ho2.getDataBuffer(1, dtype);
            this.dbf2 = new Data(cform, this.nout);
            this.dbfx = new Data(cform, this.nout);
            this.dbax = new Data(this.cmag ? oform : cform, this.nout);
        }
        this.iexp = 1;
        this.iavg = 1;
        return 0;
    }

    @Override
    public int process() {
        int n2;
        int navgSaved = this.navg;
        int stat = 0;
        int n1 = this.hi1.isOpen ? this.hi1.read(this.dbi1) : 0;
        int n = n2 = this.hi2.isOpen ? this.hi2.read(this.dbi2) : n1;
        if (n1 < 0 || n2 < 0) {
            stat = 9;
            if (this.iavg == 1) {
                return stat;
            }
            this.navg = this.iavg;
            n1 = n2 = Math.max(0, Math.min(n1, n2));
        }
        this.rnavg = 1.0 / (double)this.navg;
        this.rnexp = 1.0 / (double)this.navg / (double)this.iexp;
        if (n1 == this.nin || this.partial != 1) {
            if (this.hi1.isOpen) {
                this.processInput(n1, this.ho1, this.dbi1, this.dbf1, this.dba1);
            }
            if (this.hi2.isOpen) {
                this.processInput(n2, this.ho2, this.dbi2, this.dbf2, this.dba2);
            }
            if (this.hox.isOpen) {
                this.processCross(this.hox, this.dbf1, this.dbf2, this.dbax);
            }
        }
        if (++this.iavg > this.navg) {
            this.iavg = 1;
            if (this.out1d) {
                stat = 9;
            }
            if (this.partial == 3) {
                this.partial = 1;
            }
            if (this.nexp <= 1) {
                this.iexp = 1;
            } else if (++this.iexp > this.nexp) {
                this.iexp = this.nexp;
            }
        }
        this.navg = navgSaved;
        return stat;
    }

    private void processInput(int n, DataFile ho, Data dbi, Data dbf, Data dba) {
        dbf.setSPA(dbi.spa);
        if (this.ac) {
            DataOp.sum(dbi, this.dac, n);
            DataOp.scale(this.dac, this.dac, 1, -1.0 / (double)n);
            DataOp.add(dbi, this.dac, dbi, n);
        }
        DataOp.mul(this.dbw, dbi, dbf);
        if (n < this.nfft) {
            DataOp.zero(dbf, n, this.nfft - n);
        }
        if (this.cxm && dbi.spa == 1) {
            DataOp.cmplx(dbf, dbf, this.nfft, 33);
        }
        this.fft.work(dbf);
        dbf.setSPA(2);
        this.db = dbf;
        if (this.pack == 3) {
            dbf.setF(1, 0.0f);
        }
        if (this.mag) {
            DataOp.mag2(this.db, this.dbo);
            this.db = this.dbo;
        }
        if (this.iexp > 1) {
            DataOp.scale(dba, dba, this.nout, 1.0 - this.rnexp);
            DataOp.scale(this.db, this.db, this.nout, this.rnexp);
            DataOp.add(this.db, dba, dba);
            if (this.iavg < this.navg) {
                return;
            }
            this.db = dba;
        } else if (this.navg > 1) {
            if (this.iavg == 1) {
                DataOp.copy(this.db, dba);
            } else {
                DataOp.add(this.db, dba, dba);
            }
            if (this.iavg < this.navg) {
                return;
            }
            DataOp.scale(dba, dba, this.nout, this.rnavg);
            this.db = dba;
        }
        if (this.nexp > 1) {
            DataOp.copy(dba, this.dbo);
            this.db = this.dbo;
        }
        if (this.db == dbf && this.hox.isOpen) {
            DataOp.copy(dbf, this.dbo);
            this.db = this.dbo;
        }
        if (this.fdb) {
            DataOp.dbf(this.db, this.nout, 0);
        } else if (this.log) {
            DataOp.dblogb(this.db, this.db);
        }
        if (this.nrot != 0) {
            this.fft.rotate(this.db);
        }
        this.db.setHeader(dbi.getHeader());
        ho.write(this.db);
    }

    private void processCross(DataFile ho, Data dbf1, Data dbf2, Data dba) {
        this.db = this.dbfx;
        DataOp.mul(dbf1, dbf2, this.db, this.nout, 2594);
        if (this.cmag) {
            DataOp.mag2(this.db, this.dbo);
            this.db = this.dbo;
        }
        if (this.nexp > 1) {
            DataOp.scale(dba, dba, this.nout, 1.0 - this.rnexp);
            DataOp.scale(this.db, this.db, this.nout, this.rnexp);
            DataOp.add(this.db, dba, dba);
            if (this.iavg < this.navg) {
                return;
            }
            this.db = dba;
        } else if (this.navg > 1) {
            if (this.iavg == 1) {
                DataOp.copy(this.db, dba);
            } else {
                DataOp.add(this.db, dba, dba);
            }
            if (this.iavg < this.navg) {
                return;
            }
            DataOp.scale(dba, dba, this.nout, this.rnavg);
            this.db = dba;
        }
        if (this.cmag) {
            if (this.fdb) {
                DataOp.dbf(this.db, this.nout, 0);
            } else if (this.log) {
                DataOp.dblogb(this.db, this.db);
            }
        }
        if (this.nrot != 0) {
            this.fft.rotate(this.db);
        }
        ho.write(this.db);
    }

    @Override
    public int close() {
        this.fft.free();
        if (this.out1d && this.ho1.isOpen) {
            this.ho1.setFS(0);
        }
        if (this.out1d && this.ho2.isOpen) {
            this.ho2.setFS(0);
        }
        if (this.out1d && this.hox.isOpen) {
            this.hox.setFS(0);
        }
        this.hi1.close();
        this.ho1.close();
        this.hi2.close();
        this.ho2.close();
        this.hox.close();
        return 0;
    }

    @Override
    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        int n = this.hi1.processReady(this.nin);
        if (this.hi2.isOpen) {
            n = Math.min(n, this.hi2.processReady(this.nin));
        }
        if (this.ho1.isOpen) {
            n = Math.min(n, this.ho1.processReady(1));
        }
        if (this.ho2.isOpen) {
            n = Math.min(n, this.ho2.processReady(1));
        }
        if (this.hox.isOpen) {
            n = Math.min(n, this.hox.processReady(1));
        }
        return n;
    }

    public int getNAvg() {
        return this.navg;
    }

    public int getNExp() {
        return this.nexp;
    }

    public int getNFft() {
        return this.nfft;
    }

    public double getOverlap() {
        return this.over;
    }

    public String getWindow() {
        return this.wname;
    }

    public void setNAvg(int value) {
        this.navg = Math.max(1, value);
    }

    public void setNExp(int value) {
        if (value < 0) {
            this.iexp = 1;
            value = -value;
        }
        this.nexp = Math.max(1, value);
    }

    public void setNFft(int value) {
        if (value == this.nfft) {
            return;
        }
        this.MA.put("NFFT", "" + value);
        this.setState(7);
    }

    public void setOverlap(double value) {
        if (this.in2d && this.stride % this.nin != 0) {
            this.M.warning("Type 2000 inputs don't have integral overlap=" + this.over);
        }
        this.over = value;
        this.stride = Math.max(0, (int)((1.0 - this.over) * (double)this.nin));
        this.hi1.setXferLength(this.nin);
        this.hi1.setConsLength(this.stride);
        this.hi2.setXferLength(this.nin);
        this.hi2.setConsLength(this.stride);
    }

    public void setWindow(String value) {
        int nwind = Math.min(this.nin, this.nfft);
        this.wname = value;
        this.dbw = DataOp.getWindow(this.wname, nwind, this.factor, this.M);
    }
}

