/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.util.ArrayList;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class compare
extends Primitive {
    private DataFile hi1;
    private DataFile hi2;
    private Data data1;
    private Data data2;
    private Table recordDef1;
    private Table recordDef2;
    private ArrayList<RecordInfo> numericSubRecs;
    private int numberFieldsPerRecord;
    private int tl = 4096;
    private float diffmin;
    private float diffmax;
    private float max_thr;
    private float min_thr;
    private float minScale;
    private float maxScale;
    private float fullScale;
    private String max_result_name;
    private String min_result_name;
    private String result_name;
    private boolean noErrorInOpen;

    @Override
    public int open() {
        this.noErrorInOpen = false;
        this.hi1 = this.MA.getDataFile("IN1");
        this.hi1.open();
        if (this.MA.isPresent("IN2")) {
            this.hi2 = this.MA.getDataFile("IN2");
            this.hi2.open();
        }
        this.max_thr = this.MA.getF("MAX_THR", 1.0E-9f);
        this.min_thr = this.MA.getF("MIN_THR", -1.0E-9f);
        this.max_result_name = this.MA.getS("MAX_OUT", null);
        this.min_result_name = this.MA.getS("MIN_OUT", null);
        this.result_name = this.MA.getS("RESULT", null);
        if (this.hi1.typeClass >= 2) {
            this.tl = 1;
        }
        this.tl = this.MA.getL("/TL", this.tl);
        if (this.hi1.typeClass <= 2) {
            this.data1 = this.hi1.getDataBuffer(this.tl, (byte)70);
        } else if (this.hi1.isRecordBased()) {
            this.data1 = this.hi1.getDataBuffer(this.tl);
            this.recordDef1 = this.hi1.getRecordDefs();
            this.numericSubRecs = this.createRecordInfoFromRecDefTab(this.recordDef1);
        }
        if (this.hi2 != null) {
            if (this.hi2.typeClass <= 2) {
                this.data2 = this.hi2.getDataBuffer(this.tl, (byte)70);
                if (this.recordDef1 != null) {
                    this.M.error("Cannot compare record based [" + this.hi1.getName() + "] to frame based file [" + this.hi2.getName() + "].");
                }
            } else if (this.hi2.isRecordBased()) {
                this.data2 = this.hi2.getDataBuffer(this.tl);
                this.recordDef2 = this.hi2.getRecordDefs();
                if (this.recordDef1 == null) {
                    this.M.error("Cannot compare frame based file [" + this.hi1.getName() + "] to record based file [" + this.hi2.getName() + "].");
                } else if (!this.recordDef1.equals(this.recordDef2)) {
                    this.M.error("SubRecord definition of both input files must match. IN1=" + this.hi1.getName() + " IN2=" + this.hi2.getName());
                }
            }
        }
        this.fullScale = 1.0E30f;
        this.maxScale = 1.0E30f;
        this.diffmin = 1.0E30f;
        this.minScale = -1.0E30f;
        this.diffmax = -1.0E30f;
        byte in1FormatType = this.hi1.getFormatType();
        if (in1FormatType != 72) {
            if (this.MA.getState("/LEGACYSCALE", false)) {
                this.M.deprecate("/LEGACYSCALE is deprecated since NeXtMidas 2.9.2 b/c it did not calculate the proper max/min/full scale for byte and other data types.");
                if (this.hi1.getFormatType() == 73) {
                    this.maxScale = 32767.0f;
                    this.minScale = -32768.0f;
                    this.fullScale = 65536.0f;
                } else if (this.hi1.getFormatType() == 66) {
                    this.maxScale = 255.0f;
                    this.minScale = -256.0f;
                    this.fullScale = 512.0f;
                }
            } else {
                this.maxScale = (float)Data.getTypeMax(in1FormatType);
                this.minScale = (float)Data.getTypeMin(in1FormatType);
                this.fullScale = this.maxScale - this.minScale + 1.0f;
            }
        }
        this.noErrorInOpen = true;
        return 0;
    }

    @Override
    public int process() {
        int numAtoms1;
        int elementsRead1 = this.hi1.read(this.data1);
        if (elementsRead1 == 0) {
            return -1;
        }
        if (elementsRead1 < 0) {
            return 9;
        }
        int numAtoms = numAtoms1 = elementsRead1 * this.hi1.ape;
        int numElems = elementsRead1;
        if (this.hi2 != null) {
            int elementsRead2 = this.hi2.read(this.data2, elementsRead1);
            if (elementsRead2 == 0) {
                return -1;
            }
            if (elementsRead2 < 0) {
                return 9;
            }
            int numAtoms2 = elementsRead2 * this.hi2.ape;
            numAtoms = Math.min(numAtoms1, numAtoms2);
            numElems = Math.min(elementsRead1, elementsRead2);
        }
        if (this.recordDef1 != null) {
            this.processRecordData(numElems);
        } else if (this.hi2 != null) {
            float[] farray1 = this.data1.castF(true);
            float[] farray2 = this.data2.castF(true);
            this.checkDiffOfArrays(farray1, farray2, numAtoms);
            this.data1.uncast(farray1, false);
            this.data2.uncast(farray2, false);
        } else {
            float[] farray1 = this.data1.castF(true);
            this.checkMaxMinOfArray(farray1, numAtoms);
            this.data1.uncast(farray1, false);
        }
        if (this.max_result_name != null) {
            this.MR.put(this.max_result_name, this.diffmax);
        }
        if (this.min_result_name != null) {
            this.MR.put(this.min_result_name, this.diffmin);
        }
        if (this.result_name != null) {
            this.MR.put(this.result_name, this.thresholdResult());
        }
        return 0;
    }

    @Override
    public int close() {
        if (this.noErrorInOpen) {
            if (this.verbose || this.max_result_name == null && this.min_result_name == null) {
                this.M.info("Diff MAX = " + this.diffmax);
            }
            if (this.verbose || this.max_result_name == null && this.min_result_name == null) {
                this.M.info("Diff MIN = " + this.diffmin);
            }
            if (this.verbose && this.result_name == null) {
                this.M.info("Diff within THRESHOLDS = " + this.thresholdResult());
            }
        }
        this.hi1.close();
        if (this.hi2 != null) {
            this.hi2.close();
        }
        return 0;
    }

    private final int thresholdResult() {
        return this.diffmax < this.max_thr && this.diffmin > this.min_thr ? 1 : 0;
    }

    private void processRecordData(int ngot) {
        block7: {
            block6: {
                if (this.recordDef2 == null) break block6;
                for (int ii = 0; ii < ngot; ++ii) {
                    for (RecordInfo recInfo : this.numericSubRecs) {
                        int offset = recInfo.offset + ii * this.data1.bpe;
                        Data subdata1 = this.data1.getAtomAt(offset, recInfo.format);
                        Data subdata2 = this.data2.getAtomAt(offset, recInfo.format);
                        if (recInfo.spa == 1) {
                            float f1 = subdata1.toF();
                            float f2 = subdata2.toF();
                            this.checkDiff(f1, f2);
                            continue;
                        }
                        if (recInfo.spa <= 1) continue;
                        float[] farray1 = subdata1.castF(true);
                        float[] farray2 = subdata2.castF(true);
                        this.checkDiffOfArrays(farray1, farray2, farray1.length);
                        subdata1.uncast(farray1, false);
                        subdata2.uncast(farray2, false);
                    }
                }
                break block7;
            }
            if (this.recordDef1 == null) break block7;
            for (int ii = 0; ii < ngot; ++ii) {
                for (RecordInfo recInfo : this.numericSubRecs) {
                    int offset = recInfo.offset + ii * this.data1.bpe;
                    Data subdata1 = this.data1.getAtomAt(offset, recInfo.format);
                    if (recInfo.spa == 1) {
                        this.checkMaxMin(subdata1.toF());
                        continue;
                    }
                    if (recInfo.spa <= 1) continue;
                    float[] farray = subdata1.castF(true);
                    this.checkMaxMinOfArray(farray, farray.length);
                    subdata1.uncast(farray, false);
                }
            }
        }
    }

    private final void checkDiff(float f1, float f2) {
        float diff = f2 - f1;
        diff = this.checkDiffWithScale(diff);
        this.checkMaxMin(diff);
    }

    private final void checkDiffOfArrays(float[] farray1, float[] farray2, int n) {
        for (int ii = 0; ii < n; ++ii) {
            float diff = farray2[ii] - farray1[ii];
            diff = this.checkDiffWithScale(diff);
            this.checkMaxMin(diff);
        }
    }

    private final float checkDiffWithScale(float diff) {
        if (diff > this.maxScale) {
            diff -= this.fullScale;
        }
        if (diff < this.minScale) {
            diff += this.fullScale;
        }
        return diff;
    }

    private final void checkMaxMin(float f) {
        if (f > this.diffmax) {
            this.diffmax = f;
        }
        if (f < this.diffmin) {
            this.diffmin = f;
        }
    }

    private final void checkMaxMinOfArray(float[] farray, int n) {
        for (int ii = 0; ii < n; ++ii) {
            float f = farray[ii];
            if (f > this.diffmax) {
                this.diffmax = f;
            }
            if (!(f < this.diffmin)) continue;
            this.diffmin = f;
        }
    }

    private ArrayList<RecordInfo> createRecordInfoFromRecDefTab(Table recDefTab) {
        ArrayList<RecordInfo> list3 = new ArrayList<RecordInfo>();
        this.numberFieldsPerRecord = 0;
        Table.Iterator iter = recDefTab.iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            Object val = iter.getValue();
            if (!(val instanceof Table)) continue;
            Table tbl = Convert.o2t(val);
            String format = tbl.getS("FORMAT");
            char type = format.charAt(1);
            if ("D,F,X,L,I,B,N,P".indexOf(type) >= 0) {
                char mode = format.charAt(0);
                int spa = Data.getSPA(mode);
                this.numberFieldsPerRecord += spa;
                RecordInfo recInfo = new RecordInfo(tbl.getL("OFFSET"), format, spa);
                list3.add(recInfo);
                continue;
            }
            if (!this.verbose) continue;
            this.M.info("COMPARE: will ignore non-numeric SubRecord Name=" + key + " Format=" + format);
        }
        return list3;
    }

    static class RecordInfo {
        final int offset;
        final String format;
        final int spa;

        public RecordInfo(int off, String formatType, int scalarsPerRecord) {
            this.offset = off;
            this.format = formatType;
            this.spa = scalarsPerRecord;
        }

        public String toString() {
            return "(" + this.offset + "," + this.format + ")";
        }
    }
}

