/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.osgi;

import java.net.URL;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.OptionTree;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class NeXtMidasActivator
implements BundleActivator,
OptionTree.OptionTreeFinder {
    private static NeXtMidasActivator sharedInstance;
    private BundleContext context;
    private PackageAdmin packageAdmin;
    private int debugLevel = 0;

    public void start(BundleContext context) throws Exception {
        ServiceReference ref;
        if (this.debugLevel > 0) {
            this.log("start()");
        }
        sharedInstance = this;
        this.context = context;
        this.setDebug(this.getDebugProperty(context));
        if (System.getProperty("NONATIVE") == null) {
            System.setProperty("NONATIVE", "FALSE");
        }
        this.packageAdmin = (ref = context.getServiceReference(PackageAdmin.class.getName())) == null ? null : (PackageAdmin)context.getService(ref);
        OptionTree.registerOptionTreeFinder(this);
        if (this.debugLevel > 1) {
            this.listOptionTreeBundles();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.debugLevel > 0) {
            this.log("stop()");
        }
        sharedInstance = null;
        this.context = null;
    }

    public static NeXtMidasActivator getDefault() {
        return sharedInstance;
    }

    @Override
    public String findOptRoot(String opt) {
        Bundle bundle = this.findBundleForOpt(opt = opt.toLowerCase(), null);
        if (bundle != null) {
            String resname = "nxm/" + opt + "/cfg/commands.cnf";
            URL commands_cnf = bundle.getResource(resname);
            if (commands_cnf != null) {
                String urlstr = commands_cnf.toString();
                int index = urlstr.lastIndexOf(resname);
                return urlstr.substring(0, index);
            }
            if (this.debugLevel > 0) {
                this.log("Found bundle for [" + opt.toUpperCase() + "], but unable to find " + resname);
            }
        }
        return null;
    }

    public Bundle findBundleForOpt(String optName, String versionRange) {
        Bundle[] bundleArray;
        int n;
        int n2;
        if (this.packageAdmin == null) {
            return null;
        }
        optName = optName.toLowerCase();
        Bundle[] bundles = this.packageAdmin.getBundles("nxm." + optName, versionRange);
        if (bundles != null && (n2 = 0) < (n = (bundleArray = bundles).length)) {
            Bundle bundle = bundleArray[n2];
            return bundle;
        }
        return null;
    }

    public void listOptionTreeBundles() {
        for (Bundle bundle : this.context.getBundles()) {
            if (!bundle.getSymbolicName().startsWith("nxm.")) continue;
            this.log("bundle: " + bundle);
        }
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.0")
    public int getDebug() {
        return this.debugLevel;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.0")
    public void setDebug(int level) {
        this.debugLevel = level;
    }

    private int getDebugProperty(BundleContext context) {
        String val = context.getProperty(this.getClass().getName() + ".debug");
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.debugLevel;
    }

    private void log(CharSequence msg) {
        System.out.println("NeXtMidasActivator: " + msg);
    }
}

