/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

public class Window {
    public static String nameList = "None,Hanning,Hamming,Bartlett,Blackman,BH61,BH67,BH74,BH92";

    private Window() {
    }

    public static float[] get(String name, int size, double scale) {
        return size < 0 ? Window.get(name, -size, scale, true) : Window.get(name, size, scale, false);
    }

    public static float[] get(String name, int size, double scale, boolean symmetric) {
        double d;
        float[] buf = new float[size];
        if (symmetric) {
            --size;
        }
        int sizeh = size / 2;
        double twoPi_Size = Math.PI * 2 / (double)size;
        if ((name = name.toUpperCase()).startsWith("NONE")) {
            float fscale = (float)scale;
            for (int i = 0; i <= sizeh; ++i) {
                buf[i] = fscale;
            }
        } else if (name.startsWith("BART")) {
            float fscale = (float)scale;
            float fsizeh = sizeh;
            for (int i = 0; i <= sizeh; ++i) {
                buf[i] = (float)i / fsizeh * fscale;
            }
        } else if (name.startsWith("HANN")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.5 - 0.5 * Math.cos(a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("HAMM")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.54 - 0.46 * Math.cos(a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("BLAC")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.42 - 0.5 * Math.cos(a) + 0.08 * Math.cos(2.0 * a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("BH61")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.44959 - 0.49364 * Math.cos(a) + 0.05677 * Math.cos(2.0 * a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("BH67")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.42323 - 0.49755 * Math.cos(a) + 0.07922 * Math.cos(2.0 * a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("BH74")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.40217 - 0.49703 * Math.cos(a) + 0.09897 * Math.cos(2.0 * a) - 0.00183 * Math.cos(3.0 * a);
                buf[i] = (float)(d * scale);
            }
        } else if (name.startsWith("BH92")) {
            for (int i = 0; i <= sizeh; ++i) {
                double a = twoPi_Size * (double)i;
                d = 0.35875 - 0.48829 * Math.cos(a) + 0.14128 * Math.cos(2.0 * a) - 0.01168 * Math.cos(3.0 * a);
                buf[i] = (float)(d * scale);
            }
        } else {
            return null;
        }
        for (int i = sizeh + 1; i < size; ++i) {
            buf[i] = buf[size - i];
        }
        if (symmetric) {
            buf[size] = buf[0];
        }
        return buf;
    }
}

