/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class Scale
extends Operator
implements Constants {
    public Scale() {
    }

    public Scale(int flags) {
        super(flags);
    }

    public Scale(double scale) {
        super(scale);
    }

    public Scale(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 17: {
                return n;
            }
            case 34: {
                return n;
            }
            case 51: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, this.scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(double[] a, double[] b, int n, double scale) {
        double s = scale;
        for (int i = 0; i < n; ++i) {
            b[i] = s * a[i];
        }
    }

    public static final void CC(double[] a, double[] b, int n, double scale) {
        double s = scale;
        int i = 0;
        int j = 0;
        while (i < n) {
            b[j] = s * a[j];
            b[j + 1] = s * a[j + 1];
            ++i;
            j += 2;
        }
    }

    public static final void VV(double[] a, double[] b, int n, double scale) {
        double s = scale;
        int i = 0;
        int k = 0;
        while (i < n) {
            b[k] = s * a[k];
            b[k + 1] = s * a[k + 1];
            b[k + 2] = s * a[k + 2];
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, this.scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(float[] a, float[] b, int n, double scale) {
        float s = (float)scale;
        for (int i = 0; i < n; ++i) {
            b[i] = s * a[i];
        }
    }

    public static final void CC(float[] a, float[] b, int n, double scale) {
        float s = (float)scale;
        int i = 0;
        int j = 0;
        while (i < n) {
            b[j] = s * a[j];
            b[j + 1] = s * a[j + 1];
            ++i;
            j += 2;
        }
    }

    public static final void VV(float[] a, float[] b, int n, double scale) {
        float s = (float)scale;
        int i = 0;
        int k = 0;
        while (i < n) {
            b[k] = s * a[k];
            b[k + 1] = s * a[k + 1];
            b[k + 2] = s * a[k + 2];
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, this.scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                Scale.SS(v[0], v[1], n, scale);
                return n;
            }
            case 34: {
                Scale.CC(v[0], v[1], n, scale);
                return n;
            }
            case 51: {
                Scale.VV(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(int[] a, int[] b, int n, double scale) {
        int s = (int)scale;
        for (int i = 0; i < n; ++i) {
            b[i] = s * a[i];
        }
    }

    public static final void CC(int[] a, int[] b, int n, double scale) {
        int s = (int)scale;
        int i = 0;
        int j = 0;
        while (i < n) {
            b[j] = s * a[j];
            b[j + 1] = s * a[j + 1];
            ++i;
            j += 2;
        }
    }

    public static final void VV(int[] a, int[] b, int n, double scale) {
        int s = (int)scale;
        int i = 0;
        int k = 0;
        while (i < n) {
            b[k] = s * a[k];
            b[k + 1] = s * a[k + 1];
            b[k + 2] = s * a[k + 2];
            ++i;
            k += 3;
        }
    }

    @Override
    public int getInputs() {
        return 1;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

