/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import java.security.SecureRandom;
import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class RandomSecure
extends Operator
implements Constants {
    private static final SecureRandom prng = new SecureRandom();

    public RandomSecure() {
    }

    public RandomSecure(int flags) {
        super(flags);
    }

    public RandomSecure(double scale) {
        super(scale);
    }

    public RandomSecure(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 1: {
                return n;
            }
            case 2: {
                return n;
            }
            case 3: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    public final void S(double[] a, int n) {
        for (int i = 0; i < n; ++i) {
            a[i] = prng.nextDouble();
        }
    }

    public final void C(double[] a, int n) {
        int i = 0;
        int j = 0;
        while (i < n) {
            a[j] = prng.nextDouble();
            a[j + 1] = prng.nextDouble();
            ++i;
            j += 2;
        }
    }

    public final void V(double[] a, int n) {
        int i = 0;
        int k = 0;
        while (i < n) {
            a[k] = prng.nextDouble();
            a[k + 1] = prng.nextDouble();
            a[k + 2] = prng.nextDouble();
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    public final void S(float[] a, int n) {
        for (int i = 0; i < n; ++i) {
            a[i] = (float)prng.nextDouble();
        }
    }

    public final void C(float[] a, int n) {
        int i = 0;
        int j = 0;
        while (i < n) {
            a[j] = (float)prng.nextDouble();
            a[j + 1] = (float)prng.nextDouble();
            ++i;
            j += 2;
        }
    }

    public final void V(float[] a, int n) {
        int i = 0;
        int k = 0;
        while (i < n) {
            a[k] = (float)prng.nextDouble();
            a[k + 1] = (float)prng.nextDouble();
            a[k + 2] = (float)prng.nextDouble();
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 1: {
                this.S(v[0], n);
                return n;
            }
            case 2: {
                this.C(v[0], n);
                return n;
            }
            case 3: {
                this.V(v[0], n);
                return n;
            }
        }
        return -1;
    }

    public final void S(int[] a, int n) {
        for (int i = 0; i < n; ++i) {
            a[i] = (int)prng.nextDouble();
        }
    }

    public final void C(int[] a, int n) {
        int i = 0;
        int j = 0;
        while (i < n) {
            a[j] = (int)prng.nextDouble();
            a[j + 1] = (int)prng.nextDouble();
            ++i;
            j += 2;
        }
    }

    public final void V(int[] a, int n) {
        int i = 0;
        int k = 0;
        while (i < n) {
            a[k] = (int)prng.nextDouble();
            a[k + 1] = (int)prng.nextDouble();
            a[k + 2] = (int)prng.nextDouble();
            ++i;
            k += 3;
        }
    }

    @Override
    public int getInputs() {
        return 0;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

