/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class Power
extends Operator
implements Constants {
    public Power() {
    }

    public Power(int flags) {
        super(flags);
    }

    public Power(double scale) {
        super(scale);
    }

    public Power(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 273: {
                return n;
            }
            case 530: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(double[] a, double[] b, double[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = Math.pow(a[i], b[0]);
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = Math.pow(a[0], b[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = Math.pow(a[i], b[i]);
            }
        }
    }

    public static final void CSC(double[] a, double[] b, double[] c, int n) {
        if (b.length == 1) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], b[0] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * b[0];
                c[j] = mag * Math.cos(pha);
                c[j + 1] = mag * Math.sin(pha);
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[0] * a[0] + a[1] * a[1], b[i] * 0.5);
                double pha = Math.atan2(a[1], a[0]) * b[i];
                c[j] = mag * Math.cos(pha);
                c[j + 1] = mag * Math.sin(pha);
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], b[i] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * b[i];
                c[j] = mag * Math.cos(pha);
                c[j + 1] = mag * Math.sin(pha);
                ++i;
                j += 2;
            }
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(float[] a, float[] b, float[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = (float)Math.pow(a[i], b[0]);
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = (float)Math.pow(a[0], b[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = (float)Math.pow(a[i], b[i]);
            }
        }
    }

    public static final void CSC(float[] a, float[] b, float[] c, int n) {
        if (b.length == 1) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], (double)b[0] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * (double)b[0];
                c[j] = (float)(mag * Math.cos(pha));
                c[j + 1] = (float)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[0] * a[0] + a[1] * a[1], (double)b[i] * 0.5);
                double pha = Math.atan2(a[1], a[0]) * (double)b[i];
                c[j] = (float)(mag * Math.cos(pha));
                c[j + 1] = (float)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], (double)b[i] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * (double)b[i];
                c[j] = (float)(mag * Math.cos(pha));
                c[j + 1] = (float)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                Power.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 530: {
                Power.CSC(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(int[] a, int[] b, int[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = (int)Math.pow(a[i], b[0]);
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = (int)Math.pow(a[0], b[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = (int)Math.pow(a[i], b[i]);
            }
        }
    }

    public static final void CSC(int[] a, int[] b, int[] c, int n) {
        if (b.length == 1) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], (double)b[0] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * (double)b[0];
                c[j] = (int)(mag * Math.cos(pha));
                c[j + 1] = (int)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[0] * a[0] + a[1] * a[1], (double)b[i] * 0.5);
                double pha = Math.atan2(a[1], a[0]) * (double)b[i];
                c[j] = (int)(mag * Math.cos(pha));
                c[j + 1] = (int)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                double mag = Math.pow(a[j] * a[j] + a[j + 1] * a[j + 1], (double)b[i] * 0.5);
                double pha = Math.atan2(a[j + 1], a[j]) * (double)b[i];
                c[j] = (int)(mag * Math.cos(pha));
                c[j + 1] = (int)(mag * Math.sin(pha));
                ++i;
                j += 2;
            }
        }
    }

    @Override
    public int getInputs() {
        return 2;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

