/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.LargeJTable;
import nxm.sys.libg.Symbol;

public class TableSorter
extends AbstractTableModel
implements LargeJTable.LargeTableModel {
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static final long serialVersionUID = 2012021020311L;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_TABLESORTER_OBJECT_MESSAGE = "nxm.sys.libg.TableSorter does NOT currently support Java Serialization";
    private LargeJTable table = null;
    private transient LargeJTable.LargeTableModel tableModel = null;
    private JTableHeader tableHeader = null;
    private transient MouseListener mouseListener = null;
    private transient TableModelListener modelListener = null;
    private transient Comparator<Number> sorter = null;
    private transient Symbol upTriangle = null;
    private transient Symbol dnTriangle = null;
    private int maxSize = 0;
    private boolean warnMaxSize = true;
    private long column = 0L;
    private int direction = 0;
    private boolean upToDate = false;
    private Vector<Number> realIndex = new Vector();
    private Vector<Number> viewIndex = new Vector();
    private boolean allowSorting = true;

    public TableSorter(LargeJTable table, LargeJTable.LargeTableModel tableModel, JTableHeader tableHeader, int maxSize) {
        this.table = table;
        this.mouseListener = new MouseHandler();
        this.modelListener = new TableModelHandler();
        this.sorter = new TableValueComparator();
        this.maxSize = maxSize;
        this.warnMaxSize = maxSize > 0;
        this.upTriangle = new Symbol.UTriangle();
        this.upTriangle.setFilled(true);
        this.dnTriangle = new Symbol.DTriangle();
        this.dnTriangle.setFilled(true);
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    @Override
    public void setValueAt(Object val, long row, long col) {
        this.tableModel.setValueAt(val, this.toReal(row), col);
    }

    @Override
    public boolean isCellEditable(long row, long col) {
        return this.tableModel.isCellEditable(this.toReal(row), col);
    }

    @Override
    public Object getValueAt(long row, long col) {
        return this.tableModel.getValueAt(this.toReal(row), col);
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCellEditable(this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
    }

    @Override
    public void setValueAt(Object val, int rowIndex, int columnIndex) {
        this.setValueAt(val, this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
    }

    @Override
    public void fireNeedsRedraw(long top, long btm) {
        if (this.isSorting()) {
            this.getTableModel().fireNeedsRedraw(-1L, -1L);
        } else {
            this.getTableModel().fireNeedsRedraw(top, btm);
        }
    }

    @Override
    public void fireRowsInserted(long top, long btm) {
        if (this.isSorting()) {
            this.getTableModel().fireRowsInserted(-1L, -1L);
        } else {
            this.getTableModel().fireRowsInserted(top, btm);
        }
    }

    @Override
    public void fireRowsDeleted(long top, long btm) {
        if (this.isSorting()) {
            this.getTableModel().fireRowsDeleted(-1L, -1L);
        } else {
            this.getTableModel().fireRowsDeleted(top, btm);
        }
    }

    @Override
    public void fireStructureChanged() {
        this.getTableModel().fireStructureChanged();
    }

    public LargeJTable.LargeTableModel getTableModel() {
        return this.tableModel;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).renderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.direction != 0;
    }

    public int getSortingStatus(int column) {
        return (long)column == this.column ? this.direction : 0;
    }

    public void setSortingStatus(int column, int direction) {
        if (column < 0 || !this.allowSorting) {
            direction = 0;
            column = 0;
        }
        if (this.direction == 0 && direction == 0) {
            if (this.column != (long)column) {
                this.clearSortingState();
                this.column = column;
            }
        } else if (this.table.getNumberOfRows() > (long)this.maxSize) {
            if (this.warnMaxSize) {
                Shell.warning("WARNING: Table is too large to sort.");
                this.warnMaxSize = false;
            }
        } else if (this.column == (long)column) {
            if (this.direction != direction) {
                this.direction = direction;
                this.sortingStatusChanged();
            }
        } else {
            this.clearSortingState();
            this.column = column;
            this.direction = direction;
            this.sortingStatusChanged();
        }
    }

    public void setSortingStatus(String column) {
        int dir = 1;
        long col = -1L;
        if (column != null && column.length() > 1) {
            if (column.startsWith("+")) {
                dir = 1;
                col = this.table.getColumnIndex(column.substring(1));
            } else if (column.startsWith("-")) {
                dir = -1;
                col = this.table.getColumnIndex(column.substring(1));
            } else {
                dir = 1;
                col = this.table.getColumnIndex(column);
            }
        } else if (column != null && column.length() > 0) {
            dir = 1;
            col = this.table.getColumnIndex(column);
        }
        this.setSortingStatus((int)col, dir);
    }

    public void setSortingEnabled(boolean enabled) {
        if (enabled != this.allowSorting) {
            this.allowSorting = enabled;
            if (!this.allowSorting) {
                this.setSortingStatus(null);
            }
        }
    }

    public boolean getSortingEnabled() {
        return this.allowSorting;
    }

    public String getSortingStatus() {
        String status = "";
        status = this.direction == 1 ? "+" + this.getColumnName((int)this.column) : (this.direction == -1 ? "-" + this.getColumnName((int)this.column) : "");
        return status;
    }

    private long getSortIndex(Vector<Number> mapping, long row) {
        if (this.direction != 0) {
            int index;
            int n = index = this.direction == 1 ? (int)row : (int)(this.table.getNumberOfRows() - 1L - row);
            if (!this.isUpToDate()) {
                this.resort();
            }
            row = mapping.get(index).longValue();
        }
        return row;
    }

    long toReal(long row) {
        return this.getSortIndex(this.realIndex, row);
    }

    long toView(long row) {
        return this.getSortIndex(this.viewIndex, row);
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        int direction = this.getSortingStatus(column);
        Symbol icon = null;
        if (direction == 1) {
            icon = this.upTriangle;
        } else if (direction == -1) {
            icon = this.dnTriangle;
        }
        if (icon != null) {
            icon.setSize(size / 2);
        }
        return icon;
    }

    private synchronized void resort() {
        if (!this.isUpToDate()) {
            int i;
            this.realIndex.setSize((int)this.table.getNumberOfRows());
            this.viewIndex.setSize((int)this.table.getNumberOfRows());
            for (i = 0; i < this.realIndex.size(); ++i) {
                this.realIndex.set(i, i);
            }
            Collections.sort(this.realIndex, this.sorter);
            for (i = 0; i < this.viewIndex.size(); ++i) {
                int index = this.realIndex.get(i).intValue();
                this.viewIndex.set(index, i);
            }
            this.upToDate = true;
        }
    }

    private synchronized boolean isUpToDate() {
        return this.upToDate && this.table.getNumberOfRows() == (long)this.realIndex.size();
    }

    private synchronized void clearSortingState() {
        this.direction = 0;
        this.upToDate = false;
        this.column = 0L;
        this.realIndex.clear();
        this.viewIndex.clear();
    }

    private void clearAll() {
        this.clearSortingState();
        this.sortingStatusChanged();
    }

    private void cancelSorting() {
        if (this.direction != 0) {
            this.direction = 0;
            this.sortingStatusChanged();
        }
    }

    private void invalidateSorting() {
        if (this.upToDate) {
            this.upToDate = false;
            this.sortingStatusChanged();
        }
    }

    private void sortingStatusChanged() {
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
            this.table.getRowHeader().repaint();
        }
    }

    public void setTableModel(LargeJTable.LargeTableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.modelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.modelListener);
        }
        this.clearSortingState();
        this.sortingStatusChanged();
    }

    private int compareRows(long row1, long row2) {
        int returnValue = 0;
        Object val1 = this.tableModel.getValueAt(row1, this.column);
        Object val2 = this.tableModel.getValueAt(row2, this.column);
        returnValue = val1 instanceof String ? ((String)val1).compareTo(val2.toString()) : (val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.toString().compareTo(val2.toString()));
        return returnValue;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_TABLESORTER_OBJECT_MESSAGE);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_TABLESORTER_OBJECT_MESSAGE);
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.fireTableChanged(e);
            } else if (e.getFirstRow() != -1) {
                long numRows;
                boolean invalidate = true;
                if (e.getFirstRow() == e.getLastRow() && (numRows = TableSorter.this.table.getNumberOfRows()) == (long)TableSorter.this.realIndex.size()) {
                    long rowNum = TableSorter.this.toReal(e.getFirstRow());
                    if (numRows <= 1L) {
                        invalidate = false;
                    } else if (rowNum == 0L) {
                        invalidate = TableSorter.this.compareRows(rowNum, rowNum + 1L) > 0;
                    } else if (rowNum == numRows - 1L) {
                        invalidate = TableSorter.this.compareRows(rowNum - 1L, rowNum) > 0;
                    } else {
                        boolean bl = invalidate = TableSorter.this.compareRows(rowNum - 1L, rowNum) > 0 || TableSorter.this.compareRows(rowNum, rowNum + 1L) > 0;
                    }
                }
                if (invalidate) {
                    TableSorter.this.invalidateSorting();
                }
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 2012021020311L;
        private transient TableCellRenderer renderer;

        public SortableHeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int col) {
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSel, hasFocus, row, col);
            if (comp instanceof JLabel) {
                int modelColumn = table.convertColumnIndexToModel(col);
                JLabel jlabel = (JLabel)comp;
                jlabel.setHorizontalTextPosition(2);
                jlabel.setIcon(TableSorter.this.getHeaderRendererIcon(modelColumn, jlabel.getFont().getSize()));
            }
            return comp;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn == -1) {
                return;
            }
            int column = columnModel.getColumn(viewColumn).getModelIndex();
            if (column != -1) {
                int status = TableSorter.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    TableSorter.this.cancelSorting();
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                TableSorter.this.setSortingStatus(column, status);
            }
        }
    }

    protected class TableValueComparator
    implements Comparator<Number> {
        protected TableValueComparator() {
        }

        @Override
        public int compare(Number o1, Number o2) {
            long row1 = o1.longValue();
            long row2 = o2.longValue();
            return TableSorter.this.compareRows(row1, row2);
        }
    }
}

