/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

class SlidingMinMax {
    static final int COLUMN_MIN = 0;
    static final int COLUMN_MAX = 1;
    private int numValid = 0;
    private int currentHead = -1;
    private int maxActive = 0;
    private boolean forceRecalculation = false;
    private int buffLength = 0;
    private int indexSmallestMin = 0;
    private int indexLargestMax = 0;
    private double currentSmallestMin = 0.0;
    private double currentLargestMax = 0.0;
    private double[][] minMaxBuffer;

    SlidingMinMax(int buffLength, int maxActive) {
        this.buffLength = buffLength;
        this.minMaxBuffer = new double[buffLength][2];
        this.maxActive = maxActive < buffLength ? maxActive : buffLength;
    }

    double[] updateMinMax(double newMin, double newMax) {
        boolean needForceRecalculation = this.forceRecalculation;
        if (this.forceRecalculation) {
            this.forceRecalculation = false;
        }
        this.currentHead = (this.currentHead + 1) % this.buffLength;
        this.minMaxBuffer[this.currentHead][0] = newMin;
        this.minMaxBuffer[this.currentHead][1] = newMax;
        if (this.numValid < this.buffLength) {
            ++this.numValid;
        }
        if (needForceRecalculation) {
            this.recalculateSmallestMinAndIndex();
            this.recalculateLargestMaxAndIndex();
        } else {
            if (this.numValid == 1 || newMin < this.currentSmallestMin) {
                this.indexSmallestMin = this.currentHead;
                this.currentSmallestMin = newMin;
            } else {
                boolean smallestMinActive;
                boolean bl = smallestMinActive = this.indexSmallestMin != this.currentHead && (this.currentHead + this.buffLength - this.indexSmallestMin) % this.buffLength < this.maxActive;
                if (!smallestMinActive) {
                    this.recalculateSmallestMinAndIndex();
                }
            }
            if (this.numValid == 1 || newMax > this.currentLargestMax) {
                this.indexLargestMax = this.currentHead;
                this.currentLargestMax = newMax;
            } else {
                boolean largestMaxActive;
                boolean bl = largestMaxActive = this.indexLargestMax != this.currentHead && (this.currentHead + this.buffLength - this.indexLargestMax) % this.buffLength < this.maxActive;
                if (!largestMaxActive) {
                    this.recalculateLargestMaxAndIndex();
                }
            }
        }
        double[] minMax = new double[]{this.currentSmallestMin, this.currentLargestMax};
        return minMax;
    }

    private void recalculateSmallestMinAndIndex() {
        this.currentSmallestMin = this.minMaxBuffer[this.currentHead][0];
        this.indexSmallestMin = this.currentHead;
        int firstIndexToSkip = (this.currentHead + this.buffLength - Math.min(this.maxActive, this.numValid)) % this.buffLength;
        int index = (this.currentHead - 1 + this.buffLength) % this.buffLength;
        while (index != firstIndexToSkip) {
            if (this.minMaxBuffer[index][0] < this.currentSmallestMin) {
                this.currentSmallestMin = this.minMaxBuffer[index][0];
                this.indexSmallestMin = index;
            }
            index = (index - 1 + this.buffLength) % this.buffLength;
        }
    }

    private void recalculateLargestMaxAndIndex() {
        this.currentLargestMax = this.minMaxBuffer[this.currentHead][1];
        this.indexLargestMax = this.currentHead;
        int firstIndexToSkip = (this.currentHead + this.buffLength - Math.min(this.maxActive, this.numValid)) % this.buffLength;
        int index = (this.currentHead - 1 + this.buffLength) % this.buffLength;
        while (index != firstIndexToSkip) {
            if (this.minMaxBuffer[index][1] > this.currentLargestMax) {
                this.currentLargestMax = this.minMaxBuffer[index][1];
                this.indexLargestMax = index;
            }
            index = (index - 1 + this.buffLength) % this.buffLength;
        }
    }

    int setMaxActive(int autoscaleLength) {
        int newMaxActive;
        int n = newMaxActive = autoscaleLength < this.buffLength ? autoscaleLength : this.buffLength;
        if (newMaxActive != this.maxActive) {
            int oldMaxActive = this.maxActive;
            this.maxActive = newMaxActive;
            if (this.maxActive > oldMaxActive) {
                this.forceRecalculation = true;
            }
        }
        return this.maxActive;
    }

    int getMaxActive() {
        return this.maxActive;
    }

    int getNumValid() {
        return this.numValid;
    }
}

