/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.MidasDisplay;

public class PushPopPanel
extends JPanel {
    private JPanel jPanel1;
    private MidasDisplay midasDisplay;
    private JButton optionsButton;
    private JPopupMenu optionsMenu;
    private JMenuItem popMenuItem;
    private JMenuItem pushMenuItem;
    private JButton pushPopButton;
    private JLabel titleLabel;

    public PushPopPanel() {
        GraphicsDevice[] devices;
        this.initComponents();
        this.midasDisplay.setTitle(this.getTitle());
        for (final GraphicsDevice d : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText("  Pop to " + d.getIDstring());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MWindow mw = PushPopPanel.this.midasDisplay.getMWindow();
                    if (mw != null) {
                        mw.pop(1, d);
                    }
                }
            });
            this.optionsMenu.add(menuItem);
        }
    }

    public MidasDisplay getMidasDisplay() {
        return this.midasDisplay;
    }

    public void setTitle(String t) {
        this.titleLabel.setText(t);
        this.midasDisplay.setTitle(t);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    private void initComponents() {
        this.optionsMenu = new JPopupMenu();
        this.pushMenuItem = new JMenuItem();
        this.popMenuItem = new JMenuItem();
        this.midasDisplay = new MidasDisplay();
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.pushPopButton = new JButton();
        this.optionsButton = new JButton();
        this.pushMenuItem.setText("Push");
        this.pushMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushPopPanel.this.pushMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.pushMenuItem);
        this.popMenuItem.setText("Pop");
        this.popMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushPopPanel.this.popMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.popMenuItem);
        this.setLayout(new BorderLayout());
        this.midasDisplay.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.midasDisplay, "Center");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new BorderLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("  ----  TITLE  ----  ");
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setVerticalTextPosition(3);
        this.titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PushPopPanel.this.titleLabelMousePressed(evt);
            }
        });
        this.jPanel1.add((Component)this.titleLabel, "Center");
        this.pushPopButton.setText("X");
        this.pushPopButton.setToolTipText("Push/Pop");
        this.pushPopButton.setBorderPainted(false);
        this.pushPopButton.setContentAreaFilled(false);
        this.pushPopButton.setFocusable(false);
        this.pushPopButton.setHorizontalTextPosition(0);
        this.pushPopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushPopPanel.this.pushPopButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.pushPopButton, "East");
        this.optionsButton.setText("V");
        this.optionsButton.setToolTipText("Options");
        this.optionsButton.setBorderPainted(false);
        this.optionsButton.setContentAreaFilled(false);
        this.optionsButton.setFocusable(false);
        this.optionsButton.setHorizontalTextPosition(0);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushPopPanel.this.optionsButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.optionsButton, "West");
        this.add((Component)this.jPanel1, "North");
    }

    private void pushPopButtonActionPerformed(ActionEvent evt) {
        MWindow mw = this.midasDisplay.getMWindow();
        if (mw != null) {
            mw.pop(-1);
        }
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        this.optionsMenu.show(this.optionsButton, 0, 0);
        Point p = this.optionsButton.getLocationOnScreen();
        this.optionsMenu.setLocation(p.x, p.y + this.optionsButton.getHeight());
        MWindow mw = this.midasDisplay.getMWindow();
        if (mw != null) {
            boolean popped = mw.isPopped();
            for (Component c : this.optionsMenu.getComponents()) {
                if (!(c instanceof JMenuItem)) continue;
                JMenuItem jmi = (JMenuItem)c;
                if (jmi == this.pushMenuItem) {
                    jmi.setEnabled(popped);
                    continue;
                }
                jmi.setEnabled(!popped);
            }
        }
    }

    private void pushMenuItemActionPerformed(ActionEvent evt) {
        MWindow mw = this.midasDisplay.getMWindow();
        if (mw != null) {
            mw.pop(0);
        }
    }

    private void popMenuItemActionPerformed(ActionEvent evt) {
        MWindow mw = this.midasDisplay.getMWindow();
        if (mw != null) {
            mw.pop(1);
        }
    }

    private void titleLabelMousePressed(MouseEvent evt) {
    }
}

