/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasColor;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Position;
import nxm.sys.lib.PredicateType;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.LayerT5;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Pix;
import nxm.sys.libg.Symbol;

public class Point3D {
    String name = "";
    private String note = "";
    int indexInRegion;
    int indexInPointsObject;
    boolean posSet = false;
    int distFromCurrentPix = -1;
    double posAlt = 0.0;
    double posLat = 0.0;
    double posLon = 0.0;
    boolean pospSet = false;
    double pospAlt = 0.0;
    double pospLat = 0.0;
    double pospLon = 0.0;
    boolean elpsSet = false;
    double elpsSemiMajor = 0.0;
    double elpsSemiMinor = 0.0;
    double elpsTilt = 0.0;
    boolean ellipsoidSet = false;
    double ellipsoidSemiMajor = 0.0;
    double ellipsoidSemiMinor = 0.0;
    double ellipsoidSemiMedian = 0.0;
    double ellipsoidRotationX = 0.0;
    double ellipsoidRotationY = 0.0;
    double ellipsoidRotationZ = 0.0;
    boolean coneSet = false;
    double coneA = 0.0;
    double coneB = 0.0;
    double coneAngle = 0.0;
    boolean conn = false;
    float hdg = 0.0f;
    byte flagNameLen = 0;
    byte flagNamePos = 0;
    byte flagFgColor = 0;
    byte flagBgColor = 0;
    byte flagCone = 0;
    byte flagInvert = 0;
    byte flagSymCode = 0;
    byte flagSymSize = 0;
    int _ixPos = 0;
    int _iyPos = 0;
    int _ixPosp = 0;
    int _iyPosp = 0;
    private double[] coords = null;
    double minLon = 0.0;
    double maxLon = 0.0;
    double minLat = 0.0;
    double maxLat = 0.0;
    double minAlt = 0.0;
    double maxAlt = 0.0;
    double minX = 0.0;
    double maxX = 0.0;
    double minY = 0.0;
    double maxY = 0.0;
    Symbol symbol = null;
    String symbolName = "";
    private double lonNormalization = 0.0;
    private double latNormalization = 0.0;
    double xRangeMax = 0.0;
    double yRangeMax = 0.0;
    double zRangeMax = 0.0;
    private boolean hidden;
    @InternalUseOnly
    public int xIndexInRegionsArray = -1;
    @InternalUseOnly
    public int yIndexInRegionsArray = -1;
    public LayerT5 layer;
    double time = 0.0;
    Color directColor = null;
    Color highlightColor = null;
    boolean visibleHighlight = false;
    Object metadata = null;
    Table filterDataTable = new Table();
    private MPlot MP;
    private boolean isGeodeticData = true;
    boolean in2DViewRange = false;

    Point3D(LayerT5 layer) {
        this.coords = new double[6];
        if (layer != null) {
            this.setLayerFields(layer);
        }
    }

    Point3D(Table tbl, LayerT5 layer) {
        this(layer);
        this.fromTable(tbl);
        if (layer != null) {
            this.setLayerFields(layer);
        }
    }

    private void setLayerFields(LayerT5 layer) {
        this.layer = layer;
        this.MP = layer.getMPlot();
        this.isGeodeticData = layer.isGeodeticData();
    }

    void prep(boolean doPosp) {
        int k = 0;
        if (doPosp) {
            k = this.MP.viewer.rwc2pix(this.coords, 0, 3, 2, this.layer.pix);
            this._ixPosp = this.layer.pix.x[1];
            this._iyPosp = this.layer.pix.y[1];
        } else {
            k = this.MP.viewer.rwc2pix(this.coords, 0, 3, 1, this.layer.pix);
        }
        this.hidden = this.MP.view == 13 && k < 1;
        this._ixPos = this.layer.pix.x[0];
        this._iyPos = this.layer.pix.y[0];
    }

    void done() {
    }

    boolean hit(double lon1, double lon2, double lat1, double lat2) {
        if (this.coneSet) {
            return true;
        }
        if (lat2 < this.minLat || lat1 > this.maxLat) {
            return false;
        }
        if (lon2 < this.minLon || lon1 > this.maxLon) {
            if (this.MP.view != 14 || !this.MP.hasExtendedRange()) {
                return false;
            }
            if (lon2 < this.minLon + (double)MPlot.LONGITUDE_RANGE || lon1 > this.maxLon + (double)MPlot.LONGITUDE_RANGE) {
                return false;
            }
        }
        return true;
    }

    private void updateMinMax() {
        double rad;
        this.minLon = this.posLon;
        this.maxLon = this.posLon;
        this.minLat = this.posLat;
        this.maxLat = this.posLat;
        this.minAlt = this.posAlt;
        this.maxAlt = this.posAlt;
        this.minX = this.minLon;
        this.maxX = this.maxLon;
        this.minY = this.minLat;
        this.minY = this.maxLat;
        if (this.pospSet) {
            this.minLon = Math.min(this.minLon, this.pospLon);
            this.maxLon = Math.max(this.maxLon, this.pospLon);
            this.minLat = Math.min(this.minLat, this.pospLat);
            this.maxLat = Math.max(this.maxLat, this.pospLat);
            this.minAlt = Math.min(this.minAlt, this.pospAlt);
            this.maxAlt = Math.max(this.maxAlt, this.pospAlt);
            this.minX = this.minLon;
            this.maxX = this.maxLon;
            this.minY = this.minLat;
            this.minY = this.maxLat;
        }
        if (this.elpsSet) {
            rad = Math.max(this.elpsSemiMajor, this.elpsSemiMinor);
            double radLat = rad * 8.983152841195214E-6 * 2.0;
            double radLon = rad * 8.983152841195214E-6 * 2.0;
            this.minLon = Math.min(this.minLon, this.posLon - radLon);
            this.maxLon = Math.max(this.maxLon, this.posLon + radLon);
            this.minLat = Math.min(this.minLat, this.posLat - radLat);
            this.maxLat = Math.max(this.maxLat, this.posLat + radLat);
            this.minX = Math.min(this.minX, this.posLon - radLon);
            this.maxX = Math.min(this.maxX, this.posLon + radLon);
            this.minY = Math.min(this.minY, this.posLat - radLat);
            this.maxY = Math.min(this.maxY, this.posLat + radLat);
        }
        if (this.ellipsoidSet) {
            rad = Math.max(Math.max(this.ellipsoidSemiMajor, this.ellipsoidSemiMinor), this.ellipsoidSemiMedian);
            double deg = rad * 8.983152841195214E-6;
            this.minLon = Math.min(this.minLon, this.posLon - deg);
            this.maxLon = Math.max(this.maxLon, this.posLon + deg);
            this.minLat = Math.min(this.minLat, this.posLat - deg);
            this.maxLat = Math.max(this.maxLat, this.posLat + deg);
            this.minAlt = Math.min(this.minAlt, this.posAlt - rad);
            this.maxAlt = Math.max(this.maxAlt, this.posAlt + rad);
            this.minX = Math.min(this.minX, this.posLon - rad);
            this.maxX = Math.min(this.maxX, this.posLon + rad);
            this.minY = Math.min(this.minY, this.posLat - rad);
            this.maxY = Math.min(this.maxY, this.posLat + rad);
        }
        this.xRangeMax = Math.max(this.maxX, Math.abs(this.minX));
        this.yRangeMax = Math.max(this.maxY, Math.abs(this.minY));
        this.zRangeMax = Math.max(this.maxAlt, Math.abs(this.minAlt));
        this.layer.updateRange(this);
    }

    Pix getPosPix(Pix p) {
        double[] pos = new double[]{this.posLon, this.posLat, this.posAlt};
        this.MP.viewer.rwc2pix(pos, 0, 3, 1, p);
        return p;
    }

    private Pix getPospPix(Pix p) {
        double[] posp = new double[]{this.pospLon, this.pospLat, this.pospAlt};
        this.MP.viewer.rwc2pix(posp, 0, 3, 1, p);
        return p;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNote() {
        return this.note;
    }

    boolean getConn() {
        return this.conn;
    }

    void setConn(boolean conn) {
        this.conn = conn;
    }

    void setConn(byte conn) {
        this.conn = conn == 1;
    }

    float getHdg() {
        return this.hdg;
    }

    void setHdg(float hdg) {
        this.hdg = hdg;
    }

    private void setConn(Object obj) {
        if (obj instanceof Data) {
            obj = this.toArray(obj, new byte[1]);
        }
        if (obj instanceof byte[]) {
            this.setConn(((byte[])obj)[0] != 0);
        } else if (obj != null) {
            this.setConn(Convert.s2state(obj.toString(), this.conn));
        }
    }

    void setDirectColor(Object obj) {
        this.directColor = MidasColor.getColor(obj);
    }

    Color getColor() {
        return this.directColor;
    }

    void setColor(Object obj) {
        this.directColor = MidasColor.getColor(obj);
    }

    Color getDirectColor() {
        return this.directColor;
    }

    public void setPos(double alt, double lat, double lon) {
        if (this.isGeodeticData) {
            this.lonNormalization = 0.0;
            this.latNormalization = 0.0;
            while (lon > (double)MPlot.LONGITUDE_DEFAULT_MAX) {
                lon -= (double)MPlot.LONGITUDE_RANGE;
                this.lonNormalization -= (double)MPlot.LONGITUDE_RANGE;
            }
            while (lon < (double)MPlot.LONGITUDE_DEFAULT_MIN) {
                lon += (double)MPlot.LONGITUDE_RANGE;
                this.lonNormalization += (double)MPlot.LONGITUDE_RANGE;
            }
            while (lat > (double)MPlot.LATITUDE_DEFAULT_MAX) {
                lat -= (double)MPlot.LATITUDE_RANGE;
                this.latNormalization -= (double)MPlot.LATITUDE_RANGE;
            }
            while (lat < (double)MPlot.LATITUDE_DEFAULT_MIN) {
                lat += (double)MPlot.LATITUDE_RANGE;
                this.latNormalization += (double)MPlot.LATITUDE_RANGE;
            }
        }
        this.coords[0] = this.posLon = lon;
        this.coords[1] = this.posLat = lat;
        this.coords[2] = this.posAlt = alt;
        this.posSet = true;
        this.updateMinMax();
    }

    private void setPos(Object obj) {
        if (obj instanceof Table) {
            this.setPos((Table)obj);
        }
        if (obj instanceof Position) {
            this.setPos((Position)obj);
        }
        if (obj instanceof Data) {
            obj = this.toArray(obj, new double[3]);
        }
        if (obj instanceof double[]) {
            this.setPos((double[])obj);
        }
    }

    public void setPos(Table t) {
        if (t.containsKey("LON") || !t.containsKey("X")) {
            this.setPos(t.getD("ALT", this.posAlt), t.getD("LAT", this.posLat), t.getD("LON", this.posLon));
        } else {
            this.setPos(t.getD("Z", this.posAlt), t.getD("Y", this.posLat), t.getD("X", this.posLon));
        }
    }

    public void setPos(Position p) {
        this.setPos(p.getAlt(), p.getLat(), p.getLon());
    }

    public void setPos(double[] a) {
        this.setPos(a[2], a[1], a[0]);
    }

    public Position getPos() {
        return Position.fromGeo(this.posAlt, this.posLat, this.posLon);
    }

    public void setPosp(double alt, double lat, double lon) {
        if (this.isGeodeticData) {
            lon += this.lonNormalization;
            lat += this.latNormalization;
        }
        this.coords[3] = this.pospLon = lon;
        this.coords[4] = this.pospLat = lat;
        this.coords[5] = this.pospAlt = alt;
        this.pospSet = this.layer.bVec == -1;
        this.updateMinMax();
    }

    private void setPosp(Object obj) {
        if (obj instanceof Table) {
            this.setPosp((Table)obj);
        }
        if (obj instanceof Position) {
            this.setPosp((Position)obj);
        }
        if (obj instanceof double[]) {
            this.setPosp((double[])obj);
        }
    }

    public void setPosp(Table t) {
        if (t.containsKey("LON") || !t.containsKey("X")) {
            this.setPosp(t.getD("ALT", this.pospAlt), t.getD("LAT", this.pospLat), t.getD("LON", this.pospLon));
        } else {
            this.setPosp(t.getD("Z", this.pospAlt), t.getD("Y", this.pospLat), t.getD("X", this.pospLon));
        }
    }

    public void setPosp(Position p) {
        this.setPosp(p.getAlt(), p.getLat(), p.getLon());
    }

    public void setPosp(double[] a) {
        this.setPosp(a[2], a[1], a[0]);
    }

    public Position getPosp() {
        return Position.fromGeo(this.pospAlt, this.pospLat, this.pospLon);
    }

    void setFlags(Object flags) {
        if (flags instanceof Data) {
            flags = this.toArray(flags, new byte[8]);
        }
        if (flags instanceof byte[]) {
            this.setFlags((byte[])flags);
        }
        if (flags instanceof Table) {
            this.setFlags((Table)flags, (byte)this.name.length());
        }
    }

    private void setFlags(byte[] flags) {
        this.flagNameLen = flags[0];
        this.flagNamePos = flags[1];
        this.flagFgColor = flags[2];
        this.flagBgColor = flags[3];
        this.flagCone = flags[4];
        this.flagInvert = flags[5];
        this.flagSymCode = flags[6];
        this.flagSymSize = flags[7];
    }

    void setFlagNameLen(byte val) {
        this.flagNameLen = val;
    }

    void setFlagNamePos(byte val) {
        this.flagNamePos = val;
    }

    void setFlagFgColor(byte val) {
        this.flagFgColor = val;
    }

    void setFlagBgColor(byte val) {
        this.flagBgColor = val;
    }

    void setFlagCone(byte val) {
        this.flagCone = val;
    }

    void setFlagInvert(byte val) {
        this.flagInvert = val;
    }

    void setFlagSymCode(byte val) {
        this.flagSymCode = val;
    }

    void setFlagSymSize(byte val) {
        this.flagSymSize = val;
    }

    byte getFlagNameLen() {
        return this.flagNameLen;
    }

    byte getFlagNamePos() {
        return this.flagNamePos;
    }

    byte getFlagFgColor() {
        return this.flagFgColor;
    }

    byte getFlagBgColor() {
        return this.flagBgColor;
    }

    byte getFlagCone() {
        return this.flagCone;
    }

    byte getFlagInvert() {
        return this.flagInvert;
    }

    byte getFlagSymCode() {
        return this.flagSymCode;
    }

    byte getFlagSymSize() {
        return this.flagSymSize;
    }

    private void setFlags(Table t) {
        this.setFlags(t, this.flagNameLen);
    }

    private void setFlags(Table tab, byte nameLen) {
        this.flagNameLen = tab.getB("NAMELEN", nameLen);
        this.flagNamePos = tab.getB("NAMEPOS", this.flagNamePos);
        this.flagFgColor = tab.getB("COLOR", this.flagFgColor);
        this.flagBgColor = tab.getB("BGCOLOR", this.flagBgColor);
        this.flagCone = tab.getB("CONE", this.flagCone);
        this.flagInvert = tab.getB("INVERT", this.flagInvert);
        this.flagSymCode = tab.getB("SYMBOLID", this.flagSymCode);
        this.flagSymSize = tab.getB("SYMBOLSIZE", this.flagSymSize);
    }

    private Data getFlagsData() {
        byte[] array = new byte[]{this.flagNameLen, this.flagNamePos, this.flagFgColor, this.flagBgColor, this.flagCone, this.flagInvert, this.flagSymCode, this.flagSymSize};
        return new Data(array);
    }

    private Object toArray(Object obj, Object array) {
        Data data = (Data)obj;
        data.toArray(array);
        return array;
    }

    private void setEllipsoid(Object obj) {
        if (obj instanceof Table) {
            this.setEllipsoid((Table)obj);
        }
        if (obj instanceof Data) {
            obj = this.toArray(obj, new double[3]);
        }
        if (obj instanceof double[]) {
            this.setEllipsoid((double[])obj);
        }
    }

    private void setEllipsoid(Table t) {
        double semiMajor = t.containsKey("SEMIMAJOR") ? t.getD("SEMIMAJOR") : t.getD("AXIS1");
        double semiMinor = t.containsKey("SEMIMINOR") ? t.getD("SEMIMINOR") : t.getD("AXIS2");
        double semiMedian = t.containsKey("SEMIMEDIAN") ? t.getD("SEMIMEDIAN") : t.getD("AXIS3");
        double rotationX = t.containsKey("ROTATION_X") ? t.getD("ROTATION_X") : t.getD("ANGLE1");
        double rotationY = t.containsKey("ROTATION_Y") ? t.getD("ROTATION_Y") : t.getD("ANGLE2");
        double rotationZ = t.containsKey("ROTATION_Z") ? t.getD("ROTATION_Z") : t.getD("ANGLE3");
        this.setEllipsoid(semiMajor, semiMinor, semiMedian, rotationX, rotationY, rotationZ);
    }

    void setEllipsoid(double semiMajor, double semiMinor, double semiMedian, double rotationX, double rotationY, double rotationZ) {
        this.ellipsoidSemiMajor = semiMajor;
        this.ellipsoidSemiMinor = semiMinor;
        this.ellipsoidSemiMedian = semiMedian;
        this.ellipsoidRotationX = rotationX;
        this.ellipsoidRotationY = rotationY;
        this.ellipsoidRotationZ = rotationZ;
        this.ellipsoidSet = true;
        this.updateMinMax();
    }

    private Data getEllipsoidData() {
        double[] array = new double[]{this.ellipsoidSemiMajor, this.ellipsoidSemiMinor, this.ellipsoidSemiMedian, this.ellipsoidRotationX, this.ellipsoidRotationY, this.ellipsoidRotationZ};
        return new Data(array);
    }

    private Data getEllipsoidAxes() {
        double[] array = new double[]{this.ellipsoidSemiMajor, this.ellipsoidSemiMinor, this.ellipsoidSemiMedian};
        return new Data(array);
    }

    private Data getEllipsoidRotation() {
        double[] array = new double[]{this.ellipsoidRotationX, this.ellipsoidRotationY, this.ellipsoidRotationZ};
        return new Data(array);
    }

    private void setElps(Table t) {
        this.setElps(t.getD("SEMIMAJOR", this.elpsSemiMajor), t.getD("SEMIMINOR", this.elpsSemiMinor), t.getD("TILT", this.elpsTilt));
    }

    public void setElps(double semiMajor, double semiMinor, double tilt) {
        this.elpsSemiMajor = semiMajor;
        this.elpsSemiMinor = semiMinor;
        this.elpsTilt = tilt;
        this.elpsSet = true;
        this.updateMinMax();
    }

    public void setElps(double[] a) {
        this.setElps(a[0], a[1], a[2]);
    }

    private void setElps(Object obj) {
        if (obj instanceof Table) {
            this.setElps((Table)obj);
        }
        if (obj instanceof Data) {
            obj = this.toArray(obj, new double[3]);
        }
        if (obj instanceof double[]) {
            this.setElps((double[])obj);
        }
    }

    public void setCone(double a, double b, double angle) {
        this.coneA = a;
        this.coneB = b;
        this.coneAngle = angle;
        this.coneSet = true;
        this.updateMinMax();
    }

    private Data getElpsData() {
        double[] array = new double[]{this.elpsSemiMajor, this.elpsSemiMinor, this.elpsTilt};
        return new Data(array);
    }

    public void setCone(double[] a) {
        this.setCone(a[0], a[1], a[2]);
    }

    public double getTime() {
        return this.time;
    }

    void setTime(double time) {
        this.time = time;
    }

    void setTime(Object obj) {
        if (obj instanceof Data) {
            this.setTime(((Data)obj).toD());
        }
        if (obj instanceof double[]) {
            this.setTime((double[])obj);
        }
    }

    Object getMetadata() {
        return this.metadata;
    }

    void setMetadata(Object metadata) {
        String tableStr;
        if (metadata != null && metadata instanceof String && (tableStr = ((String)metadata).trim()).startsWith("{") && tableStr.endsWith("}")) {
            int mode = Table.getDefaultModeInt();
            int flags = Table.getDefaultFlagsInt() + 1024;
            try {
                Table metaTable = new Table(mode, flags);
                metaTable.fromBytes(tableStr.getBytes(), 0, tableStr.length());
                if (metaTable != null) {
                    metadata = metaTable;
                }
            }
            catch (MidasException midasException) {
                // empty catch block
            }
        }
        this.metadata = metadata;
    }

    void setSymbol(String symName) {
        this.symbolName = symName;
        this.symbol = Symbol.getSymbol(this.symbolName);
        if (this.pospSet) {
            double latDelta = this.pospLat - this.posLat;
            double lonDelta = this.pospLon - this.posLon;
            double radians = Math.atan2(latDelta, lonDelta);
            double angle = Math.toDegrees(radians);
            float heading = (float)(90.0 - angle);
            this.symbol.setHeading(heading);
            double hypSquare = latDelta * latDelta + lonDelta * lonDelta;
            this.symbol.setSize((int)(Math.sqrt(hypSquare) * 2.0));
        }
    }

    void setFilterDataTable(boolean addName, boolean addPos, boolean addPosp, boolean addElps, boolean addCone, boolean addTime, boolean addNote, boolean addMeta) {
        Table pospTable;
        Table posTable;
        this.filterDataTable.clear();
        if (addName && this.name != null && !this.name.isEmpty()) {
            this.filterDataTable.put("NAME", (Object)this.getName());
        }
        if (this.isGeodeticData) {
            if (addPos && this.posSet) {
                posTable = new Table();
                posTable.put("LAT", this.posLat);
                posTable.put("LON", this.posLon);
                posTable.put("ALT", this.posAlt);
                this.filterDataTable.put("POS", (Object)posTable);
            }
            if (addPosp && this.pospSet) {
                pospTable = new Table();
                pospTable.put("LAT", this.pospLat);
                pospTable.put("LON", this.pospLon);
                pospTable.put("ALT", this.pospAlt);
                this.filterDataTable.put("POSP", (Object)pospTable);
            }
        } else {
            if (addPos && this.posSet) {
                posTable = new Table();
                posTable.put("X", this.posLon);
                posTable.put("Y", this.posLat);
                posTable.put("Z", this.posAlt);
                this.filterDataTable.put("POS", (Object)posTable);
            }
            if (addPosp && this.pospSet) {
                pospTable = new Table();
                pospTable.put("X", this.pospLon);
                pospTable.put("Y", this.pospLat);
                pospTable.put("Z", this.pospAlt);
                this.filterDataTable.put("POSP", (Object)pospTable);
            }
        }
        if (addElps && this.elpsSet) {
            Table elpsTable = new Table();
            elpsTable.put("MAJOR", this.elpsSemiMajor);
            elpsTable.put("MINOR", this.elpsSemiMinor);
            elpsTable.put("TILT", this.elpsTilt);
            this.filterDataTable.put("ELPS", (Object)elpsTable);
        }
        if (addCone && this.coneSet) {
            Table coneTable = new Table();
            coneTable.put("A", this.coneA);
            coneTable.put("B", this.coneB);
            coneTable.put("ANGLE", this.coneAngle);
            this.filterDataTable.put("CONE", (Object)coneTable);
        }
        if (addTime && this.time > 0.0) {
            this.filterDataTable.put("TIME", this.time);
        }
        if (addNote && this.note != null && !this.note.isEmpty()) {
            this.filterDataTable.put("NOTE", (Object)this.note);
        }
        if (addMeta && this.metadata != null) {
            if (!(this.metadata instanceof Table)) {
                this.filterDataTable.put("METADATA", this.metadata);
            } else {
                this.filterDataTable.addIfNotPresent((Table)this.metadata);
            }
        }
    }

    public Table getFilterDataTable() {
        return this.filterDataTable;
    }

    private void setCone(Object obj) {
        if (obj instanceof Data) {
            obj = this.toArray(obj, new double[3]);
        }
        if (obj instanceof double[]) {
            this.setCone((double[])obj);
        }
    }

    private Data getConnData() {
        return this.conn ? new Data(1) : new Data(0);
    }

    private Data getConeData() {
        double[] array = new double[]{this.coneA, this.coneB, this.coneAngle};
        return new Data(array);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Table toTable() {
        if (!this.isGeodeticData) {
            return this.toXYZTable();
        }
        Table table = new Table();
        if (this.name != null && !this.name.isEmpty()) {
            table.put("NAME", (Object)this.getName());
        }
        if (this.note != null && !this.note.isEmpty()) {
            table.put("NOTE", (Object)this.note);
        }
        table.put("CONN", (Object)this.getConnData());
        table.put("POS", (Object)this.getPos());
        if (this.pospSet) {
            table.put("POSP", (Object)this.getPosp());
        }
        if (this.elpsSet) {
            table.put("ELPS", (Object)this.getElpsData());
        }
        if (this.ellipsoidSet) {
            table.put("ELLIPSOID", (Object)this.getEllipsoidData());
        }
        table.put("CONE", (Object)this.getConeData());
        table.put("FLAG", (Object)this.getFlagsData());
        table.put("TIME", (Object)Time.toString(this.time, 1, 6));
        if (this.symbol != null) {
            table.put("SYMBOL", (Object)this.symbolName);
        }
        if (this.metadata != null) {
            table.put("METADATA", this.metadata);
        }
        if (this.layer != null && this.layer.name != null) {
            table.put("LAYER", (Object)this.layer.name);
        }
        return table;
    }

    Table toXYZTable() {
        Table table = new Table();
        if (this.name != null && !this.name.isEmpty()) {
            table.put("NAME", (Object)this.getName());
        }
        if (this.note != null && !this.note.isEmpty()) {
            table.put("NOTE", (Object)this.note);
        }
        Table posTbl = new Table("{X=" + this.posLon + ",Y=" + this.posLat + ",Z=" + this.posAlt + "}");
        table.put("POS", (Object)posTbl);
        if (this.pospSet) {
            Table pospTbl = new Table("{X=" + this.pospLon + ",Y=" + this.pospLat + ",Z=" + this.pospAlt + "}");
            table.put("POSP", (Object)pospTbl);
        }
        if (this.elpsSet) {
            table.put("ELPS", (Object)this.getElpsData());
        }
        if (this.ellipsoidSet) {
            table.put("ELLIPSOID", (Object)this.getEllipsoidData());
        }
        if (this.coneSet) {
            table.put("CONE", (Object)this.getConeData());
        }
        if (this.time > 0.0) {
            table.put("TIME", (Object)Time.toString(this.time, 1, 6));
        }
        if (this.symbol != null) {
            table.put("SYMBOL", (Object)this.symbolName);
        }
        if (this.metadata != null) {
            table.put("METADATA", this.metadata);
        }
        return table;
    }

    void fromTable(Table tbl) {
        if (tbl.containsKey("NAME")) {
            this.setName(tbl.getS("NAME", this.name));
        }
        if (tbl.containsKey("NOTE")) {
            this.setNote(tbl.getS("NOTE", this.note));
        }
        if (tbl.containsKey("CONN")) {
            this.setConn(tbl.getKey("CONN"));
        }
        this.setPos(tbl.getKey("POS"));
        if (tbl.containsKey("POSP")) {
            this.setPosp(tbl.getKey("POSP"));
        }
        if (tbl.containsKey("FLAG")) {
            this.setFlags(tbl.getKey("FLAG"));
        }
        if (tbl.containsKey("ELLIPSOID")) {
            this.setEllipsoid(tbl.getKey("ELLIPSOID"));
        } else if (tbl.containsKey("ELPSOID")) {
            this.setEllipsoid(tbl.getKey("ELPSOID"));
        }
        if (tbl.containsKey("ELPS")) {
            this.setElps(tbl.getKey("ELPS"));
        }
        if (tbl.containsKey("CONE")) {
            this.setCone(tbl.getKey("CONE"));
        }
        if (tbl.containsKey("TIME")) {
            this.setTime(tbl.getKey("TIME"));
        }
        if (!tbl.containsKey("METADATA")) {
            String pipeSeparatedMetaNames = tbl.getS("METADATAFIELDS");
            if (pipeSeparatedMetaNames != null) {
                String[] metadataFieldNames = pipeSeparatedMetaNames == null || pipeSeparatedMetaNames.isEmpty() ? null : tbl.getS("METADATAFIELDS").split("\\|");
                this.layer.setMetadataFieldNames(metadataFieldNames);
                this.metadata = new Table();
                for (String field : metadataFieldNames) {
                    ((Table)this.metadata).put(field, tbl.getKey(field));
                }
            }
        } else {
            this.metadata = tbl.getKey("METADATA");
        }
        if (tbl.containsKey("COLOR")) {
            Object colorValue = tbl.get("COLOR");
            this.directColor = MidasColor.getColor(colorValue);
        }
        if (tbl.containsKey("SYMBOL")) {
            this.symbolName = tbl.getS("SYMBOL");
            this.symbol = Symbol.getSymbol(this.symbolName);
            if (tbl.containsKey("POSP")) {
                double latDelta = this.pospLat - this.posLat;
                double lonDelta = this.pospLon - this.posLon;
                double radians = Math.atan2(latDelta, lonDelta);
                double angle = Math.toDegrees(radians);
                float heading = (float)(90.0 - angle);
                this.symbol.setHeading(heading);
                double hypSquare = latDelta * latDelta + lonDelta * lonDelta;
                this.symbol.setSize((int)(Math.sqrt(hypSquare) * 2.0));
            }
        }
        this.updateMinMax();
    }

    public String toString() {
        return this.toTable().toString();
    }

    Table toPopupTable() {
        Table table = new Table();
        if (this.name != null && !this.name.isEmpty()) {
            table.put("NAME", (Object)this.getName());
        }
        if (this.isGeodeticData) {
            table.put("Pos Lat", this.posLat);
            table.put("Pos Lon", this.posLon);
            table.put("Pos Alt", this.posAlt);
            if (this.pospSet) {
                table.put("Posp Lat", this.pospLat);
                table.put("Posp Lon", this.pospLon);
                table.put("Posp Alt", this.pospAlt);
            }
        } else {
            String xlabel = this.layer.popupLabels.containsKey("POS.X") ? this.layer.popupLabels.getS("POS.X") : "Pos X";
            String ylabel = this.layer.popupLabels.containsKey("POS.Y") ? this.layer.popupLabels.getS("POS.Y") : "Pos Y";
            String zlabel = this.layer.popupLabels.containsKey("POS.Z") ? this.layer.popupLabels.getS("POS.Z") : "Pos Z";
            table.put(xlabel, this.posLon);
            table.put(ylabel, this.posLat);
            if (!zlabel.isEmpty()) {
                table.put(zlabel, this.posAlt);
            }
            if (this.pospSet) {
                xlabel = this.layer.popupLabels.containsKey("POSP.X") ? this.layer.popupLabels.getS("POSP.X") : "Posp X";
                ylabel = this.layer.popupLabels.containsKey("POSP.Y") ? this.layer.popupLabels.getS("POSP.Y") : "Posp Y";
                String string = zlabel = this.layer.popupLabels.containsKey("POSP.Z") ? this.layer.popupLabels.getS("POSP.Z") : "Posp Z";
                if (!xlabel.isEmpty()) {
                    table.put(xlabel, this.pospLon);
                }
                if (!ylabel.isEmpty()) {
                    table.put(ylabel, this.pospLat);
                }
                if (!zlabel.isEmpty()) {
                    table.put(zlabel, this.pospAlt);
                }
            }
        }
        if (this.elpsSet) {
            table.put("Ellipse Major", this.elpsSemiMajor);
            table.put("Ellipse Minor", this.elpsSemiMinor);
            table.put("Ellipse Tilt", this.elpsTilt);
        }
        if (this.ellipsoidSet) {
            table.put("Ellipsoid Axes ENU", (Object)this.getEllipsoidAxes());
            table.put("Ellipsoid Rotation ENU", (Object)this.getEllipsoidRotation());
        }
        if (this.coneSet) {
            table.put("Cone A", this.coneA);
            table.put("Cone B", this.coneB);
            table.put("Cone Angle", this.coneAngle);
        }
        if (this.time > 0.0) {
            table.put("Time", (Object)Time.toString(this.time, 1, 6));
        }
        if (this.note != null && !this.note.isEmpty()) {
            table.put("Note", (Object)this.note);
        }
        if (this.metadata != null) {
            table.put("Metadata", this.metadata);
        }
        if (this.layer != null && this.layer.name != null) {
            table.put("Layer", (Object)this.layer.getName());
        }
        return table;
    }

    public double getPosLat() {
        return this.posLat;
    }

    public double getPosLon() {
        return this.posLon;
    }

    public static List<Point3D> getPointsMatchingFilter(List<Point3D> points, Map<String, PredicateType> metaFilter) {
        ArrayList<Point3D> matchingPoints = new ArrayList<Point3D>();
        for (Point3D point : points) {
            if (!Point3D.passFilterTests(point, metaFilter)) continue;
            matchingPoints.add(point);
        }
        return matchingPoints;
    }

    private static boolean passFilterTests(Point3D point, Map<String, PredicateType> metaFilter) {
        for (String key : metaFilter.keySet()) {
            boolean passTest = PredicateType.passesFilter(metaFilter, key, point.filterDataTable.get(key));
            if (passTest) continue;
            return false;
        }
        return true;
    }
}

