/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;

public class MJTextArea
extends JTextArea
implements MessageHandler,
KeyListener {
    private static final long serialVersionUID = 2012020960311L;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_MJTEXTAREA_OBJECT_MESSAGE = "nxm.sys.libg.MJTextArea does NOT currently support Java Serialization";
    private transient MessageHandler mh;
    static final String lineSep = MJTextArea.getLineSep();

    private static String getLineSep() {
        try {
            return System.getProperty("line.separator");
        }
        catch (Exception e) {
            return "\n";
        }
    }

    public MJTextArea(String text) {
        this(text, 20, 80);
    }

    public MJTextArea(String text, int rows, int cols) {
        super(text, rows, cols);
        this.open(rows, cols);
        this.addKeyListener(this);
    }

    public void open(int rows, int cols) {
        Font font = new Font("monospaced", 0, 12);
        super.setRows(rows);
        super.setColumns(cols);
        super.setEditable(true);
        super.setEnabled(true);
        super.setFont(font);
        super.setLineWrap(true);
        super.setWrapStyleWord(true);
        Border outer = BorderFactory.createEtchedBorder(Theme.global().cwbh, Theme.global().cwbs);
        Border inner = BorderFactory.createEtchedBorder(Theme.global().cwbh, Theme.global().cwbs);
        super.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        this.enableEvents();
    }

    private void enableEvents() {
        this.enableEvents(16L);
        this.enableEvents(8L);
    }

    @Override
    public void processEvent(AWTEvent e) {
        if (e.getID() == 502) {
            InputEvent ie = (InputEvent)e;
            String msgName = null;
            if (!SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                if (SwingUtilities.isMiddleMouseButton((MouseEvent)e)) {
                    msgName = "MENU";
                } else if (SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                    msgName = "MENU";
                } else {
                    Shell.warning("Got an event, ? button ID = " + e.getID());
                }
            }
            if (this.mh != null && msgName != null) {
                this.mh.processMessage(new Message(msgName, 0, null, this.mh, this));
            }
        } else if (e.getID() == 501 && SwingUtilities.isMiddleMouseButton((MouseEvent)e)) {
            ((MouseEvent)e).consume();
        }
        super.processEvent(e);
    }

    public void setAttributes(MWindow mw) {
        super.setBackground(mw.theme.cbg);
        super.setForeground(mw.theme.cfg);
    }

    public void setAttributesGW(GWidget mw) {
        super.setBackground(mw.theme.cwbs);
        super.setForeground(mw.theme.cwfg);
    }

    public void setAttributes(Container panel2) {
        Color cb = panel2.getBackground();
        super.setBackground(cb);
        Color cf = panel2.getForeground();
        super.setForeground(cf);
    }

    public void setMessageHandler(MessageHandler mh) {
        this.mh = mh;
    }

    @Override
    public int processMessage(Message msg) {
        return this.processMessage(msg, null, null);
    }

    public int processMessage(Message msg, Object msgid, Object parent) {
        int stat = 1;
        if (!(msg.name.equals("MJTEXT.CFG") || msg.name.equals("AXIS") || msg.name.equals("MODE") || msg.name.equals("SCALE") || msg.name.equals("SCALERANGE") || msg.name.equals("OPTIONS"))) {
            stat = -1;
        }
        return stat;
    }

    public void appendLine(String str) {
        super.append(str + lineSep);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((e.getModifiersEx() & 0x80) != 0) {
            if (e.getKeyCode() == 88) {
                if (this.mh != null) {
                    this.mh.processMessage(new Message("TEXTBOX", 0, "CUT"));
                }
                e.consume();
            } else if (e.getKeyCode() == 67) {
                if (this.mh != null) {
                    this.mh.processMessage(new Message("TEXTBOX", 0, "COPY"));
                }
                e.consume();
            } else if (e.getKeyCode() == 86) {
                if (this.mh != null) {
                    this.mh.processMessage(new Message("TEXTBOX", 0, "PASTE"));
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void setRows(int rows) {
        if (rows <= 0) {
            throw new IllegalArgumentException("Invalid size given (" + rows + "), size must be no less than 0.");
        }
        this.setSize(this.getWidth(), rows * this.getFont().getSize());
    }

    @Override
    public void setColumns(int cols) {
        if (cols <= 0) {
            throw new IllegalArgumentException("Invalid size given (" + cols + "), size must be no less than 0.");
        }
        this.setSize(cols * this.getFont().getSize(), this.getHeight());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJTEXTAREA_OBJECT_MESSAGE);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJTEXTAREA_OBJECT_MESSAGE);
    }
}

