/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJList;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.Symbol;

@InternalUseOnly(value="since initial version")
public class MJListConfig
extends JPanel
implements MJPopup.HasValue {
    private final Midas midas;
    private final MJList mjlist;
    private final TemplateTableModel templTableModel;
    private final Table globalLayout;
    private final Table columnLayout;
    private Table template;
    private Table saveTemplate;
    private final GPrimitive list2;
    private JButton applyChanges;
    private JComboBox columnSelector;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JButton resetChanges;
    private JTable templateTable;

    public MJListConfig(Midas midas, GPrimitive list22, MJList mjlist) {
        Table tbl = Convert.o2t("nxm.sys.libg.MJListConfig.tbl", midas);
        this.midas = midas;
        this.list2 = list22;
        this.mjlist = mjlist;
        this.globalLayout = tbl.getTable("GLOBAL");
        this.columnLayout = tbl.getTable("COLUMN");
        this.templTableModel = new TemplateTableModel();
        this.saveTemplate = mjlist.getTemplate();
        this.template = mjlist.getTemplate();
        this.initComponents();
        JComboBox comboBox = new JComboBox();
        int height = Math.max(this.templateTable.getRowHeight(), comboBox.getPreferredSize().height);
        this.templateTable.setRowHeight(height);
        this.templateTable.setModel(this.templTableModel);
        this.templateTable.getColumnModel().getColumn(1).setCellRenderer(this.templTableModel);
        this.templateTable.getColumnModel().getColumn(1).setCellEditor(this.templTableModel);
        this.columnSelector.setModel(new DefaultComboBoxModel<String>(this.template.getKeys()));
        this.showTemplate("_GLOBAL_");
    }

    @Override
    public String getName() {
        return "MJList";
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public int getInfo() {
        return 0;
    }

    private void refreshTemplate() {
        this.template = this.mjlist.getTemplate();
        this.showTemplate(this.columnSelector.getSelectedItem().toString());
    }

    private void showTemplate(String col) {
        if (col.equals("_GLOBAL_")) {
            this.templTableModel.setLayout(this.globalLayout);
        } else {
            this.templTableModel.setLayout(this.columnLayout);
        }
        this.templTableModel.setValues(this.template.getTable(col));
        this.columnSelector.setSelectedItem(col);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.columnSelector = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.templateTable = new JTable();
        this.applyChanges = new JButton();
        this.resetChanges = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1.setText("Show Template For:");
        this.columnSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJListConfig.this.columnSelectorActionPerformed(evt);
            }
        });
        this.templateTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.templateTable.setAutoResizeMode(4);
        this.templateTable.setRowSelectionAllowed(false);
        this.jScrollPane1.setViewportView(this.templateTable);
        this.applyChanges.setText("Apply");
        this.applyChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJListConfig.this.applyChangesActionPerformed(evt);
            }
        });
        this.resetChanges.setText("Reset");
        this.resetChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJListConfig.this.resetChangesActionPerformed(evt);
            }
        });
        this.jPanel3.setLayout(new GridLayout(1, 0, 4, 0));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jScrollPane1, -1, 379, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.resetChanges).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyChanges)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(172, 172, 172).addComponent(this.jPanel3, -1, 105, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnSelector, 0, 265, Short.MAX_VALUE))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 22, -2).addComponent(this.columnSelector, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyChanges).addComponent(this.resetChanges)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
    }

    private void resetChangesActionPerformed(ActionEvent evt) {
        this.mjlist.setTemplate(this.saveTemplate);
        this.refreshTemplate();
    }

    private void applyChangesActionPerformed(ActionEvent evt) {
        this.mjlist.setTemplate(this.template);
        this.refreshTemplate();
    }

    private void columnSelectorActionPerformed(ActionEvent evt) {
        this.showTemplate(this.columnSelector.getSelectedItem().toString());
    }

    private class TemplateTableModel
    extends AbstractTableModel
    implements TableCellRenderer,
    TableCellEditor {
        private final Icon SELECTED = new Symbol.CheckBox(true);
        private final Icon DESELECTED = new Symbol.CheckBox(false);
        private DefaultTableCellRenderer cellRenderer;
        private DefaultCellEditor toggleEditor;
        private DefaultCellEditor textEditor;
        private TableCellEditor cellEditor;
        private String[] rowNames;
        private Table layout;
        private Table values;

        public TemplateTableModel() {
            this(null, null);
        }

        public TemplateTableModel(Table layout, Table values) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelectedIcon(this.SELECTED);
            checkBox.setDisabledIcon(this.DESELECTED);
            this.cellRenderer = new DefaultTableCellRenderer();
            this.toggleEditor = new DefaultCellEditor(checkBox);
            this.textEditor = new DefaultCellEditor(new JTextField());
            this.cellEditor = this.toggleEditor;
            this.setLayout(layout);
            this.setValues(values);
        }

        public Table getLayout() {
            return this.layout;
        }

        public void setLayout(Table layout) {
            if (layout == null) {
                layout = new Table();
            }
            if (this.layout != layout) {
                this.layout = layout;
                this.rowNames = layout.getKeys();
                this.fireTableDataChanged();
            }
        }

        public Table getValues() {
            return this.values;
        }

        public void setValues(Table values) {
            if (this.values != values) {
                this.values = values;
                this.fireTableDataChanged();
            }
        }

        private Table rowLayout(int row) {
            Table rowLayout = this.layout.getTable(this.rowNames[row]);
            return rowLayout == null ? new Table() : rowLayout;
        }

        @Override
        public int getRowCount() {
            return this.rowNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int c) {
            return c == 0 ? "TAG" : "VALUE";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && this.rowLayout(row).getState("EDITABLE", true);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object val = null;
            if (col == 0) {
                val = this.rowLayout(row).getO("LABEL");
                if (val == null) {
                    val = this.rowNames[row];
                }
            } else {
                if (this.values != null) {
                    val = this.values.getO(this.rowNames[row]);
                }
                if (val == null) {
                    val = this.rowLayout(row).getO("DEFVALUE");
                }
            }
            return val;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            if (col != 0) {
                if (this.values == null) {
                    this.values = new Table();
                }
                this.values.put(this.rowNames[row], val);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component comp = this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (comp instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)comp;
                String type = this.rowLayout(row).getS("TYPE");
                dtcr.setIcon(null);
                dtcr.setBackground(table.getBackground());
                dtcr.setForeground(table.getForeground());
                if (type != null) {
                    if (type.equals("TOGGLE")) {
                        if (value != null && StringUtil.isTrue(value.toString())) {
                            dtcr.setIcon(this.SELECTED);
                        } else {
                            dtcr.setIcon(this.DESELECTED);
                        }
                    } else if (type.equals("COLOR") && value != null && value.toString().length() > 0) {
                        Color color = MColor.getColor(value);
                        dtcr.setBackground(color);
                        dtcr.setForeground(new Color(~color.getRGB(), false));
                    }
                }
            }
            return comp;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return this.cellEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.cellEditor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.cellEditor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.cellEditor.removeCellEditorListener(l);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            String type = this.rowLayout(row).getS("TYPE");
            if (type == null || type.equals("TEXT")) {
                this.cellEditor = this.textEditor;
            } else if (type.equals("TOGGLE")) {
                this.cellEditor = this.toggleEditor;
            } else if (type.startsWith("CHOICE")) {
                String[] choices = this.rowLayout(row).getS("CHOICES", "").split("[,|]");
                JComboBox<String> comboBox = new JComboBox<String>(choices);
                if (type.indexOf("/E") > 0) {
                    comboBox.setEditable(true);
                }
                this.cellEditor = new DefaultCellEditor(comboBox);
            } else {
                this.cellEditor = this.textEditor;
            }
            return this.cellEditor.getTableCellEditorComponent(table, value, isSelected, row, col);
        }
    }
}

