/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.libg.MJPopup;

class MJFileChooser
extends JPanel
implements ActionListener,
MJPopup.HasValue {
    private static final long serialVersionUID = 2012012400311L;
    public static final String pathOptionList = "FullPath,NoPath,AuxPath,AuxQual";
    public static final int FULLPATH = 1;
    public static final int NOPATH = 2;
    public static final int AUXPATH = 3;
    public static final int AUXQUAL = 4;
    private static final String AUX_FILE_SEPARATOR = "/";
    private transient Midas midas;
    private String seedFilename;
    private String filter;
    private String name;
    private int pathOption;
    private DataListModel fileListModel = new DataListModel();
    private transient FileComparator comparator = new FileComparator();
    private JList<String> jAuxList;
    private JList<String> jFileList;
    private JPopupMenu jFilesPopupMenu;
    private JComboBox<String> jFilterComboBox;
    private JTextField jSelectedFilename;
    private JLabel msgLabel;

    public MJFileChooser(String name, Object msg, Object defValue, String filter, String selectedAuxList, String pathOpt, Midas midas) {
        this.name = name;
        this.midas = midas != null ? midas : Shell.getSharedMidasContext();
        this.seedFilename = defValue != null ? defValue.toString() : "";
        this.filter = filter != null ? filter : "*";
        this.pathOption = Parser.find(pathOptionList, pathOpt, 4, 0, 1);
        this.initComponents();
        this.updateAuxList(selectedAuxList);
        this.formNameList();
        this.msgLabel.setText(msg.toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getInfo() {
        return 0;
    }

    @Override
    public Object getValue() {
        return this.jSelectedFilename.getText();
    }

    public void refresh() {
        this.formNameList();
    }

    public String getSeedFilename() {
        return this.seedFilename;
    }

    public String getFilter() {
        return this.filter;
    }

    private ListModel<String> getFileListModel() {
        return this.fileListModel;
    }

    private ListModel<String> getAuxListModel() {
        DataListModel auxListModel;
        if (this.midas != null) {
            Object[] auxList = this.midas.io.getAuxList();
            Arrays.sort(auxList);
            auxListModel = new DataListModel((String[])auxList);
        } else {
            auxListModel = new DataListModel(null);
        }
        return auxListModel;
    }

    private void updateAuxList(String selectedAuxList) {
        if (this.midas != null) {
            ListModel<String> auxListModel = this.jAuxList.getModel();
            Object[] readAux = selectedAuxList != null ? selectedAuxList.split("[|,]") : new String[]{this.midas.io.getWriteAux()};
            Arrays.sort(readAux);
            this.jAuxList.clearSelection();
            for (int i = 0; i < auxListModel.getSize(); ++i) {
                String aux = auxListModel.getElementAt(i).toString();
                if (Arrays.binarySearch(readAux, aux) < 0) continue;
                this.jAuxList.addSelectionInterval(i, i);
            }
        }
    }

    private void formNameList() {
        String filter = this.jFilterComboBox.getSelectedItem() + "";
        int pos = filter.indexOf(46);
        String root = filter;
        String ext = "*";
        if (pos >= 0) {
            root = filter.substring(0, pos);
            ext = filter.substring(pos + 1);
        }
        this.fileListModel.removeAllElements();
        List<String> selectedAuxes = this.jAuxList.getSelectedValuesList();
        for (String aux : selectedAuxes) {
            String path = this.midas.io.getAuxPath(aux);
            String[] files = this.midas.io.listFiles(path, root, ext);
            if (files == null) continue;
            this.fileListModel.addElements(aux + AUX_FILE_SEPARATOR, files);
        }
        this.fileListModel.sortBy(this.comparator);
    }

    private void initComponents() {
        this.jFilesPopupMenu = new JPopupMenu();
        JMenuItem jRefreshMenuItem = new JMenuItem();
        JSeparator jSeparator1 = new JSeparator();
        JRadioButtonMenuItem jSortByAuxMenuItem = new JRadioButtonMenuItem();
        JRadioButtonMenuItem jSortByFilenameMenuItem = new JRadioButtonMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        JRadioButtonMenuItem jSortAscending = new JRadioButtonMenuItem();
        JRadioButtonMenuItem jSortDescending = new JRadioButtonMenuItem();
        ButtonGroup sortOptionGroup = new ButtonGroup();
        ButtonGroup sortOrderGroup = new ButtonGroup();
        JScrollPane auxListScrollPane = new JScrollPane();
        this.jAuxList = new JList();
        JScrollPane fileListScrollPane = new JScrollPane();
        this.jFileList = new JList();
        this.jSelectedFilename = new JTextField();
        this.jFilterComboBox = new JComboBox();
        JLabel jAuxLabel = new JLabel();
        JLabel jFilenameLabel = new JLabel();
        JLabel jFilterLabel = new JLabel();
        JLabel jFilesLabel = new JLabel();
        this.msgLabel = new JLabel();
        this.jFilesPopupMenu.setToolTipText("");
        this.jFilesPopupMenu.setLabel("hi");
        this.jFilesPopupMenu.setName("");
        jRefreshMenuItem.setText("Refresh List");
        jRefreshMenuItem.setToolTipText("Refresh Files List");
        jRefreshMenuItem.addActionListener(this);
        this.jFilesPopupMenu.add(jRefreshMenuItem);
        this.jFilesPopupMenu.add(jSeparator1);
        sortOptionGroup.add(jSortByAuxMenuItem);
        jSortByAuxMenuItem.setSelected(true);
        jSortByAuxMenuItem.setText("Sort By AUX");
        jSortByAuxMenuItem.setToolTipText("Sort By AUX, then Filename");
        jSortByAuxMenuItem.addActionListener(this);
        this.jFilesPopupMenu.add(jSortByAuxMenuItem);
        sortOptionGroup.add(jSortByFilenameMenuItem);
        jSortByFilenameMenuItem.setText("Sort By Filename");
        jSortByFilenameMenuItem.setToolTipText("Sort By Filename");
        jSortByFilenameMenuItem.addActionListener(this);
        this.jFilesPopupMenu.add(jSortByFilenameMenuItem);
        this.jFilesPopupMenu.add(jSeparator2);
        sortOrderGroup.add(jSortAscending);
        jSortAscending.setSelected(true);
        jSortAscending.setText("Ascending");
        jSortAscending.setToolTipText("Ascending Sort Order");
        jSortAscending.addActionListener(this);
        this.jFilesPopupMenu.add(jSortAscending);
        sortOrderGroup.add(jSortDescending);
        jSortDescending.setText("Descending");
        jSortDescending.setToolTipText("Descending Sort Order");
        jSortDescending.addActionListener(this);
        this.jFilesPopupMenu.add(jSortDescending);
        auxListScrollPane.setMaximumSize(this.jAuxList.getMaximumSize());
        auxListScrollPane.setMinimumSize(this.jAuxList.getMinimumSize());
        auxListScrollPane.setPreferredSize(this.jAuxList.getPreferredSize());
        this.jAuxList.setModel(this.getAuxListModel());
        this.jAuxList.setMaximumSize(new Dimension(50, 0));
        this.jAuxList.setMinimumSize(new Dimension(30, 40));
        this.jAuxList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MJFileChooser.this.jAuxListValueChanged(evt);
            }
        });
        auxListScrollPane.setViewportView(this.jAuxList);
        fileListScrollPane.setMaximumSize(this.jFileList.getMaximumSize());
        fileListScrollPane.setMinimumSize(this.jFileList.getMinimumSize());
        fileListScrollPane.setPreferredSize(this.jFileList.getPreferredSize());
        this.jFileList.setModel(this.getFileListModel());
        this.jFileList.setSelectionMode(0);
        this.jFileList.setMinimumSize(new Dimension(100, 40));
        this.jFileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MJFileChooser.this.displayPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MJFileChooser.this.displayPopupMenu(evt);
            }
        });
        this.jFileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MJFileChooser.this.jFileListValueChanged(evt);
            }
        });
        fileListScrollPane.setViewportView(this.jFileList);
        this.jSelectedFilename.setText(this.getSeedFilename());
        this.jFilterComboBox.setEditable(true);
        this.jFilterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.filter}));
        this.jFilterComboBox.setToolTipText("Filter Format =  *.extension1|extension2|extension3|...");
        jAuxLabel.setLabelFor(this.jAuxList);
        jAuxLabel.setText("AUXes");
        jAuxLabel.setToolTipText("AUX Selection List");
        jAuxLabel.setFocusable(false);
        jAuxLabel.setOpaque(true);
        jFilenameLabel.setLabelFor(this.jSelectedFilename);
        jFilenameLabel.setText("File Name");
        jFilterLabel.setLabelFor(this.jFilterComboBox);
        jFilterLabel.setText("Filter");
        jFilesLabel.setLabelFor(this.jFileList);
        jFilesLabel.setText("Files");
        jFilesLabel.setToolTipText("Files Selection List");
        this.msgLabel.setText("Message");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jFilenameLabel).addComponent(jFilterLabel).addComponent(auxListScrollPane, -1, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fileListScrollPane, -1, 241, Short.MAX_VALUE).addComponent(this.jFilterComboBox, GroupLayout.Alignment.TRAILING, 0, 241, Short.MAX_VALUE).addComponent(this.jSelectedFilename, GroupLayout.Alignment.TRAILING, -1, 241, Short.MAX_VALUE))).addComponent(this.msgLabel)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jAuxLabel, -1, 90, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jFilesLabel, -1, 232, Short.MAX_VALUE).addGap(21, 21, 21)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jAuxLabel).addComponent(jFilesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(fileListScrollPane, -1, 201, Short.MAX_VALUE).addComponent(auxListScrollPane, -1, 201, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jFilenameLabel).addComponent(this.jSelectedFilename, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jFilterComboBox, -2, -1, -2).addComponent(jFilterLabel)).addContainerGap()));
    }

    private void jFileListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            String filename;
            String selected = this.jFileList.getSelectedValue();
            if (selected == null) {
                return;
            }
            int index = selected.indexOf(AUX_FILE_SEPARATOR);
            String aux = selected.substring(0, index);
            String name = selected.substring(index + 1);
            String auxPath = this.midas == null ? "" : this.midas.io.getAuxPath(aux);
            switch (this.pathOption) {
                default: {
                    filename = auxPath + name;
                    break;
                }
                case 2: {
                    filename = name;
                    break;
                }
                case 3: {
                    filename = aux + AUX_FILE_SEPARATOR + name;
                    break;
                }
                case 4: {
                    filename = name + "{AUX=" + aux + "}";
                }
            }
            this.jSelectedFilename.setText(filename);
            this.jSelectedFilename.setColumns(filename.length());
        }
    }

    private void displayPopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jFilesPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jAuxListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.formNameList();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if (actionCommand.startsWith("Refresh")) {
            this.refresh();
        } else if (actionCommand.equals("Sort By Filename")) {
            if (!AUX_FILE_SEPARATOR.equals(this.comparator.skip)) {
                this.comparator.skip = AUX_FILE_SEPARATOR;
                this.fileListModel.sortBy(this.comparator);
            }
        } else if (actionCommand.equals("Sort By AUX")) {
            if (this.comparator.skip != null) {
                this.comparator.skip = null;
                this.fileListModel.sortBy(this.comparator);
            }
        } else if (actionCommand.equals("Ascending")) {
            if (!this.comparator.ascending) {
                this.comparator.ascending = true;
                this.fileListModel.sortBy(this.comparator);
            }
        } else if (actionCommand.equals("Descending")) {
            if (this.comparator.ascending) {
                this.comparator.ascending = false;
                this.fileListModel.sortBy(this.comparator);
            }
        } else {
            String message = "MJFileChooser: Unsupported ActionEvent=" + evt;
            if (this.midas != null) {
                this.midas.info(message);
            } else {
                Shell.info(message);
            }
        }
    }

    private static class DataListModel
    extends AbstractListModel<String> {
        private static final long serialVersionUID = 2012012100311L;
        private Vector<String> data = new Vector();

        public DataListModel() {
        }

        public DataListModel(String[] objects) {
            if (objects == null || objects.length <= 0) {
                return;
            }
            this.data.ensureCapacity(objects.length);
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                this.data.addElement(objects[i]);
            }
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public String getElementAt(int index) {
            if (index >= 0 && index < this.data.size()) {
                return this.data.elementAt(index);
            }
            return null;
        }

        public void addElement(String anObject) {
            this.data.addElement(anObject);
            this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
        }

        public void addElements(String[] objects) {
            if (objects == null || objects.length <= 0) {
                return;
            }
            int index0 = this.data.size();
            this.data.addAll(Arrays.asList(objects));
            this.fireIntervalAdded(this, index0, this.data.size() - 1);
        }

        public void addElements(String prefix, String[] strings) {
            if (strings == null || strings.length <= 0) {
                return;
            }
            int index0 = this.data.size();
            int len = strings.length;
            for (int i = 0; i < len; ++i) {
                this.data.addElement(prefix + strings[i]);
            }
            this.fireIntervalAdded(this, index0, this.data.size() - 1);
        }

        public void removeAllElements() {
            if (this.data.size() > 0) {
                int lastIndex = this.data.size() - 1;
                this.data.removeAllElements();
                this.fireIntervalRemoved(this, 0, lastIndex);
            }
        }

        public void sortBy(Comparator<Object> comparator) {
            Collections.sort(this.data, comparator);
            int lastIndex = this.data.size() - 1;
            this.fireContentsChanged(this, 0, lastIndex);
        }
    }

    private static class FileComparator
    implements Comparator<Object> {
        protected String skip = null;
        protected boolean ascending = true;
        private Comparator<Object> comparator = Collator.getInstance();

        protected FileComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (this.skip != null && o1 instanceof String && o2 instanceof String) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                int index1 = s1.indexOf(this.skip);
                int index2 = s2.indexOf(this.skip);
                if (index1 > 0) {
                    o1 = s1.substring(index1);
                }
                if (index2 > 0) {
                    o2 = s2.substring(index2);
                }
            }
            int result = this.comparator.compare(o1, o2);
            if (!this.ascending) {
                result = -result;
            }
            return result;
        }
    }
}

