/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MJFrame;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.MidasFrame;

public class MFrame
extends Frame
implements MidasFrame {
    private static final long serialVersionUID = 2012020900311L;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_MFRAME_OBJECT_MESSAGE = "nxm.sys.libg.MFrame does NOT currently support Java Serialization";
    transient MWindow MW;
    private static Insets insets;
    private transient MBox pos;

    public MFrame(String name, MBox pos) {
        this(name, pos, (String)null);
    }

    public MFrame(String name, MBox pos, String display2) {
        this(name, pos, MJFrame.getDisplay(display2));
    }

    public MFrame(String name, MBox pos, GraphicsConfiguration display2) {
        super(name, display2);
        this.pos = pos;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setBounds(pos);
    }

    @Deprecated
    public static final GraphicsConfiguration getDisplay(String display2) {
        return MJFrame.getDisplay(display2);
    }

    @Override
    public void setBounds(MBox pos) {
        if (insets == null) {
            super.setBounds(pos.x, pos.y, pos.w, pos.h);
        } else {
            super.setBounds(pos.x - MFrame.insets.left, pos.y - MFrame.insets.top, pos.w + MFrame.insets.left + MFrame.insets.right, pos.h + MFrame.insets.top + MFrame.insets.bottom);
        }
    }

    @Override
    public void resizePanel() {
        if (this.MW == null || this.MW.panel == null) {
            return;
        }
        if (insets == null) {
            this.MW.panel.setBounds(0, 0, this.pos.w, this.pos.h);
        } else {
            this.MW.panel.setBounds(MFrame.insets.left, MFrame.insets.top, this.pos.w, this.pos.h);
        }
    }

    @Override
    public Dimension getSize() {
        Dimension d = super.getSize();
        if (insets == null) {
            return d;
        }
        d.width -= MFrame.insets.left + MFrame.insets.right;
        d.height -= MFrame.insets.top + MFrame.insets.bottom;
        return d;
    }

    @Override
    public void display(int mode) {
        if (mode >= 0) {
            this.setVisible(true);
        }
        if (mode == -3) {
            this.setVisible(false);
        }
        if (mode == 1) {
            this.setExtendedState(0);
            this.setState(0);
            this.toFront();
        }
        if (mode == 0) {
            this.toBack();
        }
        if (mode == -1) {
            this.setState(1);
        }
        if (mode == 2) {
            this.setExtendedState(6);
            this.setState(0);
            this.toFront();
        }
    }

    private void process(String name, int info, Object data) {
        if (this.MW != null) {
            this.MW.process(name, info, data);
        }
    }

    @Override
    public void setMWindow(MWindow mw) {
        this.MW = mw;
    }

    @Override
    public MWindow getMWindow() {
        return this.MW;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.MW == null || insets == null) {
            return;
        }
        Point p = this.getLocation();
        this.MW.pos.x = p.x + MFrame.insets.left;
        this.MW.pos.y = p.y + MFrame.insets.top;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.MW == null) {
            return;
        }
        Dimension d = this.getSize();
        this.MW.panel.setSize(d);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        insets = this.getInsets();
        this.setBounds(this.pos);
        this.process("WINDOW", 1, "OPENED");
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.process("WINDOW", -1, "ICONIFIED");
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.process("WINDOW", 1, "DEICONIFIED");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.process("WINDOW", 0, "CLOSING");
    }

    @Override
    public void windowClosed(WindowEvent e) {
        MWindow mw = this.MW;
        if (mw == null || mw.panel == null) {
            return;
        }
        Container panel2 = this.MW.panel;
        for (int ic = panel2.getComponentCount() - 1; ic >= 0; --ic) {
            try {
                MWindow subpanelMW;
                Component sub = panel2.getComponent(ic);
                if (!(sub instanceof MPanel) || (subpanelMW = ((MPanel)sub).MW) == null) continue;
                subpanelMW.process("WINDOW", -1, "CLOSED");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
        super.dispose();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm.getActiveWindow() == this) {
            kfm.clearGlobalFocusOwner();
        }
        this.MW = null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MFRAME_OBJECT_MESSAGE);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MFRAME_OBJECT_MESSAGE);
    }
}

