/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.LayerWMS;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.Symbol;

class LayerWmsConfig
extends JPanel
implements TreeSelectionListener,
ListSelectionListener {
    private static final StyleInfo DEFAULT_STYLE = new StyleInfo(null);
    private static final Icon ENABLED = new Symbol.CheckBox(true);
    private static final Icon DISABLED = new Symbol.CheckBox(false);
    private LayerWMS layerWms;
    private CellRendererTree rendererTree;
    private CellRendererList rendererList;
    private DefaultListModel listModel;
    private Object infoKey;
    private JComponent[] mapComponents;
    private DragListener dragListener;
    private String listDragStart = null;
    private JButton bgcolor;
    private JTextArea configuration;
    private JCheckBox debugButton;
    private JButton doneButton;
    private JSlider downloadThreads;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JLabel layerName;
    private JTextArea mapAbstract;
    private JSlider mapBrightness;
    private JButton mapBrightnessReset;
    private JSlider mapContrast;
    private JButton mapContrastReset;
    private JTextField mapCrs;
    private JCheckBox mapEnable;
    private JTextField mapId;
    private JList mapList;
    private JTextField mapMaxLat;
    private JTextField mapMaxLon;
    private JTextField mapMinLat;
    private JTextField mapMinLon;
    private JTextField mapName;
    private JPanel mapOptions;
    private JComboBox mapStyle;
    private JLabel mapTitle;
    private JTree mapTree;
    private JPanel mapsPane;
    private JPanel optionsPane;
    private JTextField statusBar;
    private JTabbedPane tabbedPane;
    private JLabel threadsButton;
    private JCheckBox transparentButton;

    public LayerWmsConfig(LayerWMS layerWms) {
        this.layerWms = layerWms;
        this.initComponents();
        this.rendererList = new CellRendererList();
        this.dragListener = new DragListener();
        this.listModel = new DefaultListModel();
        this.updateListModel();
        this.mapList.setCellRenderer(this.rendererList);
        this.mapList.setModel(this.listModel);
        this.mapList.addMouseListener(this.dragListener);
        this.mapList.addMouseListener(new ListMouseListener(this.mapList));
        this.mapList.addMouseMotionListener(this.dragListener);
        this.mapList.addListSelectionListener(this);
        TreeSelectionModel selModel = this.mapTree.getSelectionModel();
        this.rendererTree = new CellRendererTree();
        this.mapTree.addMouseListener(new TreeMouseListener(this.mapTree));
        this.mapTree.setModel(new DefaultTreeModel(this.buildTree(layerWms.getAllLayersTable())));
        this.mapTree.setCellRenderer(this.rendererTree);
        selModel.setSelectionMode(1);
        selModel.addTreeSelectionListener(this);
        this.mapComponents = new JComponent[]{this.mapEnable, this.mapName, this.mapId, this.mapStyle, this.mapAbstract, this.mapCrs, this.mapMinLat, this.mapMaxLat, this.mapMinLon, this.mapMaxLon};
        this.infoKey = "";
        this.refreshConfig();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object key = e.getPath().getLastPathComponent();
        this.showInfoFor(key);
        this.mapList.clearSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.listDragStart == null) {
            int index = this.mapList.getSelectedIndex();
            if (index >= 0) {
                String name = this.listModel.getElementAt(index).toString();
                String key = this.layerWms.findLayerKey(name);
                this.showInfoFor(key);
            } else {
                this.showInfoFor(null);
            }
        } else {
            String key = this.layerWms.findLayerKey(this.listDragStart);
            this.showInfoFor(key);
        }
        this.mapTree.clearSelection();
    }

    private void showInfoFor(Object val) {
        if (!this.layerWms.isConnected()) {
            val = null;
        }
        this.infoKey = null;
        String title = "Layer Title";
        String name = null;
        String id = "0000";
        String enableStr = "Enable";
        boolean enabled = false;
        boolean enableAll = false;
        String crs = "none";
        String srs = "none";
        String minLat = "";
        String maxLat = "";
        String minLon = "";
        String maxLon = "";
        String abstDescr = "";
        this.mapStyle.removeAllItems();
        if (val != null) {
            String key = val.toString();
            Table info = this.layerWms.getAvailableLayer(key);
            if (info != null) {
                title = info.getS("TITLE");
                name = info.getS("NAME");
                id = info.getS("IDENTIFIER");
                crs = info.getS("LOCAL_CRS", srs);
                abstDescr = info.getS("ABSTRACT", "");
                enableStr = "Enable";
                enabled = info.getState("LOCAL_ENABLED");
                Table layers = info.getTable("LOCAL_LAYERS");
                if (layers != null && layers.size() > 0) {
                    enableStr = "Enable All";
                }
                String selStyle = info.getS("LOCAL_STYLE", "");
                Table styles = info.getTable("LOCAL_STYLES");
                String[] keys = styles != null ? styles.getKeys() : new String[]{};
                for (int i = 0; i <= keys.length; ++i) {
                    StyleInfo styleInfo = i == 0 ? DEFAULT_STYLE : new StyleInfo(styles.getTable(keys[i - 1]));
                    this.mapStyle.addItem(styleInfo);
                    if (!styleInfo.equals(selStyle)) continue;
                    this.mapStyle.setSelectedIndex(i);
                }
                Table boundingBox = info.getTable("EX_GEOGRAPHICBOUNDINGBOX");
                if (boundingBox != null) {
                    minLat = boundingBox.getS("SOUTHBOUNDLATITUDE", "");
                    maxLat = boundingBox.getS("NORTHBOUNDLATITUDE", "");
                    minLon = boundingBox.getS("WESTBOUNDLONGITUDE", "");
                    maxLon = boundingBox.getS("EASTBOUNDLONGITUDE", "");
                }
            }
            enableAll = !key.equals("");
        }
        for (int i = 0; i < this.mapComponents.length; ++i) {
            this.mapComponents[i].setEnabled(enableAll);
        }
        this.mapTitle.setText(title);
        this.mapId.setText(id);
        this.mapAbstract.setText(abstDescr);
        this.mapCrs.setText(crs);
        this.mapMinLat.setText(StringUtil.padLeft(minLat, 10));
        this.mapMaxLat.setText(StringUtil.padLeft(maxLat, 10));
        this.mapMinLon.setText(StringUtil.padLeft(minLon, 10));
        this.mapMaxLon.setText(StringUtil.padLeft(maxLon, 10));
        if (name == null) {
            if (val != null) {
                enableStr = "Can Not Enable";
            }
            this.mapEnable.setText(enableStr);
            this.mapEnable.setSelected(false);
            this.mapEnable.setEnabled(false);
            this.mapName.setText("");
        } else {
            this.mapEnable.setText(enableStr);
            this.mapEnable.setSelected(enabled);
            this.mapName.setText(name);
        }
        this.infoKey = val;
    }

    private MutableTreeNode buildTree(Table tbl) {
        TreeNodeWithIcon node;
        if (this.layerWms.isConnected()) {
            node = new TreeNodeWithIcon((Object)"", null);
            this.buildTree(node, tbl, "LOCAL_LAYERS.");
        } else {
            node = new TreeNodeWithIcon((Object)"<not connected>", null);
        }
        return node;
    }

    private void buildTree(DefaultMutableTreeNode node, Table tbl, String prefix) {
        Table layers;
        Table table = layers = tbl == null ? null : tbl.getTable("LOCAL_LAYERS");
        if (layers != null) {
            String[] keys = layers.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String name = prefix + keys[i];
                Table layer = layers.getTable(keys[i]);
                TreeNodeWithIcon subNode = new TreeNodeWithIcon((Object)name, null);
                node.add(subNode);
                this.buildTree(subNode, layer, name + "." + "LOCAL_LAYERS" + ".");
            }
        }
    }

    private void updateListModel() {
        this.listModel.removeAllElements();
        if (this.layerWms.isConnected()) {
            List<Table> allLayers = this.layerWms.getAllLayersList();
            for (int i = allLayers.size() - 1; i >= 0; --i) {
                Table layer = allLayers.get(i);
                String name = layer.getS("NAME", null);
                if (name == null) continue;
                this.listModel.addElement(new ListElementWithIcon(name, null));
            }
        }
    }

    private void refreshDisplay() {
        this.layerWms.refresh();
    }

    void refreshConfig() {
        String bgcolorStr = this.layerWms.getBgColor();
        this.mapTree.repaint();
        this.updateListModel();
        this.showInfoFor(this.infoKey);
        this.mapBrightness.setValue(this.layerWms.getBrightness());
        this.mapContrast.setValue(this.layerWms.getContrast());
        this.transparentButton.setSelected(this.layerWms.getTransparent());
        this.configuration.setText(this.layerWms.getConfig().toString());
        this.downloadThreads.setValue(this.layerWms.getDownloadThreads());
        this.bgcolor.setText(bgcolorStr);
        this.bgcolor.setBackground(MColor.getColor(bgcolorStr));
        this.bgcolor.setForeground(Color.white);
        this.debugButton.setSelected(this.layerWms.getDebug());
        this.statusBar.setText(this.layerWms.getStatus());
    }

    private void initComponents() {
        this.doneButton = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.optionsPane = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.mapBrightness = new JSlider();
        this.mapContrast = new JSlider();
        this.mapBrightnessReset = new JButton();
        this.mapContrastReset = new JButton();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.debugButton = new JCheckBox();
        this.bgcolor = new JButton();
        this.jLabel13 = new JLabel();
        this.transparentButton = new JCheckBox();
        this.threadsButton = new JLabel();
        this.downloadThreads = new JSlider();
        this.jLabel14 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.configuration = new JTextArea();
        this.mapsPane = new JPanel();
        this.mapOptions = new JPanel();
        this.mapTitle = new JLabel();
        this.mapEnable = new JCheckBox();
        this.mapStyle = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.mapName = new JTextField();
        this.jLabel3 = new JLabel();
        this.mapId = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.mapMinLat = new JTextField();
        this.mapMinLon = new JTextField();
        this.mapMaxLat = new JTextField();
        this.mapMaxLon = new JTextField();
        this.jLabel8 = new JLabel();
        this.mapCrs = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.mapAbstract = new JTextArea();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.mapTree = new JTree();
        this.jScrollPane3 = new JScrollPane();
        this.mapList = new JList();
        this.layerName = new JLabel();
        this.statusBar = new JTextField();
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.doneButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Brightness:");
        this.jLabel10.setText("Contrast:");
        this.mapBrightness.setMajorTickSpacing(25);
        this.mapBrightness.setMinorTickSpacing(1);
        this.mapBrightness.setPaintLabels(true);
        this.mapBrightness.setPaintTicks(true);
        this.mapBrightness.setSnapToTicks(true);
        this.mapBrightness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayerWmsConfig.this.mapBrightnessStateChanged(evt);
            }
        });
        this.mapContrast.setMajorTickSpacing(25);
        this.mapContrast.setMinorTickSpacing(1);
        this.mapContrast.setPaintLabels(true);
        this.mapContrast.setPaintTicks(true);
        this.mapContrast.setSnapToTicks(true);
        this.mapContrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayerWmsConfig.this.mapContrastStateChanged(evt);
            }
        });
        this.mapBrightnessReset.setText("Reset");
        this.mapBrightnessReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.mapBrightnessResetActionPerformed(evt);
            }
        });
        this.mapContrastReset.setText("Reset");
        this.mapContrastReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.mapContrastResetActionPerformed(evt);
            }
        });
        this.jLabel11.setText("BgColor:");
        this.jLabel12.setText("Debug:");
        this.debugButton.setText("Output debug info to terminal.");
        this.debugButton.setToolTipText("Turns on/off debugging output. This is useful when debugging server/network problems.");
        this.debugButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.debugButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.debugButtonActionPerformed(evt);
            }
        });
        this.bgcolor.setText("color");
        this.bgcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.bgcolorActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Transparent:");
        this.transparentButton.setText("Transparent background.");
        this.transparentButton.setToolTipText("Turns on/off transparent background.");
        this.transparentButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.transparentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.transparentButtonActionPerformed(evt);
            }
        });
        this.threadsButton.setText("Download Threads:");
        this.downloadThreads.setMajorTickSpacing(5);
        this.downloadThreads.setMaximum(40);
        this.downloadThreads.setPaintLabels(true);
        this.downloadThreads.setPaintTicks(true);
        this.downloadThreads.setSnapToTicks(true);
        this.downloadThreads.setToolTipText("of image download threads.");
        this.downloadThreads.setValue(2);
        this.downloadThreads.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayerWmsConfig.this.downloadThreadsStateChanged(evt);
            }
        });
        this.jLabel14.setText("Configuration:");
        this.configuration.setColumns(20);
        this.configuration.setEditable(false);
        this.configuration.setLineWrap(true);
        this.configuration.setRows(5);
        this.jScrollPane4.setViewportView(this.configuration);
        GroupLayout optionsPaneLayout = new GroupLayout(this.optionsPane);
        this.optionsPane.setLayout(optionsPaneLayout);
        optionsPaneLayout.setHorizontalGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel9, -1, 121, Short.MAX_VALUE).addComponent(this.jLabel10, -1, 121, Short.MAX_VALUE).addComponent(this.threadsButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.downloadThreads, 0, 0, Short.MAX_VALUE).addComponent(this.mapContrast, -1, 332, Short.MAX_VALUE).addComponent(this.mapBrightness, GroupLayout.Alignment.LEADING, -1, 332, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mapBrightnessReset).addComponent(this.mapContrastReset))).addGroup(optionsPaneLayout.createSequentialGroup().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel11, GroupLayout.Alignment.LEADING, -1, 121, Short.MAX_VALUE).addComponent(this.jLabel13, GroupLayout.Alignment.LEADING, -1, 121, Short.MAX_VALUE).addComponent(this.jLabel12, GroupLayout.Alignment.LEADING, -2, 121, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.transparentButton).addComponent(this.bgcolor).addComponent(this.debugButton))).addGroup(optionsPaneLayout.createSequentialGroup().addComponent(this.jLabel14, -1, 124, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 344, -2))).addContainerGap(39, -2)))));
        optionsPaneLayout.setVerticalGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.mapBrightnessReset).addComponent(this.mapBrightness, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.mapContrast, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.threadsButton).addComponent(this.downloadThreads, -2, 57, -2))).addComponent(this.mapContrastReset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPaneLayout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14)).addGroup(optionsPaneLayout.createSequentialGroup().addComponent(this.bgcolor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transparentButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 24, Short.MAX_VALUE))).addContainerGap()));
        this.tabbedPane.addTab("Options", this.optionsPane);
        this.mapTitle.setText("Map Title");
        this.mapEnable.setText("Enabled");
        this.mapEnable.setToolTipText("Check here to enable/disable this layer.");
        this.mapEnable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mapEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.mapEnableActionPerformed(evt);
            }
        });
        this.mapStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.mapStyle.setToolTipText("Select the style for this layer.");
        this.mapStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWmsConfig.this.mapStyleActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Style:");
        this.jLabel2.setText("Name:");
        this.mapName.setEditable(false);
        this.mapName.setToolTipText("The \"readable\" name of the layer.");
        this.jLabel3.setText("ID:");
        this.mapId.setEditable(false);
        this.mapId.setToolTipText("The server's name for this layer.");
        this.jLabel4.setText("Abstract:");
        this.jLabel5.setText("Bounding Box:");
        this.mapMinLat.setEditable(false);
        this.mapMinLat.setFont(new Font("Monospaced", 0, 12));
        this.mapMinLat.setHorizontalAlignment(4);
        this.mapMinLat.setText("dd'mm'ss.sssN");
        this.mapMinLat.setToolTipText("Minimum Latitude");
        this.mapMinLon.setEditable(false);
        this.mapMinLon.setFont(new Font("Monospaced", 0, 12));
        this.mapMinLon.setHorizontalAlignment(4);
        this.mapMinLon.setText("ddd'mm'ss.sssE");
        this.mapMinLon.setToolTipText("Minimum Longitude");
        this.mapMaxLat.setEditable(false);
        this.mapMaxLat.setFont(new Font("Monospaced", 0, 12));
        this.mapMaxLat.setHorizontalAlignment(4);
        this.mapMaxLat.setText("dd'mm'ss.sssN");
        this.mapMaxLat.setToolTipText("Maximum Latitude");
        this.mapMaxLon.setEditable(false);
        this.mapMaxLon.setFont(new Font("Monospaced", 0, 12));
        this.mapMaxLon.setHorizontalAlignment(4);
        this.mapMaxLon.setText("ddd'mm'ss.sssE");
        this.mapMaxLon.setToolTipText("Maximum Longitude");
        this.jLabel8.setText("CRS:");
        this.mapCrs.setEditable(false);
        this.mapCrs.setToolTipText("List of available geographic Coordinate Reference Systems (CRS) available.");
        this.jLabel7.setText("Lon:");
        this.jLabel6.setText("Lat:");
        this.mapAbstract.setEditable(false);
        this.mapAbstract.setLineWrap(true);
        this.mapAbstract.setTabSize(2);
        this.mapAbstract.setToolTipText("A description of the layer, if available from the server.");
        this.mapAbstract.setWrapStyleWord(true);
        this.mapAbstract.setOpaque(false);
        this.jScrollPane2.setViewportView(this.mapAbstract);
        GroupLayout mapOptionsLayout = new GroupLayout(this.mapOptions);
        this.mapOptions.setLayout(mapOptionsLayout);
        mapOptionsLayout.setHorizontalGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapOptionsLayout.createSequentialGroup().addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mapOptionsLayout.createSequentialGroup().addContainerGap().addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mapOptionsLayout.createSequentialGroup().addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, 160, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, 160, Short.MAX_VALUE)).addGap(107, 107, 107)).addGroup(mapOptionsLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mapMinLat).addComponent(this.mapMinLon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.mapMaxLat).addComponent(this.mapMaxLon))).addGroup(mapOptionsLayout.createSequentialGroup().addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, GroupLayout.Alignment.LEADING, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapName, -1, 202, Short.MAX_VALUE).addComponent(this.mapId, -1, 202, Short.MAX_VALUE).addComponent(this.mapStyle, 0, 202, Short.MAX_VALUE).addComponent(this.mapCrs, -1, 202, Short.MAX_VALUE))))).addGroup(mapOptionsLayout.createSequentialGroup().addContainerGap().addComponent(this.mapEnable, -1, 267, Short.MAX_VALUE)).addComponent(this.mapTitle, -1, 279, Short.MAX_VALUE).addGroup(mapOptionsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2))).addContainerGap()));
        mapOptionsLayout.setVerticalGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapOptionsLayout.createSequentialGroup().addComponent(this.mapTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.mapName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.mapId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mapStyle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.mapCrs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.mapMinLat, -2, -1, -2).addComponent(this.mapMaxLat, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.mapMinLon, -2, -1, -2).addComponent(this.mapMaxLon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 26, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.setToolTipText("Show all maps in a tree view.");
        this.mapTree.setToolTipText("Available layers as categorized by the server.");
        this.jScrollPane1.setViewportView(this.mapTree);
        this.jTabbedPane1.addTab("Tree View", this.jScrollPane1);
        this.mapList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.mapList.setSelectionMode(0);
        this.mapList.setToolTipText("Stacking order of the layers, layers on the top are drawn on top of layers on the bottom.");
        this.jScrollPane3.setViewportView(this.mapList);
        this.jTabbedPane1.addTab("Priority View", this.jScrollPane3);
        GroupLayout mapsPaneLayout = new GroupLayout(this.mapsPane);
        this.mapsPane.setLayout(mapsPaneLayout);
        mapsPaneLayout.setHorizontalGroup(mapsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mapsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 222, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapOptions, -2, -1, -2)));
        mapsPaneLayout.setVerticalGroup(mapsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapOptions, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(mapsPaneLayout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 313, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("Maps", this.mapsPane);
        this.layerName.setText("LayerWMS Configuration");
        this.statusBar.setEditable(false);
        this.statusBar.setToolTipText("Current application status.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusBar, -1, 539, Short.MAX_VALUE).addComponent(this.layerName).addComponent(this.doneButton, GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane, -1, 539, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.layerName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 362, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doneButton).addContainerGap()));
    }

    private void downloadThreadsStateChanged(ChangeEvent evt) {
        this.layerWms.setDownloadThreads(this.downloadThreads.getValue());
        this.refreshDisplay();
    }

    private void transparentButtonActionPerformed(ActionEvent evt) {
        this.layerWms.setTransparent(this.transparentButton.isSelected());
        this.refreshDisplay();
    }

    private void debugButtonActionPerformed(ActionEvent evt) {
        this.layerWms.setDebug(this.debugButton.isSelected());
        this.refreshDisplay();
    }

    private void bgcolorActionPerformed(ActionEvent evt) {
        Color color = MJPopup.showColor(this, "Background Color", -1, "Select background color", this.layerWms.getBgColor());
        if (color != null) {
            this.layerWms.setBgColor(color);
        }
    }

    private void mapContrastStateChanged(ChangeEvent evt) {
        this.layerWms.setContrast(this.mapContrast.getValue());
    }

    private void mapBrightnessStateChanged(ChangeEvent evt) {
        this.layerWms.setBrightness(this.mapBrightness.getValue());
    }

    private void mapContrastResetActionPerformed(ActionEvent evt) {
        this.layerWms.setContrast(50);
    }

    private void mapBrightnessResetActionPerformed(ActionEvent evt) {
        this.layerWms.setBrightness(50);
    }

    private void mapStyleActionPerformed(ActionEvent evt) {
        if (this.infoKey != null) {
            StyleInfo sty = (StyleInfo)this.mapStyle.getSelectedItem();
            Table info = this.layerWms.getAvailableLayer(this.infoKey.toString());
            info.put("LOCAL_STYLE", (Object)sty.getName());
            this.refreshDisplay();
        }
    }

    private void mapEnableActionPerformed(ActionEvent evt) {
        if (this.infoKey != null) {
            Table info = this.layerWms.getAvailableLayer(this.infoKey.toString());
            info.put("LOCAL_ENABLED", this.mapEnable.isSelected());
            this.refreshDisplay();
        }
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.layerWms.setConfigPanelVisible(false);
    }

    private void greyscaleButtonActionPerformed(ActionEvent evt) {
        boolean gs = this.layerWms.getGreyscale();
        this.layerWms.setGreyscale(!gs);
    }

    private Icon getCheckbox(String key, boolean enabled) {
        Icon icon = enabled ? ENABLED : DISABLED;
        return key.equals("") ? null : icon;
    }

    private class ListMouseListener
    extends IconSelectionListener {
        private final JList list;

        public ListMouseListener(JList list3) {
            this.list = list3;
        }

        @Override
        protected int getRow(MouseEvent e) {
            return this.list.locationToIndex(e.getPoint());
        }

        @Override
        protected SaveSizeIcon getIcon(MouseEvent e, int row) {
            Object val = this.list.getModel().getElementAt(row);
            return val instanceof SaveSizeIcon ? (SaveSizeIcon)val : null;
        }

        @Override
        protected void iconClicked(SaveSizeIcon icon) {
            if (LayerWmsConfig.this.infoKey != null) {
                Table info;
                boolean selected = (info = LayerWmsConfig.this.layerWms.getAvailableLayer(LayerWmsConfig.this.infoKey.toString())).getState("LOCAL_ENABLED");
                info.put("LOCAL_ENABLED", !selected);
                LayerWmsConfig.this.refreshDisplay();
            }
        }
    }

    private class TreeMouseListener
    extends IconSelectionListener {
        private final JTree tree;

        public TreeMouseListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        protected int getRow(MouseEvent e) {
            return this.tree.getRowForLocation(e.getX(), e.getY());
        }

        @Override
        protected SaveSizeIcon getIcon(MouseEvent e, int row) {
            TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
            Object val = selPath.getLastPathComponent();
            return val instanceof SaveSizeIcon ? (SaveSizeIcon)val : null;
        }

        @Override
        protected void iconClicked(SaveSizeIcon icon) {
            if (LayerWmsConfig.this.infoKey != null) {
                Table info;
                boolean selected = (info = LayerWmsConfig.this.layerWms.getAvailableLayer(LayerWmsConfig.this.infoKey.toString())).getState("LOCAL_ENABLED");
                info.put("LOCAL_ENABLED", !selected);
                LayerWmsConfig.this.refreshDisplay();
            }
        }
    }

    private abstract class IconSelectionListener
    extends MouseAdapter {
        private IconSelectionListener() {
        }

        protected abstract int getRow(MouseEvent var1);

        protected abstract SaveSizeIcon getIcon(MouseEvent var1, int var2);

        @Override
        public void mousePressed(MouseEvent e) {
            SaveSizeIcon icon;
            int button = e.getButton();
            int selRow = this.getRow(e);
            if (selRow != -1 && button == 1 && e.getClickCount() == 1 && (icon = this.getIcon(e, selRow)) != null && icon.getIconBounds().contains(e.getX(), e.getY())) {
                this.iconClicked(icon);
            }
        }

        protected abstract void iconClicked(SaveSizeIcon var1);
    }

    private static class ListElementWithIcon
    implements SaveSizeIcon {
        private final Rectangle bounds = new Rectangle();
        private Icon icon = null;
        private Object userObj = null;

        public ListElementWithIcon(Object userObject, Icon icon) {
            this.icon = icon;
            this.userObj = userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObj = userObject;
        }

        public Object getUserObject() {
            return this.userObj;
        }

        public String toString() {
            return this.userObj == null ? null : this.userObj.toString();
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Rectangle getIconBounds() {
            return this.bounds;
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? 0 : this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x, y);
            }
            this.bounds.setRect(x + c.getX(), y + c.getY(), this.getIconWidth(), this.getIconHeight());
        }
    }

    private static class TreeNodeWithIcon
    extends DefaultMutableTreeNode
    implements SaveSizeIcon {
        private final Rectangle bounds = new Rectangle();
        private Icon icon = null;

        public TreeNodeWithIcon(Object userObject, Icon icon) {
            super(userObject);
            this.icon = icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Rectangle getIconBounds() {
            return this.bounds;
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? 0 : this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x, y);
            }
            this.bounds.setRect(x + c.getX(), y + c.getY(), this.getIconWidth(), this.getIconHeight());
        }
    }

    private static interface SaveSizeIcon
    extends Icon {
        public Rectangle getIconBounds();
    }

    private class DragListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int last = -1;

        private DragListener() {
        }

        @Override
        public void mouseReleased(MouseEvent m) {
            if (LayerWmsConfig.this.listDragStart != null) {
                LayerWmsConfig.this.listModel.removeElement(null);
                int index = LayerWmsConfig.this.listModel.size() - this.last + 1;
                if (LayerWmsConfig.this.layerWms.moveAvailableLayer(LayerWmsConfig.this.listDragStart, index)) {
                    LayerWmsConfig.this.mapTree.clearSelection();
                }
                LayerWmsConfig.this.listDragStart = null;
                this.last = -1;
            }
        }

        @Override
        public void mouseDragged(MouseEvent m) {
            this.last = LayerWmsConfig.this.mapList.getSelectedIndex();
            if (this.last >= 0) {
                if (LayerWmsConfig.this.listDragStart != null) {
                    LayerWmsConfig.this.listModel.removeElement(null);
                    LayerWmsConfig.this.listModel.insertElementAt(null, this.last);
                    LayerWmsConfig.this.showInfoFor(null);
                } else {
                    LayerWmsConfig.this.listDragStart = LayerWmsConfig.this.listModel.getElementAt(this.last).toString();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class CellRendererList
    extends DefaultListCellRenderer {
        private final Border normalBorder;
        private final Border insertBorder;

        public CellRendererList() {
            this.setIcon(null);
            this.normalBorder = this.getBorder();
            this.insertBorder = new LineBorder(this.getForeground(), 2, true);
        }

        @Override
        public Component getListCellRendererComponent(JList list3, Object val, int index, boolean sel, boolean focus) {
            Component comp;
            Icon icon;
            String name;
            Border border;
            boolean enabled = true;
            if (val == null) {
                border = this.insertBorder;
                name = LayerWmsConfig.this.listDragStart;
            } else {
                border = this.normalBorder;
                name = val.toString();
            }
            Table info = LayerWmsConfig.this.layerWms.findAvailableLayer(name);
            boolean enable = info == null ? false : info.getState("LOCAL_ENABLED");
            String title = info == null ? null : info.getS("TITLE");
            Icon icon2 = icon = val == null ? null : LayerWmsConfig.this.getCheckbox(name, enable);
            if (LayerWmsConfig.this.listDragStart != null) {
                sel = false;
                focus = false;
                boolean bl = enabled = !LayerWmsConfig.this.listDragStart.equals(name) && val != null;
            }
            if (val instanceof ListElementWithIcon) {
                ListElementWithIcon lewi = (ListElementWithIcon)val;
                lewi.setIcon(icon);
                icon = lewi;
            }
            if ((comp = super.getListCellRendererComponent((JList<?>)list3, title, index, sel, focus)) instanceof CellRendererList) {
                CellRendererList cr = (CellRendererList)comp;
                cr.setBorder(border);
                cr.setEnabled(enabled);
                cr.setIcon(icon);
                cr.setDisabledIcon(icon);
            }
            return comp;
        }
    }

    private class CellRendererTree
    extends DefaultTreeCellRenderer {
        public CellRendererTree() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            Component comp = super.getTreeCellRendererComponent(tree, val, sel, exp, leaf, row, focus);
            if (comp instanceof CellRendererTree) {
                CellRendererTree cr = (CellRendererTree)comp;
                String key = val.toString();
                Table info = LayerWmsConfig.this.layerWms.getAvailableLayer(key);
                if (info != null) {
                    String title = info.getS("TITLE");
                    boolean enabled = info.getState("LOCAL_ENABLED");
                    Icon icon = LayerWmsConfig.this.getCheckbox(key, enabled);
                    if (val instanceof TreeNodeWithIcon) {
                        TreeNodeWithIcon tnwi = (TreeNodeWithIcon)val;
                        tnwi.setIcon(icon);
                        icon = tnwi;
                    }
                    cr.setIcon(icon);
                    cr.setText(title);
                }
            }
            return comp;
        }
    }

    private static class StyleInfo {
        private Table style;

        private StyleInfo(Table style) {
            this.style = style;
        }

        public String toString() {
            return this.style == null ? "<Default>" : this.style.getS("TITLE", this.getName());
        }

        public String getName() {
            return this.style == null ? "" : this.style.getS("NAME");
        }

        public boolean equals(Object obj) {
            String thisName = this.getName();
            String otherName = obj == null ? "" : (obj instanceof StyleInfo ? ((StyleInfo)obj).getName() : obj.toString());
            return thisName.equals(otherName);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

